/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationScreenHandler;

public class CraftingWorkstationScreen
extends AbstractContainerScreen<CraftingWorkstationScreenHandler> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "textures/gui/container/crafting_table.png");
    private ItemStack[] localRecipeTemplate = new ItemStack[9];
    private ItemStack localExpectedOutput = ItemStack.f_41583_;
    private List<CraftingRecipe> matchingRecipes = new ArrayList<CraftingRecipe>();
    private int currentRecipeIndex = 0;

    public CraftingWorkstationScreen(CraftingWorkstationScreenHandler handler, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)handler, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        ItemStack[] serverTemplate = handler.getRecipeTemplate();
        for (int i = 0; i < 9; ++i) {
            this.localRecipeTemplate[i] = serverTemplate != null && serverTemplate[i] != null ? serverTemplate[i].m_41777_() : ItemStack.f_41583_;
        }
        ItemStack serverOutput = handler.getExpectedOutput();
        this.localExpectedOutput = serverOutput != null ? serverOutput.m_41777_() : ItemStack.f_41583_;
        boolean hasRecipe = false;
        for (int i = 0; i < 9; ++i) {
            if (this.localRecipeTemplate[i] == null || this.localRecipeTemplate[i].m_41619_()) continue;
            hasRecipe = true;
            break;
        }
        if (hasRecipe) {
            this.updateExpectedOutput();
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.inventory"), button -> this.openInventory()).m_252794_(this.f_97735_ + this.f_97726_ - 57, this.f_97736_ + 3).m_253046_(50, 13).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.apply"), button -> this.applyRecipe()).m_252794_(this.f_97735_ + 124, this.f_97736_ + 62).m_253046_(46, 20).m_253136_());
        if (this.matchingRecipes.size() > 1) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), button -> this.previousRecipe()).m_252794_(this.f_97735_ + 110, this.f_97736_ + 35).m_253046_(12, 16).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), button -> this.nextRecipe()).m_252794_(this.f_97735_ + 142, this.f_97736_ + 35).m_253046_(12, 16).m_253136_());
        }
    }

    private void openInventory() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            ClientPacketHandler.sendOpenCraftingInventory(((CraftingWorkstationScreenHandler)this.f_97732_).getBlockEntity().m_58899_());
        }
    }

    private void applyRecipe() {
        ClientPacketHandler.sendCraftingRecipeUpdate(((CraftingWorkstationScreenHandler)this.f_97732_).getBlockEntity().m_58899_(), this.localRecipeTemplate, this.localExpectedOutput);
        if (this.f_96541_ != null) {
            this.m_7379_();
        }
    }

    private void previousRecipe() {
        if (this.matchingRecipes.size() > 1) {
            this.currentRecipeIndex = (this.currentRecipeIndex - 1 + this.matchingRecipes.size()) % this.matchingRecipes.size();
            this.updateOutputFromCurrentRecipe();
        }
    }

    private void nextRecipe() {
        if (this.matchingRecipes.size() > 1) {
            this.currentRecipeIndex = (this.currentRecipeIndex + 1) % this.matchingRecipes.size();
            this.updateOutputFromCurrentRecipe();
        }
    }

    private void updateOutputFromCurrentRecipe() {
        if (this.currentRecipeIndex >= 0 && this.currentRecipeIndex < this.matchingRecipes.size()) {
            TransientCraftingContainer craftingInventory = this.createCraftingContainer();
            this.localExpectedOutput = this.matchingRecipes.get(this.currentRecipeIndex).m_5874_((Container)craftingInventory, this.f_96541_.f_91073_.m_9598_());
        }
    }

    private TransientCraftingContainer createCraftingContainer() {
        TransientCraftingContainer craftingInventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            public ItemStack m_7648_(Player player, int slot) {
                return ItemStack.f_41583_;
            }

            public boolean m_6875_(Player player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            if (this.localRecipeTemplate[i] == null) continue;
            craftingInventory.m_6836_(i, this.localRecipeTemplate[i].m_41777_());
        }
        return craftingInventory;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        this.renderRecipeView(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    private void renderRecipeView(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int index = row * 3 + col;
                int x = this.f_97735_ + 30 + col * 18;
                int y = this.f_97736_ + 17 + row * 18;
                graphics.m_280509_(x - 1, y - 1, x + 17, y + 17, -7631989);
                graphics.m_280509_(x, y, x + 16, y + 16, -13158601);
                if (this.localRecipeTemplate[index] == null || this.localRecipeTemplate[index].m_41619_()) continue;
                graphics.m_280480_(this.localRecipeTemplate[index], x, y);
            }
        }
        int outputX = this.f_97735_ + 124;
        int outputY = this.f_97736_ + 35;
        graphics.m_280509_(outputX - 1, outputY - 1, outputX + 17, outputY + 17, -7631989);
        graphics.m_280509_(outputX, outputY, outputX + 16, outputY + 16, -13158601);
        if (this.localExpectedOutput != null && !this.localExpectedOutput.m_41619_()) {
            graphics.m_280480_(this.localExpectedOutput, outputX, outputY);
            graphics.m_280370_(this.f_96547_, this.localExpectedOutput, outputX, outputY);
        }
        graphics.m_280218_(TEXTURE, this.f_97735_ + 90, this.f_97736_ + 35, 176, 0, 22, 15);
        if (this.matchingRecipes.size() > 1) {
            String recipeInfo = this.currentRecipeIndex + 1 + "/" + this.matchingRecipes.size();
            graphics.m_280137_(this.f_96547_, recipeInfo, this.f_97735_ + 133, this.f_97736_ + 55, 0x404040);
        }
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    protected void m_7286_(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        graphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        super.m_6375_(mouseX, mouseY, button);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int index = row * 3 + col;
                int x = this.f_97735_ + 30 + col * 18;
                int y = this.f_97736_ + 17 + row * 18;
                if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 16)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + 16))) continue;
                if (button == 0) {
                    ItemStack carriedStack = this.f_96541_.f_91074_.f_36096_.m_142621_();
                    if (!carriedStack.m_41619_()) {
                        this.localRecipeTemplate[index] = carriedStack.m_41777_();
                        this.localRecipeTemplate[index].m_41764_(1);
                        this.updateExpectedOutput();
                        return true;
                    }
                    ItemStack mainHandStack = this.f_96541_.f_91074_.m_21205_();
                    if (mainHandStack.m_41619_()) continue;
                    this.localRecipeTemplate[index] = mainHandStack.m_41777_();
                    this.localRecipeTemplate[index].m_41764_(1);
                    this.updateExpectedOutput();
                    return true;
                }
                if (button != 1) continue;
                this.localRecipeTemplate[index] = ItemStack.f_41583_;
                this.updateExpectedOutput();
                return true;
            }
        }
        int outputX = this.f_97735_ + 124;
        int outputY = this.f_97736_ + 35;
        if (!(mouseX >= (double)outputX) || !(mouseX < (double)(outputX + 16)) || !(mouseY >= (double)outputY) || mouseY < (double)(outputY + 16)) {
            // empty if block
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        ItemStack heldStack;
        if (this.f_97734_ != null && this.f_97734_.m_6657_() && !(heldStack = this.f_97734_.m_7993_()).m_41619_()) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    int index = row * 3 + col;
                    int x = this.f_97735_ + 30 + col * 18;
                    int y = this.f_97736_ + 17 + row * 18;
                    if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 16)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + 16))) continue;
                    this.localRecipeTemplate[index] = heldStack.m_41777_();
                    this.localRecipeTemplate[index].m_41764_(1);
                    this.updateExpectedOutput();
                    return true;
                }
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void updateExpectedOutput() {
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            TransientCraftingContainer craftingInventory = this.createCraftingContainer();
            this.matchingRecipes.clear();
            this.currentRecipeIndex = 0;
            RecipeManager recipeManager = this.f_96541_.f_91073_.m_7465_();
            for (CraftingRecipe recipe : recipeManager.m_44013_(RecipeType.f_44107_)) {
                if (!recipe.m_5818_((Container)craftingInventory, (Level)this.f_96541_.f_91073_)) continue;
                this.matchingRecipes.add(recipe);
            }
            this.localExpectedOutput = !this.matchingRecipes.isEmpty() ? this.matchingRecipes.get(0).m_5874_((Container)craftingInventory, this.f_96541_.f_91073_.m_9598_()) : ItemStack.f_41583_;
            this.m_7856_();
        }
    }
}

