/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.structure;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.structure.BuildModeRenderer;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.RequestTemplateSizePacket;

@Mod.EventBusSubscriber(modid="hundred_years_war", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class BuildModeHandler {
    private static boolean buildModeEnabled = false;
    private static String activeTemplate = "";
    private static BlockHitResult lastHitResult = null;
    private static Rotation rotation = Rotation.NONE;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && buildModeEnabled && Freecam.isEnabled()) {
            BuildModeHandler.detectHitResult();
        }
    }

    private static void detectHitResult() {
        HitResult result;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && minecraft.f_91073_ != null && (result = Freecam.getFreeCamera().camPick(200.0, 0.0f, true, false)) instanceof BlockHitResult) {
            lastHitResult = (BlockHitResult)result;
        }
    }

    public static BlockPos getCenterPosition() {
        if (lastHitResult == null || BuildModeRenderer.getStructureSize() == null) {
            return null;
        }
        BlockPos position1 = lastHitResult.m_82425_();
        while (!BuildModeHandler.isSolidBlock(position1) && position1.m_123342_() > 0) {
            position1 = position1.m_7495_();
        }
        return position1;
    }

    public static BlockPos getBuildPosition() {
        if (lastHitResult == null || BuildModeRenderer.getStructureSize() == null) {
            return null;
        }
        BlockPos position1 = lastHitResult.m_82425_();
        Vec3i rotatedSize = BuildModeRenderer.rotateVec3i(BuildModeRenderer.getStructureSize(), rotation);
        while (!BuildModeHandler.isSolidBlock(position1) && position1.m_123342_() > 0) {
            position1 = position1.m_7495_();
        }
        int offsetX = rotatedSize.m_123341_() / 2;
        int offsetY = rotatedSize.m_123342_() / 2;
        int offsetZ = rotatedSize.m_123343_() / 2;
        if (rotatedSize.m_123341_() % 2 == 0) {
            --offsetX;
        }
        if (rotatedSize.m_123342_() % 2 == 0) {
            --offsetY;
        }
        if (rotatedSize.m_123343_() % 2 == 0) {
            --offsetZ;
        }
        BlockPos position2 = position1.m_7918_(-offsetX, 0, -offsetZ);
        return position2;
    }

    private static boolean isSolidBlock(BlockPos pos) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        BlockState blockState = Minecraft.m_91087_().f_91073_.m_8055_(pos);
        return blockState.m_60804_((BlockGetter)Minecraft.m_91087_().f_91073_, pos);
    }

    public static int toggleBuildMode(CommandContext<CommandSourceStack> context) {
        buildModeEnabled = !buildModeEnabled;
        return 1;
    }

    public static void toggleBuildMode() {
        buildModeEnabled = !buildModeEnabled;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && minecraft.f_91074_.m_7500_()) {
            MutableComponent message = Component.m_237115_((String)"msg.hyw.buildMode").m_7220_((Component)Component.m_237115_((String)(buildModeEnabled ? "msg.hyw.enabled" : "msg.hyw.disabled")).m_130940_(buildModeEnabled ? ChatFormatting.GREEN : ChatFormatting.RED));
            minecraft.f_91074_.m_5661_((Component)message, true);
        }
    }

    public static int setActiveTemplate(CommandContext<CommandSourceStack> context) {
        activeTemplate = StringArgumentType.getString(context, (String)"template");
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"msg.hyw.active_template", (Object[])new Object[]{activeTemplate}), true);
        RequestTemplateSizePacket packet = new RequestTemplateSizePacket(activeTemplate);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
        return 1;
    }

    public static void rotateStructure() {
        switch (rotation) {
            case NONE: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case CLOCKWISE_90: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case CLOCKWISE_180: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                rotation = Rotation.NONE;
            }
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            minecraft.f_91074_.m_5661_((Component)Component.m_237110_((String)"msg.hyw.structure_rotated", (Object[])new Object[]{rotation}), true);
        }
    }

    public static Rotation getRotation() {
        return rotation;
    }

    public static boolean isBuildModeEnabled() {
        return buildModeEnabled;
    }

    public static String getActiveTemplate() {
        return activeTemplate;
    }

    public static BlockHitResult getLastHitResult() {
        return lastHitResult;
    }
}

