/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class TooltipHelper {
    private static final float MAX_WIDTH_RATIO = 0.3f;

    public static List<Component> splitComponent(Component component) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null) {
            ArrayList<Component> result = new ArrayList<Component>();
            result.add(component);
            return result;
        }
        Font font = minecraft.f_91062_;
        int maxWidth = (int)((float)minecraft.m_91268_().m_85445_() * 0.3f);
        String fullText = component.getString();
        Style style = component.m_7383_();
        if (font.m_92895_(fullText) <= maxWidth) {
            ArrayList<Component> result = new ArrayList<Component>();
            result.add(component);
            return result;
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        String[] words = fullText.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() > 0 ? currentLine + " " + word : word;
            if (font.m_92895_(testLine) > maxWidth && currentLine.length() > 0) {
                lines.add((Component)Component.m_237113_((String)currentLine.toString()).m_130948_(style));
                currentLine = new StringBuilder(word);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add((Component)Component.m_237113_((String)currentLine.toString()).m_130948_(style));
        }
        if (lines.isEmpty()) {
            lines.add(component);
        }
        return lines;
    }

    public static void processTooltip(List<Component> tooltip) {
        ArrayList<Component> processedLines = new ArrayList<Component>();
        for (Component line : tooltip) {
            List<Component> splitLines = TooltipHelper.splitComponent(line);
            processedLines.addAll(splitLines);
        }
        tooltip.clear();
        tooltip.addAll(processedLines);
    }

    public static void addToTooltip(List<Component> tooltip, Component component) {
        List<Component> splitLines = TooltipHelper.splitComponent(component);
        tooltip.addAll(splitLines);
    }
}

