/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.structure.ConstructionManager;
import ydmsama.hundred_years_war.main.structure.ConstructionTask;

public class BaseStructureCoreBlockEntity
extends BlockEntity {
    private String templateName = "";
    private Vec3i size = Vec3i.f_123288_;
    private Rotation rotation = Rotation.NONE;
    private Mirror mirror = Mirror.NONE;
    private BlockPos placementPos = BlockPos.f_121853_;
    private boolean taskComplete = false;
    private int currentBlockIndex = 0;
    private int currentBatchIndex = 0;
    private AABB boundingBox;
    private boolean selected;

    public BaseStructureCoreBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BASE_STRUCTURE_CORE.get(), pos, state);
    }

    public void setTemplateData(String templateName, Vec3i size, Rotation rotation, Mirror mirror, BlockPos placementPos) {
        this.templateName = templateName;
        this.size = size;
        this.rotation = rotation;
        this.mirror = mirror;
        this.placementPos = placementPos;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, blockEntity -> tag);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void setTaskComplete(boolean taskComplete) {
        this.taskComplete = taskComplete;
    }

    public boolean isTaskComplete() {
        return this.taskComplete;
    }

    public void setCurrentBlockIndex(int currentBlockIndex) {
        this.currentBlockIndex = currentBlockIndex;
    }

    public int getCurrentBlockIndex() {
        return this.currentBlockIndex;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("TemplateName", this.templateName);
        tag.m_128385_("Size", new int[]{this.size.m_123341_(), this.size.m_123342_(), this.size.m_123343_()});
        tag.m_128359_("Rotation", this.rotation.name());
        tag.m_128359_("Mirror", this.mirror.name());
        tag.m_128385_("PlacementPos", new int[]{this.placementPos.m_123341_(), this.placementPos.m_123342_(), this.placementPos.m_123343_()});
        tag.m_128379_("TaskComplete", this.taskComplete);
        tag.m_128405_("CurrentBlockIndex", this.currentBlockIndex);
        tag.m_128405_("CurrentBatchIndex", this.currentBatchIndex);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.templateName = tag.m_128461_("TemplateName");
        int[] sizeArray = tag.m_128465_("Size");
        if (sizeArray.length == 3) {
            this.size = new Vec3i(sizeArray[0], sizeArray[1], sizeArray[2]);
        }
        this.rotation = Rotation.valueOf((String)tag.m_128461_("Rotation"));
        this.mirror = Mirror.valueOf((String)tag.m_128461_("Mirror"));
        int[] posArray = tag.m_128465_("PlacementPos");
        if (posArray.length == 3) {
            this.placementPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        }
        this.taskComplete = tag.m_128471_("TaskComplete");
        this.currentBlockIndex = tag.m_128451_("CurrentBlockIndex");
        this.currentBatchIndex = tag.m_128451_("CurrentBatchIndex");
        if (this.currentBatchIndex != 1 && !this.taskComplete) {
            ConstructionManager.addBlockEntityToRestore(this);
        }
        this.updateBoundingBox();
    }

    public void restoreTask(ServerLevel serverLevel) {
        ResourceLocation structureLocation;
        StructureTemplateManager structureTemplateManager = serverLevel.m_215082_();
        Optional structureTemplateOptional = structureTemplateManager.m_230407_(structureLocation = new ResourceLocation("hundred_years_war", this.templateName));
        if (structureTemplateOptional.isPresent()) {
            StructureTemplate structureTemplate = (StructureTemplate)structureTemplateOptional.get();
            StructurePlaceSettings placeSettings = new StructurePlaceSettings();
            placeSettings.m_74379_(this.rotation);
            placeSettings.m_74377_(this.mirror);
            ConstructionTask task = new ConstructionTask(serverLevel, structureTemplate, placeSettings, this.placementPos, 1200, this.templateName, this.currentBlockIndex, this);
            ConstructionManager.addTask(task);
        }
    }

    public Vec3i getSize() {
        return this.size;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public BlockPos getPlacementPos() {
        return this.placementPos;
    }

    public void setCurrentBatchIndex(int currentBatchIndex) {
        this.currentBatchIndex = currentBatchIndex;
    }

    public int getCurrentBatchIndex() {
        return this.currentBatchIndex;
    }

    public AABB getBoundingBox() {
        return this.boundingBox;
    }

    public void updateBoundingBox() {
        Vec3i structureSize = this.size;
        Rotation rotation = this.rotation;
        BlockPos placementPos = this.placementPos;
        BlockPos entityPos = this.m_58899_();
        if (structureSize != null && structureSize.m_123341_() > 0 && structureSize.m_123342_() > 0 && structureSize.m_123343_() > 0) {
            Vec3i rotatedSize = this.rotateVec3i(structureSize, rotation);
            BlockPos offset = this.calculateOffset(structureSize, rotation);
            double dx = placementPos.m_123341_() - entityPos.m_123341_();
            double dy = placementPos.m_123342_() - entityPos.m_123342_();
            double dz = placementPos.m_123343_() - entityPos.m_123343_();
            double startX = (double)offset.m_123341_() + dx;
            double startY = (double)offset.m_123342_() + dy;
            double startZ = (double)offset.m_123343_() + dz;
            double endX = startX + (double)rotatedSize.m_123341_();
            double endY = startY + (double)rotatedSize.m_123342_();
            double endZ = startZ + (double)rotatedSize.m_123343_();
            this.boundingBox = new AABB(startX, startY, startZ, endX, endY, endZ);
        }
    }

    private Vec3i rotateVec3i(Vec3i vec, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new Vec3i(-vec.m_123343_(), vec.m_123342_(), vec.m_123341_());
            case Rotation.CLOCKWISE_180 -> new Vec3i(-vec.m_123341_(), vec.m_123342_(), -vec.m_123343_());
            case Rotation.COUNTERCLOCKWISE_90 -> new Vec3i(vec.m_123343_(), vec.m_123342_(), -vec.m_123341_());
            default -> vec;
        };
    }

    private BlockPos calculateOffset(Vec3i vec, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new BlockPos(1, 0, 0);
            case Rotation.CLOCKWISE_180 -> new BlockPos(1, 0, 1);
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(0, 0, 1);
            default -> BlockPos.f_121853_;
        };
    }

    public AABB getAbsoluteBoundingBox() {
        if (this.boundingBox == null) {
            return null;
        }
        BlockPos entityPos = this.m_58899_();
        return this.boundingBox.m_82386_((double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_());
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

