/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import ydmsama.hundred_years_war.main.blocks.workstation.BaseWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.MiningWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.utils.ChunkLoadingUtils;

public abstract class BoundedWorkstationBlockEntity
extends BaseWorkstationBlockEntity {
    protected int workRangeLeft = 2;
    protected int workRangeRight = 2;
    protected int workRangeUp = 2;
    protected int workRangeDown = 0;
    protected boolean showRange = false;
    private boolean chunkLoadingActive = false;
    private boolean rangeChunkLoadingActive = false;
    private BlockPos lastRangeMin = null;
    private BlockPos lastRangeMax = null;
    protected BlockPos workCenter;

    public BoundedWorkstationBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.chunkLoadingActive) {
                ChunkLoadingUtils.addWorkstationChunkLoading(serverLevel, this.m_58899_());
                this.chunkLoadingActive = true;
                if (this.shouldLoadWorkRange() && this.activated) {
                    this.updateRangeChunkLoading();
                }
            }
        }
    }

    public void m_7651_() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.chunkLoadingActive) {
                ChunkLoadingUtils.removeWorkstationChunkLoading(serverLevel, this.m_58899_());
                this.chunkLoadingActive = false;
            }
            if (this.rangeChunkLoadingActive && this.lastRangeMin != null && this.lastRangeMax != null) {
                ChunkLoadingUtils.removeWorkstationRangeChunkLoading(serverLevel, this.lastRangeMin, this.lastRangeMax);
                this.rangeChunkLoadingActive = false;
                this.lastRangeMin = null;
                this.lastRangeMax = null;
            }
        }
        super.m_7651_();
    }

    public void m_6339_() {
        super.m_6339_();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.chunkLoadingActive) {
                ChunkLoadingUtils.addWorkstationChunkLoading(serverLevel, this.m_58899_());
                this.chunkLoadingActive = true;
            }
            if (this.shouldLoadWorkRange() && this.activated) {
                this.updateRangeChunkLoading();
            }
        }
    }

    public int getWorkRangeLeft() {
        return this.workRangeLeft;
    }

    public void setWorkRangeLeft(int range) {
        this.workRangeLeft = Math.max(0, Math.min(range, this.getMaxRangeLeft()));
        this.updateWorkCenter();
        this.m_6596_();
        this.syncToClient();
        this.updateRangeChunkLoading();
    }

    public int getWorkRangeRight() {
        return this.workRangeRight;
    }

    public void setWorkRangeRight(int range) {
        this.workRangeRight = Math.max(0, Math.min(range, this.getMaxRangeRight()));
        this.updateWorkCenter();
        this.m_6596_();
        this.syncToClient();
        this.updateRangeChunkLoading();
    }

    public int getWorkRangeUp() {
        return this.workRangeUp;
    }

    public void setWorkRangeUp(int range) {
        this.workRangeUp = Math.max(0, Math.min(range, this.getMaxRangeUp()));
        this.updateWorkCenter();
        this.m_6596_();
        this.syncToClient();
        this.updateRangeChunkLoading();
    }

    public int getWorkRangeDown() {
        return this.workRangeDown;
    }

    public void setWorkRangeDown(int range) {
        int minRange = 0;
        if (this instanceof MiningWorkstationBlockEntity) {
            minRange = -50;
        } else if (this instanceof FishingWorkstationBlockEntity) {
            minRange = -16;
        }
        this.workRangeDown = Math.max(minRange, Math.min(range, this.getMaxRangeDown()));
        this.updateWorkCenter();
        this.m_6596_();
        this.syncToClient();
        this.updateRangeChunkLoading();
    }

    public boolean isShowRange() {
        return this.showRange;
    }

    public void setShowRange(boolean showRange) {
        this.showRange = showRange;
        this.m_6596_();
        this.syncToClient();
    }

    public int getMaxRangeLeft() {
        return 8;
    }

    public int getMaxRangeRight() {
        return 8;
    }

    public int getMaxRangeUp() {
        return 16;
    }

    public int getMaxRangeDown() {
        return 0;
    }

    public abstract Direction getFacing();

    protected void updateWorkCenter() {
        this.workCenter = this.m_58899_().m_5484_(this.getFacing(), 1);
    }

    public AABB getWorkArea() {
        int maxY;
        int minY;
        int minZ;
        int maxX;
        int minX;
        BlockPos currentWorkCenter = this.m_58899_().m_5484_(this.getFacing(), 1);
        Direction facing = this.getFacing();
        int maxZ = switch (facing) {
            case Direction.NORTH -> {
                minX = currentWorkCenter.m_123341_() - this.workRangeLeft;
                maxX = currentWorkCenter.m_123341_() + this.workRangeRight;
                minZ = currentWorkCenter.m_123343_() - this.workRangeUp;
                yield currentWorkCenter.m_123343_();
            }
            case Direction.SOUTH -> {
                minX = currentWorkCenter.m_123341_() - this.workRangeRight;
                maxX = currentWorkCenter.m_123341_() + this.workRangeLeft;
                minZ = currentWorkCenter.m_123343_();
                yield currentWorkCenter.m_123343_() + this.workRangeUp;
            }
            case Direction.WEST -> {
                minX = currentWorkCenter.m_123341_() - this.workRangeUp;
                maxX = currentWorkCenter.m_123341_();
                minZ = currentWorkCenter.m_123343_() - this.workRangeRight;
                yield currentWorkCenter.m_123343_() + this.workRangeLeft;
            }
            case Direction.EAST -> {
                minX = currentWorkCenter.m_123341_();
                maxX = currentWorkCenter.m_123341_() + this.workRangeUp;
                minZ = currentWorkCenter.m_123343_() - this.workRangeLeft;
                yield currentWorkCenter.m_123343_() + this.workRangeRight;
            }
            default -> {
                minX = currentWorkCenter.m_123341_() - this.workRangeLeft;
                maxX = currentWorkCenter.m_123341_() + this.workRangeRight;
                minZ = currentWorkCenter.m_123343_() - this.workRangeUp;
                yield currentWorkCenter.m_123343_();
            }
        };
        if (this.workRangeDown >= 0) {
            minY = currentWorkCenter.m_123342_();
            maxY = currentWorkCenter.m_123342_() + this.workRangeDown;
        } else {
            minY = currentWorkCenter.m_123342_() + this.workRangeDown;
            maxY = currentWorkCenter.m_123342_();
        }
        return new AABB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    public BlockPos getWorkRangeMin() {
        AABB area = this.getWorkArea();
        return new BlockPos((int)Math.floor(area.f_82288_), (int)Math.floor(area.f_82289_), (int)Math.floor(area.f_82290_));
    }

    public BlockPos getWorkRangeMax() {
        AABB area = this.getWorkArea();
        return new BlockPos((int)Math.floor(area.f_82291_ - 0.01), (int)Math.floor(area.f_82292_ - 0.01), (int)Math.floor(area.f_82293_ - 0.01));
    }

    public boolean isInWorkRange(BlockPos pos) {
        AABB area = this.getWorkArea();
        return (double)pos.m_123341_() >= area.f_82288_ && (double)pos.m_123341_() < area.f_82291_ && (double)pos.m_123342_() >= area.f_82289_ && (double)pos.m_123342_() < area.f_82292_ && (double)pos.m_123343_() >= area.f_82290_ && (double)pos.m_123343_() < area.f_82293_;
    }

    protected boolean shouldLoadWorkRange() {
        if (this instanceof MiningWorkstationBlockEntity) {
            return false;
        }
        if (this instanceof TransportWorkstationBlockEntity || this instanceof CraftingWorkstationBlockEntity) {
            return false;
        }
        return this.workRangeLeft > 0 || this.workRangeRight > 0 || this.workRangeUp > 0 || this.workRangeDown != 0;
    }

    protected void updateRangeChunkLoading() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!this.shouldLoadWorkRange()) {
            return;
        }
        if (!this.activated) {
            return;
        }
        BlockPos newMin = this.getWorkRangeMin();
        BlockPos newMax = this.getWorkRangeMax();
        if (newMin.equals((Object)this.lastRangeMin) && newMax.equals((Object)this.lastRangeMax)) {
            return;
        }
        if (this.rangeChunkLoadingActive && this.lastRangeMin != null && this.lastRangeMax != null) {
            ChunkLoadingUtils.removeWorkstationRangeChunkLoading(serverLevel, this.lastRangeMin, this.lastRangeMax);
        }
        ChunkLoadingUtils.addWorkstationRangeChunkLoading(serverLevel, newMin, newMax);
        this.rangeChunkLoadingActive = true;
        this.lastRangeMin = newMin;
        this.lastRangeMax = newMax;
    }

    @Override
    public void setActivated(boolean activated) {
        boolean wasActivated = this.activated;
        super.setActivated(activated);
        if (wasActivated != activated) {
            if (activated) {
                this.updateRangeChunkLoading();
            } else {
                Level level = this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.rangeChunkLoadingActive) {
                        if (this.lastRangeMin != null && this.lastRangeMax != null) {
                            ChunkLoadingUtils.removeWorkstationRangeChunkLoading(serverLevel, this.lastRangeMin, this.lastRangeMax);
                        }
                        this.rangeChunkLoadingActive = false;
                        this.lastRangeMin = null;
                        this.lastRangeMax = null;
                    }
                }
            }
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("workRangeLeft", this.workRangeLeft);
        tag.m_128405_("workRangeRight", this.workRangeRight);
        tag.m_128405_("workRangeUp", this.workRangeUp);
        tag.m_128405_("workRangeDown", this.workRangeDown);
        tag.m_128379_("showRange", this.showRange);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.workRangeLeft = Math.max(0, Math.min(tag.m_128451_("workRangeLeft"), this.getMaxRangeLeft()));
        this.workRangeRight = Math.max(0, Math.min(tag.m_128451_("workRangeRight"), this.getMaxRangeRight()));
        this.workRangeUp = Math.max(0, Math.min(tag.m_128451_("workRangeUp"), this.getMaxRangeUp()));
        int loadedRangeDown = tag.m_128451_("workRangeDown");
        int minRange = 0;
        if (this instanceof MiningWorkstationBlockEntity) {
            minRange = -50;
        } else if (this instanceof FishingWorkstationBlockEntity) {
            minRange = -16;
        }
        this.workRangeDown = Math.max(minRange, Math.min(loadedRangeDown, this.getMaxRangeDown()));
        this.showRange = tag.m_128471_("showRange");
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.workCenter = null;
        }
    }

    public AABB getRenderBoundingBox() {
        if (this.showRange) {
            return this.getWorkArea();
        }
        return super.getRenderBoundingBox();
    }
}

