/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.workstation.BreedingWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.BreedingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.InventoryBoundedWorkstationBlockEntity;

public class BreedingWorkstationBlockEntity
extends InventoryBoundedWorkstationBlockEntity {
    private static final int WORK_INTERVAL = 60;
    public static final int MAX_RANGE_LEFT = 8;
    public static final int MAX_RANGE_RIGHT = 8;
    public static final int MAX_RANGE_UP = 16;
    public static final int MAX_RANGE_DOWN = 0;
    private int maxAnimals = 10;
    private int workTimer = 0;
    private final Random random = new Random();

    public BreedingWorkstationBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.BREEDING_WORKSTATION_BLOCK_ENTITY.get(), pos, blockState);
        this.workRangeLeft = 3;
        this.workRangeRight = 3;
        this.workRangeUp = 3;
        this.workRangeDown = 0;
        this.showRange = true;
        this.maxAnimals = 10;
        this.workTimer = 0;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BreedingWorkstationBlockEntity blockEntity) {
        if (level != null && !level.f_46443_) {
            blockEntity.serverTick();
        }
    }

    private void serverTick() {
        if (!this.activated) {
            return;
        }
        --this.workTimer;
        if (this.workTimer <= 0) {
            this.workTimer = 60 + this.random.nextInt(20) - 10;
            this.performBreedingWork();
        }
    }

    @Override
    public void triggerWork() {
        this.collectDroppedItems();
        this.performBreedingWork();
    }

    private void performBreedingWork() {
        Animal animal22;
        AABB workArea = this.getWorkArea();
        List animals = this.f_58857_.m_45976_(Animal.class, workArea);
        animals.removeIf(animal -> !animal.m_6084_() || animal.m_213877_());
        if (animals.isEmpty()) {
            return;
        }
        ArrayList<Animal> adults = new ArrayList<Animal>();
        for (Animal animal22 : animals) {
            if (animal22.m_6162_()) continue;
            adults.add(animal22);
        }
        if (adults.size() > this.maxAnimals) {
            Collections.shuffle(adults, this.random);
            for (int i = this.maxAnimals; i < adults.size(); ++i) {
                this.killAnimal((Animal)adults.get(i));
            }
        }
        Iterator iterator = animals.iterator();
        while (!(!iterator.hasNext() || this.canAndShouldFeedAnimal(animal22 = (Animal)iterator.next()) && this.feedAnimal(animal22))) {
        }
    }

    private boolean canAndShouldFeedAnimal(Animal animal) {
        if (!animal.m_6084_() || animal.m_213877_()) {
            return false;
        }
        if (animal.m_146764_() != 0 || !animal.m_5957_()) {
            return false;
        }
        return this.hasAnimalFood(animal);
    }

    private boolean hasAnimalFood(Animal animal) {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (!this.isValidAnimalFood(animal, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean feedAnimal(Animal animal) {
        if (!animal.m_6084_() || animal.m_213877_() || animal.m_146764_() != 0 || !animal.m_5957_()) {
            return false;
        }
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (!this.isValidAnimalFood(animal, stack)) continue;
            stack.m_41774_(1);
            this.m_6596_();
            animal.m_27595_(null);
            return true;
        }
        return false;
    }

    private boolean isValidAnimalFood(Animal animal, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return animal.m_6898_(stack);
    }

    private void killAnimal(Animal animal) {
        if (!animal.m_6084_() || animal.m_213877_()) {
            return;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (animal instanceof Cow) {
            drops.add(new ItemStack((ItemLike)Items.f_42579_, 1 + this.random.nextInt(3)));
            drops.add(new ItemStack((ItemLike)Items.f_42454_, 0 + this.random.nextInt(3)));
        } else if (animal instanceof Pig) {
            drops.add(new ItemStack((ItemLike)Items.f_42485_, 1 + this.random.nextInt(3)));
        } else if (animal instanceof Sheep) {
            drops.add(new ItemStack((ItemLike)Items.f_42658_, 1 + this.random.nextInt(3)));
            if (this.random.nextBoolean()) {
                drops.add(new ItemStack((ItemLike)Items.f_41870_, 1 + this.random.nextInt(2)));
            }
        } else if (animal instanceof Chicken) {
            drops.add(new ItemStack((ItemLike)Items.f_42581_, 1));
            drops.add(new ItemStack((ItemLike)Items.f_42402_, 0 + this.random.nextInt(3)));
        } else if (animal instanceof Rabbit) {
            drops.add(new ItemStack((ItemLike)Items.f_42697_, 1));
            if (this.random.nextFloat() < 0.1f) {
                drops.add(new ItemStack((ItemLike)Items.f_42648_, 1));
            }
        }
        for (ItemStack drop : drops) {
            ItemStack remaining = this.insertItem(drop.m_41777_());
            if (remaining.m_41619_()) continue;
            Block.m_49840_((Level)this.f_58857_, (BlockPos)animal.m_20183_(), (ItemStack)remaining);
        }
        animal.m_146870_();
    }

    private ItemStack insertItem(ItemStack stack) {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            int maxStackSize;
            int canAdd;
            ItemStack slotStack = this.inventory.m_8020_(i);
            if (slotStack.m_41619_()) {
                this.inventory.m_6836_(i, stack.m_41777_());
                this.m_6596_();
                return ItemStack.f_41583_;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)stack) || (canAdd = (maxStackSize = Math.min(slotStack.m_41741_(), this.inventory.m_6893_())) - slotStack.m_41613_()) <= 0) continue;
            int toAdd = Math.min(canAdd, stack.m_41613_());
            slotStack.m_41769_(toAdd);
            stack.m_41774_(toAdd);
            this.m_6596_();
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @Override
    public Direction getFacing() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)BreedingWorkstation.FACING)) {
            return (Direction)state.m_61143_((Property)BreedingWorkstation.FACING);
        }
        return Direction.NORTH;
    }

    @Override
    public void setWorkRangeLeft(int range) {
        super.setWorkRangeLeft(range);
    }

    @Override
    public void setWorkRangeRight(int range) {
        super.setWorkRangeRight(range);
    }

    @Override
    public void setWorkRangeUp(int range) {
        super.setWorkRangeUp(range);
    }

    @Override
    public void setWorkRangeDown(int range) {
        super.setWorkRangeDown(range);
    }

    public int getMaxAnimals() {
        return this.maxAnimals;
    }

    public void setMaxAnimals(int maxAnimals) {
        this.maxAnimals = Math.max(0, Math.min(maxAnimals, 50));
        this.m_6596_();
        if (this.activated && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.performBreedingWork();
        }
    }

    @Override
    public int getMaxRangeLeft() {
        return 8;
    }

    @Override
    public int getMaxRangeRight() {
        return 8;
    }

    @Override
    public int getMaxRangeUp() {
        return 16;
    }

    @Override
    public int getMaxRangeDown() {
        return 0;
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new BreedingWorkstationScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"hundred_years_war.breeding_workstation");
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("workTimer", this.workTimer);
        tag.m_128405_("maxAnimals", this.maxAnimals);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.workTimer = tag.m_128451_("workTimer");
        this.maxAnimals = tag.m_128441_("maxAnimals") ? tag.m_128451_("maxAnimals") : 10;
        this.maxAnimals = Math.max(0, Math.min(this.maxAnimals, 50));
    }
}

