/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.InventoryBoundedWorkstationBlockEntity;

public class CraftingWorkstationBlockEntity
extends InventoryBoundedWorkstationBlockEntity {
    private static final int INVENTORY_SIZE = 27;
    private static final int RECIPE_GRID_SIZE = 9;
    private final ItemStack[] recipeTemplate = new ItemStack[9];
    private ItemStack expectedOutput = ItemStack.f_41583_;

    public CraftingWorkstationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CRAFTING_WORKSTATION.get(), pos, state);
        this.inventory = new SimpleContainer(27);
        for (int i = 0; i < 9; ++i) {
            this.recipeTemplate[i] = ItemStack.f_41583_;
        }
        this.workRangeLeft = 0;
        this.workRangeRight = 0;
        this.workRangeUp = 0;
        this.workRangeDown = 0;
        this.showRange = false;
    }

    @Override
    public int getMaxRangeLeft() {
        return 0;
    }

    @Override
    public int getMaxRangeRight() {
        return 0;
    }

    @Override
    public int getMaxRangeUp() {
        return 0;
    }

    @Override
    public int getMaxRangeDown() {
        return 0;
    }

    @Override
    public Direction getFacing() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)CraftingWorkstation.FACING)) {
            return (Direction)state.m_61143_((Property)CraftingWorkstation.FACING);
        }
        return Direction.NORTH;
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new CraftingWorkstationScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"block.hundred_years_war.crafting_workstation");
    }

    public static void tick(Level world, BlockPos pos, BlockState state, CraftingWorkstationBlockEntity blockEntity) {
        if (world.f_46443_) {
            return;
        }
    }

    public ItemStack[] getRecipeTemplate() {
        return this.recipeTemplate;
    }

    public void setRecipeTemplateSlot(int index, ItemStack stack) {
        if (index >= 0 && index < 9) {
            this.recipeTemplate[index] = stack.m_41777_();
            this.recipeTemplate[index].m_41764_(1);
            this.updateExpectedOutput();
            this.m_6596_();
        }
    }

    public ItemStack getExpectedOutput() {
        return this.expectedOutput;
    }

    public void setExpectedOutput(ItemStack output) {
        this.expectedOutput = output.m_41777_();
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void updateExpectedOutput() {
        if (this.f_58857_ == null) {
            return;
        }
        TransientCraftingContainer craftingInventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            public ItemStack m_7648_(Player player, int slot) {
                return ItemStack.f_41583_;
            }

            public boolean m_6875_(Player player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            craftingInventory.m_6836_(i, this.recipeTemplate[i].m_41777_());
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingInventory, this.f_58857_);
        this.expectedOutput = recipe.isPresent() ? ((CraftingRecipe)recipe.get()).m_5874_((Container)craftingInventory, this.f_58857_.m_9598_()) : ItemStack.f_41583_;
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean performCrafting() {
        ItemStack invStack;
        int j;
        int i;
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.expectedOutput.m_41619_()) {
            return false;
        }
        int[] requiredCounts = new int[9];
        for (i = 0; i < 9; ++i) {
            if (this.recipeTemplate[i].m_41619_()) continue;
            requiredCounts[i] = 1;
        }
        for (i = 0; i < 9; ++i) {
            if (this.recipeTemplate[i].m_41619_()) continue;
            boolean hasEnough = false;
            for (j = 0; j < 27; ++j) {
                invStack = this.inventory.m_8020_(j);
                if (!ItemStack.m_150942_((ItemStack)invStack, (ItemStack)this.recipeTemplate[i]) || invStack.m_41613_() < requiredCounts[i]) continue;
                hasEnough = true;
                break;
            }
            if (hasEnough) continue;
            return false;
        }
        for (i = 0; i < 9; ++i) {
            if (this.recipeTemplate[i].m_41619_()) continue;
            int toConsume = 1;
            for (j = 0; j < 27 && toConsume > 0; ++j) {
                invStack = this.inventory.m_8020_(j);
                if (!ItemStack.m_150942_((ItemStack)invStack, (ItemStack)this.recipeTemplate[i])) continue;
                int consumed = Math.min(toConsume, invStack.m_41613_());
                invStack.m_41774_(consumed);
                toConsume -= consumed;
            }
        }
        ItemStack output = this.expectedOutput.m_41777_();
        for (int i2 = 0; i2 < 27 && !output.m_41619_(); ++i2) {
            ItemStack slot = this.inventory.m_8020_(i2);
            if (slot.m_41619_()) {
                this.inventory.m_6836_(i2, output);
                output = ItemStack.f_41583_;
                continue;
            }
            if (!ItemStack.m_150942_((ItemStack)slot, (ItemStack)output)) continue;
            int space = slot.m_41741_() - slot.m_41613_();
            int toAdd = Math.min(space, output.m_41613_());
            slot.m_41769_(toAdd);
            output.m_41774_(toAdd);
        }
        if (!output.m_41619_()) {
            Containers.m_18992_((Level)this.f_58857_, (double)((double)this.f_58858_.m_123341_() + 0.5), (double)(this.f_58858_.m_123342_() + 1), (double)((double)this.f_58858_.m_123343_() + 0.5), (ItemStack)output);
        }
        this.m_6596_();
        return true;
    }

    @Override
    public void triggerWork() {
        this.performCrafting();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag recipeList = new ListTag();
        for (int i = 0; i < 9; ++i) {
            if (this.recipeTemplate[i].m_41619_()) continue;
            CompoundTag slotTag = new CompoundTag();
            slotTag.m_128344_("Slot", (byte)i);
            slotTag.m_128365_("Item", (Tag)this.recipeTemplate[i].m_41739_(new CompoundTag()));
            recipeList.add((Object)slotTag);
        }
        tag.m_128365_("RecipeTemplate", (Tag)recipeList);
        if (!this.expectedOutput.m_41619_()) {
            tag.m_128365_("ExpectedOutput", (Tag)this.expectedOutput.m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        for (int i = 0; i < 9; ++i) {
            this.recipeTemplate[i] = ItemStack.f_41583_;
        }
        ListTag recipeList = tag.m_128437_("RecipeTemplate", 10);
        for (int i = 0; i < recipeList.size(); ++i) {
            CompoundTag slotTag = recipeList.m_128728_(i);
            byte slot = slotTag.m_128445_("Slot");
            if (slot < 0 || slot >= 9) continue;
            this.recipeTemplate[slot] = ItemStack.m_41712_((CompoundTag)slotTag.m_128469_("Item"));
        }
        this.expectedOutput = tag.m_128441_("ExpectedOutput") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("ExpectedOutput")) : ItemStack.f_41583_;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

