/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationBlockEntity;

public class CraftingWorkstationInventoryScreenHandler
extends AbstractContainerMenu {
    public static final MenuType<CraftingWorkstationInventoryScreenHandler> TYPE = new MenuType(CraftingWorkstationInventoryScreenHandler::clientCreate, null);
    private static BlockPos clientBlockPos = null;
    private CraftingWorkstationBlockEntity blockEntity;
    private Level level;
    private BlockPos pos;

    public static CraftingWorkstationInventoryScreenHandler clientCreate(int syncId, Inventory playerInventory) {
        BlockPos pos = clientBlockPos;
        clientBlockPos = null;
        if (pos != null) {
            return new CraftingWorkstationInventoryScreenHandler(syncId, playerInventory, pos);
        }
        throw new IllegalStateException("No BlockPos set for client screen handler creation");
    }

    public static void setClientBlockPos(BlockPos pos) {
        clientBlockPos = pos;
    }

    public CraftingWorkstationInventoryScreenHandler(int syncId, Inventory playerInventory, BlockPos pos) {
        super(TYPE, syncId);
        this.pos = pos;
        this.level = playerInventory.f_35978_.m_9236_();
        BlockEntity entity = this.level.m_7702_(pos);
        if (entity instanceof CraftingWorkstationBlockEntity) {
            this.blockEntity = (CraftingWorkstationBlockEntity)entity;
        }
        this.setupSlots(playerInventory);
    }

    public CraftingWorkstationInventoryScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(syncId, playerInventory, buf.m_130135_());
    }

    public CraftingWorkstationInventoryScreenHandler(int syncId, Inventory playerInventory, BlockEntity blockEntity) {
        super(TYPE, syncId);
        if (!(blockEntity instanceof CraftingWorkstationBlockEntity)) {
            throw new IllegalArgumentException("Expected CraftingWorkstationBlockEntity");
        }
        this.blockEntity = (CraftingWorkstationBlockEntity)blockEntity;
        this.level = blockEntity.m_58904_();
        this.pos = blockEntity.m_58899_();
        this.setupSlots(playerInventory);
    }

    private void setupSlots(Inventory playerInventory) {
        int col;
        int row;
        if (this.blockEntity != null) {
            for (row = 0; row < 3; ++row) {
                for (col = 0; col < 9; ++col) {
                    this.m_38897_(new Slot((Container)this.blockEntity, row * 9 + col, 8 + col * 18, 18 + row * 18));
                }
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 86 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.m_38897_(new Slot((Container)playerInventory, col2, 8 + col2 * 18, 144));
        }
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity == null || Container.m_272074_((BlockEntity)this.blockEntity, (Player)player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            newStack = originalStack.m_41777_();
            if (index < 27 ? !this.m_38903_(originalStack, 27, 63, true) : index < 63 && !this.m_38903_(originalStack, 0, 27, false) && (index < 54 ? !this.m_38903_(originalStack, 54, 63, false) : !this.m_38903_(originalStack, 27, 54, false))) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (originalStack.m_41613_() == newStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, originalStack);
        }
        return newStack;
    }

    public CraftingWorkstationBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }
}

