/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.workstation.FarmingWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.FarmingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.InventoryBoundedWorkstationBlockEntity;

public class FarmingWorkstationBlockEntity
extends InventoryBoundedWorkstationBlockEntity {
    private static final int WORK_INTERVAL = 40;
    public static final int MAX_RANGE_LEFT = 8;
    public static final int MAX_RANGE_RIGHT = 8;
    public static final int MAX_RANGE_UP = 16;
    public static final int MAX_RANGE_DOWN = 0;
    private int workTimer = 0;
    private boolean selected = false;
    private final Random random = new Random();
    private int nextWorkInterval = 40;
    private WorkPhase currentPhase = WorkPhase.SCANNING;
    private final Set<BlockPos> farmlandPositions = new HashSet<BlockPos>();
    private final Set<BlockPos> plantPositions = new HashSet<BlockPos>();
    private final Set<BlockPos> harvestPositions = new HashSet<BlockPos>();
    private final Queue<BlockPos> workQueue = new LinkedList<BlockPos>();

    public FarmingWorkstationBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.FARMING_WORKSTATION.get(), pos, blockState);
        this.workRangeLeft = 3;
        this.workRangeRight = 3;
        this.workRangeUp = 3;
        this.workRangeDown = 0;
        this.setShowRange(true);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FarmingWorkstationBlockEntity blockEntity) {
        if (level != null && !level.f_46443_) {
            blockEntity.serverTick();
        }
    }

    private void serverTick() {
        if (!this.activated) {
            return;
        }
        --this.workTimer;
        if (this.workTimer <= 0) {
            this.workTimer = this.nextWorkInterval;
            this.nextWorkInterval = 40 + this.random.nextInt(10) - 5;
            this.performFarmingWork();
        }
    }

    @Override
    public void triggerWork() {
        this.collectDroppedItems();
        this.performFarmingWork();
    }

    private void performFarmingWork() {
        switch (this.currentPhase) {
            case SCANNING: {
                this.scanFarmArea();
                break;
            }
            case TILLING: {
                this.performTilling();
                break;
            }
            case PLANTING: {
                this.performPlanting();
                break;
            }
            case HARVESTING: {
                this.performHarvesting();
                break;
            }
            case BONE_MEALING: {
                this.performBoneMealing();
            }
        }
    }

    private void scanFarmArea() {
        this.farmlandPositions.clear();
        this.plantPositions.clear();
        this.harvestPositions.clear();
        this.workQueue.clear();
        AABB workArea = this.getWorkArea();
        int minX = (int)Math.floor(workArea.f_82288_);
        int maxX = (int)Math.floor(workArea.f_82291_ - 0.01);
        int minY = (int)Math.floor(workArea.f_82289_);
        int maxY = (int)Math.floor(workArea.f_82292_ - 0.01);
        int minZ = (int)Math.floor(workArea.f_82290_);
        int maxZ = (int)Math.floor(workArea.f_82293_ - 0.01);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    CropBlock cropBlock;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = this.f_58857_.m_8055_(pos);
                    Block block = state.m_60734_();
                    BlockPos belowPos = pos.m_7495_();
                    BlockState belowState = this.f_58857_.m_8055_(belowPos);
                    if (this.canTill(belowState) && (state.m_60795_() || this.isObstacle(state))) {
                        this.farmlandPositions.add(belowPos);
                    }
                    if (this.f_58857_.m_8055_(belowPos).m_60734_() instanceof FarmBlock && state.m_60795_() && this.hasSeedsInInventory()) {
                        this.plantPositions.add(pos);
                    }
                    if (!(block instanceof CropBlock) || !(cropBlock = (CropBlock)block).m_52307_(state)) continue;
                    this.harvestPositions.add(pos);
                }
            }
        }
        if (!this.farmlandPositions.isEmpty()) {
            this.workQueue.addAll(this.farmlandPositions);
            this.currentPhase = WorkPhase.TILLING;
        } else if (!this.plantPositions.isEmpty()) {
            this.workQueue.addAll(this.plantPositions);
            this.currentPhase = WorkPhase.PLANTING;
        } else if (!this.harvestPositions.isEmpty()) {
            this.workQueue.addAll(this.harvestPositions);
            this.currentPhase = WorkPhase.HARVESTING;
        } else {
            this.currentPhase = this.hasBoneMeal() ? WorkPhase.BONE_MEALING : WorkPhase.SCANNING;
        }
    }

    private void performTilling() {
        if (this.workQueue.isEmpty()) {
            this.currentPhase = WorkPhase.SCANNING;
            return;
        }
        BlockPos tillPos = this.workQueue.poll();
        if (this.canTill(this.f_58857_.m_8055_(tillPos))) {
            BlockPos abovePos = tillPos.m_7494_();
            this.clearObstaclesAt(abovePos);
            this.f_58857_.m_7731_(tillPos, Blocks.f_50093_.m_49966_(), 3);
            this.f_58857_.m_5594_(null, tillPos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (this.workQueue.isEmpty()) {
            this.currentPhase = WorkPhase.SCANNING;
        }
    }

    private boolean isObstacle(BlockState state) {
        if (state.m_60795_()) {
            return false;
        }
        Block block = state.m_60734_();
        return state.m_247087_() || block instanceof SnowLayerBlock || block instanceof BushBlock || block instanceof TallGrassBlock || block instanceof DoublePlantBlock || block instanceof FlowerBlock;
    }

    private void clearObstaclesAt(BlockPos pos) {
        BlockState state = this.f_58857_.m_8055_(pos);
        if (this.isObstacle(state)) {
            this.f_58857_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private void performPlanting() {
        BlockState cropState;
        if (this.workQueue.isEmpty()) {
            this.currentPhase = WorkPhase.SCANNING;
            return;
        }
        BlockPos plantPos = this.workQueue.poll();
        ItemStack seedStack = this.findSeedsInInventory();
        if (!seedStack.m_41619_() && this.f_58857_.m_8055_(plantPos).m_60795_() && (cropState = this.getCropStateFromSeed(seedStack.m_41720_())) != null) {
            this.f_58857_.m_7731_(plantPos, cropState, 3);
            seedStack.m_41774_(1);
            this.f_58857_.m_5594_(null, plantPos, SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (this.workQueue.isEmpty()) {
            this.currentPhase = WorkPhase.SCANNING;
        }
    }

    private void performHarvesting() {
        CropBlock cropBlock;
        if (this.workQueue.isEmpty()) {
            this.currentPhase = WorkPhase.SCANNING;
            return;
        }
        BlockPos harvestPos = this.workQueue.poll();
        BlockState cropState = this.f_58857_.m_8055_(harvestPos);
        Block block = cropState.m_60734_();
        if (block instanceof CropBlock && (cropBlock = (CropBlock)block).m_52307_(cropState)) {
            List drops = Block.m_49869_((BlockState)cropState, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)harvestPos, null);
            boolean canStore = true;
            ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>();
            for (ItemStack drop : drops) {
                ItemStack remaining = this.insertItem(drop.m_41777_());
                if (remaining.m_41619_()) continue;
                remainingItems.add(remaining);
                canStore = false;
            }
            if (canStore || remainingItems.size() < drops.size()) {
                this.f_58857_.m_7731_(harvestPos, cropBlock.m_52289_(0), 3);
                this.f_58857_.m_5594_(null, harvestPos, SoundEvents.f_11838_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.spawnHarvestParticles(harvestPos, cropState);
                for (ItemStack remaining : remainingItems) {
                    Block.m_49840_((Level)this.f_58857_, (BlockPos)harvestPos, (ItemStack)remaining);
                }
            }
        }
        if (this.workQueue.isEmpty()) {
            this.currentPhase = WorkPhase.SCANNING;
        }
    }

    private boolean canTill(BlockState state) {
        Block block = state.m_60734_();
        return block == Blocks.f_50493_ || block == Blocks.f_50440_ || block == Blocks.f_50546_;
    }

    private boolean hasSeedsInInventory() {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (!this.isSeed(stack.m_41720_())) continue;
            return true;
        }
        return false;
    }

    private ItemStack findSeedsInInventory() {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (!this.isSeed(stack.m_41720_()) || stack.m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private boolean isSeed(Item item) {
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            return block instanceof CropBlock;
        }
        return false;
    }

    private BlockState getCropStateFromSeed(Item seed) {
        BlockItem blockItem;
        Block block;
        if (seed instanceof BlockItem && (block = (blockItem = (BlockItem)seed).m_40614_()) instanceof CropBlock) {
            return block.m_49966_();
        }
        return null;
    }

    private ItemStack insertItem(ItemStack stack) {
        for (int i = 0; i < this.inventory.m_6643_() && !(stack = this.inventory.m_19173_(stack)).m_41619_(); ++i) {
        }
        return stack;
    }

    private boolean hasBoneMeal() {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41720_() != Items.f_42499_) continue;
            return true;
        }
        return false;
    }

    private void performBoneMealing() {
        if (!this.hasBoneMeal()) {
            this.currentPhase = WorkPhase.SCANNING;
            return;
        }
        AABB workArea = this.getWorkArea();
        int minX = (int)Math.floor(workArea.f_82288_);
        int maxX = (int)Math.floor(workArea.f_82291_ - 0.01);
        int minY = (int)Math.floor(workArea.f_82289_);
        int maxY = (int)Math.floor(workArea.f_82292_ - 0.01);
        int minZ = (int)Math.floor(workArea.f_82290_);
        int maxZ = (int)Math.floor(workArea.f_82293_ - 0.01);
        ArrayList<BlockPos> cropPositions = new ArrayList<BlockPos>();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    CropBlock cropBlock;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState cropState2 = this.f_58857_.m_8055_(pos);
                    Block block = cropState2.m_60734_();
                    if (!(block instanceof CropBlock) || (cropBlock = (CropBlock)block).m_52307_(cropState2)) continue;
                    cropPositions.add(pos);
                }
            }
        }
        if (cropPositions.isEmpty()) {
            this.currentPhase = WorkPhase.SCANNING;
            return;
        }
        Collections.shuffle(cropPositions, this.random);
        for (BlockPos pos : cropPositions) {
            CropBlock cropBlock;
            BlockState cropState = this.f_58857_.m_8055_(pos);
            Block cropState2 = cropState.m_60734_();
            if (!(cropState2 instanceof CropBlock) || (cropBlock = (CropBlock)cropState2).m_52307_(cropState)) continue;
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                RandomSource randomSource;
                ItemStack stack = this.inventory.m_8020_(i);
                if (stack.m_41720_() != Items.f_42499_ || !cropBlock.m_214167_(this.f_58857_, randomSource = this.f_58857_.m_213780_(), pos, cropState)) continue;
                cropBlock.m_214148_((ServerLevel)this.f_58857_, randomSource, pos, cropState);
                ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    this.m_6836_(i, ItemStack.f_41583_);
                }
                this.m_6596_();
                this.currentPhase = WorkPhase.SCANNING;
                return;
            }
        }
        this.currentPhase = WorkPhase.SCANNING;
    }

    private void spawnHarvestParticles(BlockPos pos, BlockState cropState) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            BlockParticleOption particleOption = new BlockParticleOption(ParticleTypes.f_123794_, cropState);
            for (int i = 0; i < 10; ++i) {
                double offsetX = this.random.nextGaussian() * 0.3;
                double offsetY = this.random.nextDouble() * 0.3;
                double offsetZ = this.random.nextGaussian() * 0.3;
                serverLevel.m_8767_((ParticleOptions)particleOption, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.1, 0.0, 0.1);
            }
        }
    }

    @Override
    public void setWorkRangeLeft(int range) {
        super.setWorkRangeLeft(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeRight(int range) {
        super.setWorkRangeRight(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeUp(int range) {
        super.setWorkRangeUp(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeDown(int range) {
        super.setWorkRangeDown(range);
        this.clearWorkCache();
    }

    private void clearWorkCache() {
        this.farmlandPositions.clear();
        this.plantPositions.clear();
        this.harvestPositions.clear();
        this.workQueue.clear();
        this.currentPhase = WorkPhase.SCANNING;
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new FarmingWorkstationScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"hundred_years_war.farming_workstation");
    }

    @Override
    public Direction getFacing() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)FarmingWorkstation.FACING)) {
            return (Direction)state.m_61143_((Property)FarmingWorkstation.FACING);
        }
        return Direction.NORTH;
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("currentPhase", this.currentPhase.ordinal());
        tag.m_128405_("workTimer", this.workTimer);
        tag.m_128405_("nextWorkInterval", this.nextWorkInterval);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("currentPhase")) {
            this.currentPhase = WorkPhase.values()[tag.m_128451_("currentPhase")];
        }
        this.workTimer = tag.m_128451_("workTimer");
        this.nextWorkInterval = tag.m_128451_("nextWorkInterval");
        if (this.nextWorkInterval <= 0) {
            this.nextWorkInterval = 40;
        }
    }

    @Override
    public int getMaxRangeLeft() {
        return 8;
    }

    @Override
    public int getMaxRangeRight() {
        return 8;
    }

    @Override
    public int getMaxRangeUp() {
        return 16;
    }

    @Override
    public int getMaxRangeDown() {
        return 0;
    }

    private static enum WorkPhase {
        SCANNING,
        TILLING,
        PLANTING,
        HARVESTING,
        BONE_MEALING;

    }
}

