/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.InventoryBoundedWorkstationBlockEntity;

public class FishingWorkstationBlockEntity
extends InventoryBoundedWorkstationBlockEntity {
    private static final int WORK_INTERVAL = 60;
    private static final int FISHING_BASE_CHANCE = 30;
    public static final int MAX_RANGE_LEFT = 8;
    public static final int MAX_RANGE_RIGHT = 8;
    public static final int MAX_RANGE_UP = 16;
    public static final int MAX_RANGE_DOWN = 16;
    public static final int MIN_RANGE_DOWN = -16;
    private final Set<BlockPos> waterPositions = new HashSet<BlockPos>();
    private int workTimer = 0;
    private final Random random = new Random();

    public FishingWorkstationBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.FISHING_WORKSTATION_BLOCK_ENTITY.get(), pos, blockState);
        this.workRangeLeft = 3;
        this.workRangeRight = 3;
        this.workRangeUp = 3;
        this.workRangeDown = -1;
        this.showRange = true;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FishingWorkstationBlockEntity blockEntity) {
        if (level != null && !level.f_46443_) {
            blockEntity.serverTick();
        }
    }

    private void serverTick() {
        if (!this.activated) {
            return;
        }
        --this.workTimer;
        if (this.workTimer <= 0) {
            this.workTimer = 60 + this.random.nextInt(40) - 20;
            if (this.waterPositions.isEmpty()) {
                this.scanForWaterSources();
            }
            if (!this.waterPositions.isEmpty()) {
                this.performFishing();
            }
        }
    }

    @Override
    public void triggerWork() {
        this.collectDroppedItems();
        if (this.waterPositions.isEmpty()) {
            this.scanForWaterSources();
        }
        if (!this.waterPositions.isEmpty()) {
            this.performFishing();
        }
    }

    private void scanForWaterSources() {
        this.waterPositions.clear();
        AABB workArea = this.getWorkArea();
        int minX = (int)Math.floor(workArea.f_82288_);
        int maxX = (int)Math.floor(workArea.f_82291_ - 0.01);
        int minY = (int)Math.floor(workArea.f_82289_);
        int maxY = (int)Math.floor(workArea.f_82292_ - 0.01);
        int minZ = (int)Math.floor(workArea.f_82290_);
        int maxZ = (int)Math.floor(workArea.f_82293_ - 0.01);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos checkPos = new BlockPos(x, y, z);
                    if (!this.isWaterSource(checkPos)) continue;
                    this.waterPositions.add(checkPos);
                }
            }
        }
    }

    private boolean performFishing() {
        if (this.waterPositions.isEmpty()) {
            return false;
        }
        if (this.random.nextInt(100) >= 30) {
            return false;
        }
        ArrayList<BlockPos> waterList = new ArrayList<BlockPos>(this.waterPositions);
        BlockPos fishingPos = (BlockPos)waterList.get(this.random.nextInt(waterList.size()));
        ItemStack fishingResult = this.getFishingLoot();
        if (!fishingResult.m_41619_()) {
            ItemStack remaining = this.insertItem(fishingResult.m_41777_());
            if (remaining.m_41619_()) {
                this.f_58857_.m_5594_(null, fishingPos, SoundEvents.f_11939_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.spawnFishingParticles(fishingPos);
                return true;
            }
            Block.m_49840_((Level)this.f_58857_, (BlockPos)fishingPos, (ItemStack)remaining);
            this.f_58857_.m_5594_(null, fishingPos, SoundEvents.f_11939_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean isWaterSource(BlockPos pos) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return false;
        }
        BlockState state = this.f_58857_.m_8055_(pos);
        return state.m_60819_().m_205070_(FluidTags.f_13131_) && state.m_60819_().m_76170_();
    }

    private ItemStack getFishingLoot() {
        int lootType = this.random.nextInt(100);
        if (lootType < 85) {
            ItemStack[] fishTypes = new ItemStack[]{new ItemStack((ItemLike)Items.f_42526_), new ItemStack((ItemLike)Items.f_42527_), new ItemStack((ItemLike)Items.f_42528_), new ItemStack((ItemLike)Items.f_42529_)};
            return fishTypes[this.random.nextInt(fishTypes.length)];
        }
        if (lootType < 95) {
            ItemStack[] junkTypes = new ItemStack[]{new ItemStack((ItemLike)Items.f_42463_), new ItemStack((ItemLike)Items.f_42454_), new ItemStack((ItemLike)Items.f_42500_), new ItemStack((ItemLike)Items.f_42401_), new ItemStack((ItemLike)Items.f_42398_)};
            return junkTypes[this.random.nextInt(junkTypes.length)];
        }
        ItemStack[] treasureTypes = new ItemStack[]{new ItemStack((ItemLike)Items.f_42411_), new ItemStack((ItemLike)Items.f_42690_), new ItemStack((ItemLike)Items.f_42656_), new ItemStack((ItemLike)Items.f_42450_), new ItemStack((ItemLike)Items.f_42715_)};
        return treasureTypes[this.random.nextInt(treasureTypes.length)];
    }

    private ItemStack insertItem(ItemStack stack) {
        for (int i = 0; i < this.inventory.m_6643_() && !(stack = this.inventory.m_19173_(stack)).m_41619_(); ++i) {
        }
        return stack;
    }

    private void spawnFishingParticles(BlockPos pos) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.f_58857_;
        RandomSource random = serverLevel.m_213780_();
        double centerX = (double)pos.m_123341_() + 0.5;
        double centerY = (double)pos.m_123342_() + 1.0;
        double centerZ = (double)pos.m_123343_() + 0.5;
        for (int i = 0; i < 6; ++i) {
            double offsetX = (random.m_188500_() - 0.5) * 0.6;
            double offsetZ = (random.m_188500_() - 0.5) * 0.6;
            double velX = (random.m_188500_() - 0.5) * 0.1;
            double velY = random.m_188500_() * 0.1;
            double velZ = (random.m_188500_() - 0.5) * 0.1;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, centerX + offsetX, centerY, centerZ + offsetZ, 1, velX, velY, velZ, 0.1);
        }
    }

    @Override
    public int getMaxRangeLeft() {
        return 8;
    }

    @Override
    public int getMaxRangeRight() {
        return 8;
    }

    @Override
    public int getMaxRangeUp() {
        return 16;
    }

    @Override
    public int getMaxRangeDown() {
        return 16;
    }

    @Override
    public void setWorkRangeLeft(int range) {
        super.setWorkRangeLeft(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeRight(int range) {
        super.setWorkRangeRight(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeUp(int range) {
        super.setWorkRangeUp(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeDown(int range) {
        this.workRangeDown = Math.max(-16, Math.min(range, this.getMaxRangeDown()));
        this.updateWorkCenter();
        this.m_6596_();
        this.syncToClient();
        this.updateRangeChunkLoading();
        this.clearWorkCache();
    }

    private void clearWorkCache() {
        this.waterPositions.clear();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new FishingWorkstationScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"hundred_years_war.fishing_workstation");
    }

    @Override
    public Direction getFacing() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)FishingWorkstation.FACING)) {
            return (Direction)state.m_61143_((Property)FishingWorkstation.FACING);
        }
        return Direction.NORTH;
    }
}

