/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.workstation.InventoryBoundedWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.LumberWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.LumberWorkstationScreenHandler;

public class LumberWorkstationBlockEntity
extends InventoryBoundedWorkstationBlockEntity {
    private static final int WORK_INTERVAL = 20;
    private static final int TREE_SCAN_RANGE = 3;
    public static final int MAX_RANGE_LEFT = 10;
    public static final int MAX_RANGE_RIGHT = 10;
    public static final int MAX_RANGE_UP = 20;
    public static final int MAX_RANGE_DOWN = 0;
    private int workTimer = 0;
    private boolean selected = false;
    private final Random random = new Random();
    private int nextWorkInterval = 20;
    private WorkPhase currentPhase = WorkPhase.SCANNING;
    private final Set<BlockPos> treePositions = new HashSet<BlockPos>();
    private final Set<BlockPos> plantPositions = new HashSet<BlockPos>();
    private final Queue<BlockPos> workQueue = new LinkedList<BlockPos>();

    public LumberWorkstationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.LUMBER_WORKSTATION.get(), pos, state);
        this.workRangeLeft = 3;
        this.workRangeRight = 3;
        this.workRangeUp = 3;
        this.workRangeDown = 0;
        this.showRange = true;
    }

    @Override
    public int getMaxRangeLeft() {
        return 10;
    }

    @Override
    public int getMaxRangeRight() {
        return 10;
    }

    @Override
    public int getMaxRangeUp() {
        return 20;
    }

    @Override
    public int getMaxRangeDown() {
        return 0;
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new LumberWorkstationScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"hundred_years_war.lumber_workstation");
    }

    @Override
    public Direction getFacing() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)LumberWorkstation.FACING)) {
            return (Direction)state.m_61143_((Property)LumberWorkstation.FACING);
        }
        return Direction.NORTH;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, LumberWorkstationBlockEntity blockEntity) {
        if (world.f_46443_) {
            return;
        }
    }

    private void doWork() {
        switch (this.currentPhase) {
            case SCANNING: {
                this.scanWorkArea();
                if (!this.treePositions.isEmpty()) {
                    this.currentPhase = WorkPhase.CHOPPING;
                    break;
                }
                if (!this.plantPositions.isEmpty() && this.hasSaplings()) {
                    this.currentPhase = WorkPhase.PLANTING;
                    break;
                }
                if (!this.hasBoneMeal()) break;
                this.currentPhase = WorkPhase.BONE_MEALING;
                break;
            }
            case CHOPPING: {
                if (this.chopTree()) break;
                this.currentPhase = WorkPhase.SCANNING;
                break;
            }
            case PLANTING: {
                if (this.plantSapling()) break;
                this.currentPhase = WorkPhase.SCANNING;
                break;
            }
            case BONE_MEALING: {
                this.applyBoneMeal();
                this.currentPhase = WorkPhase.SCANNING;
            }
        }
        this.m_6596_();
    }

    private void rescanWorkArea() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.scanWorkArea();
            this.currentPhase = !this.treePositions.isEmpty() ? WorkPhase.CHOPPING : (!this.plantPositions.isEmpty() && this.hasSaplings() ? WorkPhase.PLANTING : WorkPhase.SCANNING);
        }
    }

    private void scanWorkArea() {
        int z;
        int x;
        this.treePositions.clear();
        this.plantPositions.clear();
        AABB workArea = this.getWorkArea();
        BlockPos min = new BlockPos((int)workArea.f_82288_, (int)workArea.f_82289_, (int)workArea.f_82290_);
        BlockPos max = new BlockPos((int)workArea.f_82291_, (int)workArea.f_82292_, (int)workArea.f_82293_);
        int workY = min.m_123342_();
        for (x = min.m_123341_(); x < max.m_123341_(); ++x) {
            for (z = min.m_123343_(); z < max.m_123343_(); ++z) {
                BlockPos pos = new BlockPos(x, workY, z);
                if (!this.canPlantAt(pos) && !this.canPlantAtAfterClearing(pos)) continue;
                this.plantPositions.add(pos);
            }
        }
        for (x = min.m_123341_(); x <= max.m_123341_(); ++x) {
            for (z = min.m_123343_(); z <= max.m_123343_(); ++z) {
                for (int y = min.m_123342_(); y <= min.m_123342_() + 20; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = this.f_58857_.m_8055_(pos);
                    if (!state.m_204336_(BlockTags.f_13106_) && !state.m_204336_(BlockTags.f_13035_)) continue;
                    this.scanTreeFrom(pos);
                }
            }
        }
    }

    private void scanTreeFrom(BlockPos startPos) {
        if (this.treePositions.contains(startPos)) {
            return;
        }
        HashSet<BlockPos> scannedTree = new HashSet<BlockPos>();
        LinkedList<BlockPos> scanQueue = new LinkedList<BlockPos>();
        scanQueue.add(startPos);
        scannedTree.add(startPos);
        while (!scanQueue.isEmpty() && scannedTree.size() < 200) {
            BlockPos current = (BlockPos)scanQueue.poll();
            BlockState currentState = this.f_58857_.m_8055_(current);
            if (!currentState.m_204336_(BlockTags.f_13106_) && !currentState.m_204336_(BlockTags.f_13035_)) continue;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockState neighborState;
                        BlockPos neighborPos;
                        if (dx == 0 && dy == 0 && dz == 0 || scannedTree.contains(neighborPos = current.m_7918_(dx, dy, dz)) || !(neighborState = this.f_58857_.m_8055_(neighborPos)).m_204336_(BlockTags.f_13106_) && !neighborState.m_204336_(BlockTags.f_13035_)) continue;
                        scannedTree.add(neighborPos);
                        scanQueue.add(neighborPos);
                    }
                }
            }
        }
        if (scannedTree.size() >= 3) {
            this.treePositions.addAll(scannedTree);
        }
    }

    private boolean chopTree() {
        if (this.treePositions.isEmpty()) {
            return false;
        }
        ArrayList<BlockPos> toChop = new ArrayList<BlockPos>();
        Iterator<BlockPos> iterator = this.treePositions.iterator();
        int maxChop = 10;
        while (iterator.hasNext() && toChop.size() < maxChop) {
            BlockPos pos = iterator.next();
            if (!this.f_58857_.m_8055_(pos).m_60795_()) {
                toChop.add(pos);
            }
            iterator.remove();
        }
        for (BlockPos pos : toChop) {
            BlockState state = this.f_58857_.m_8055_(pos);
            if (state.m_60795_()) continue;
            if (this.random.nextFloat() < 0.5f) {
                this.f_58857_.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            }
            List drops = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)pos, null);
            for (ItemStack drop : drops) {
                this.addToInventory(drop);
            }
            this.f_58857_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
        return !this.treePositions.isEmpty();
    }

    private boolean plantSapling() {
        if (this.plantPositions.isEmpty() || !this.hasSaplings()) {
            return false;
        }
        ItemStack sapling = null;
        int saplingSlot = -1;
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (!this.isSapling(stack)) continue;
            sapling = stack;
            saplingSlot = i;
            break;
        }
        if (sapling == null) {
            return false;
        }
        BlockPos plantPos = this.plantPositions.iterator().next();
        this.plantPositions.remove(plantPos);
        this.clearObstaclesAt(plantPos);
        if (this.canPlantAt(plantPos)) {
            BlockState saplingState = this.getSaplingBlockState(sapling);
            if (saplingState != null) {
                this.f_58857_.m_7731_(plantPos, saplingState, 3);
                this.f_58857_.m_5594_(null, plantPos, SoundEvents.f_11991_, SoundSource.BLOCKS, 1.0f, 1.0f);
                sapling.m_41774_(1);
                if (sapling.m_41619_()) {
                    this.m_6836_(saplingSlot, ItemStack.f_41583_);
                }
                return true;
            }
            return false;
        }
        return !this.plantPositions.isEmpty() && this.hasSaplings();
    }

    private void clearObstaclesAt(BlockPos pos) {
        BlockState state = this.f_58857_.m_8055_(pos);
        if (this.isObstacle(state)) {
            this.f_58857_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private boolean canPlantAt(BlockPos pos) {
        if (!this.f_58857_.m_8055_(pos).m_60795_()) {
            return false;
        }
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = this.f_58857_.m_8055_(belowPos);
        return belowState.m_60713_(Blocks.f_50440_) || belowState.m_60713_(Blocks.f_50493_) || belowState.m_60713_(Blocks.f_50546_) || belowState.m_60713_(Blocks.f_50599_) || belowState.m_60713_(Blocks.f_50093_);
    }

    private boolean canPlantAtAfterClearing(BlockPos pos) {
        BlockState state = this.f_58857_.m_8055_(pos);
        if (!this.isObstacle(state)) {
            return false;
        }
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = this.f_58857_.m_8055_(belowPos);
        return belowState.m_60713_(Blocks.f_50440_) || belowState.m_60713_(Blocks.f_50493_) || belowState.m_60713_(Blocks.f_50546_) || belowState.m_60713_(Blocks.f_50599_) || belowState.m_60713_(Blocks.f_50093_);
    }

    private boolean isObstacle(BlockState state) {
        if (state.m_60795_()) {
            return false;
        }
        Block block = state.m_60734_();
        if (block instanceof SaplingBlock) {
            return false;
        }
        return state.m_247087_() || block instanceof SnowLayerBlock || block instanceof BushBlock || block instanceof TallGrassBlock || block instanceof DoublePlantBlock || block instanceof FlowerBlock;
    }

    private boolean hasSaplings() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (!this.isSapling(this.m_8020_(i))) continue;
            return true;
        }
        return false;
    }

    private boolean hasBoneMeal() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41720_() != Items.f_42499_) continue;
            return true;
        }
        return false;
    }

    private boolean applyBoneMeal() {
        if (!this.hasBoneMeal()) {
            return false;
        }
        AABB workArea = this.getWorkArea();
        BlockPos min = new BlockPos((int)workArea.f_82288_, (int)workArea.f_82289_, (int)workArea.f_82290_);
        BlockPos max = new BlockPos((int)workArea.f_82291_, (int)workArea.f_82292_, (int)workArea.f_82293_);
        ArrayList<BlockPos> saplingPositions = new ArrayList<BlockPos>();
        int workY = min.m_123342_();
        for (int x = min.m_123341_(); x < max.m_123341_(); ++x) {
            for (int z = min.m_123343_(); z < max.m_123343_(); ++z) {
                BlockPos pos = new BlockPos(x, workY, z);
                BlockState state = this.f_58857_.m_8055_(pos);
                if (!(state.m_60734_() instanceof SaplingBlock)) continue;
                saplingPositions.add(pos);
            }
        }
        if (saplingPositions.isEmpty()) {
            return false;
        }
        Collections.shuffle(saplingPositions, this.random);
        for (BlockPos pos : saplingPositions) {
            BlockState state = this.f_58857_.m_8055_(pos);
            Block block = state.m_60734_();
            if (!(block instanceof SaplingBlock)) continue;
            SaplingBlock saplingBlock = (SaplingBlock)block;
            for (int i = 0; i < this.m_6643_(); ++i) {
                RandomSource randomSource;
                ItemStack stack = this.m_8020_(i);
                if (stack.m_41720_() != Items.f_42499_ || !saplingBlock.m_214167_(this.f_58857_, randomSource = this.f_58857_.m_213780_(), pos, state)) continue;
                saplingBlock.m_214148_((ServerLevel)this.f_58857_, randomSource, pos, state);
                ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    this.m_6836_(i, ItemStack.f_41583_);
                }
                this.m_6596_();
                return true;
            }
        }
        return false;
    }

    private boolean isSapling(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            return block instanceof SaplingBlock;
        }
        return false;
    }

    private BlockState getSaplingBlockState(ItemStack sapling) {
        BlockItem blockItem;
        Block block;
        Item item = sapling.m_41720_();
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof SaplingBlock) {
            return block.m_49966_();
        }
        return null;
    }

    private void addToInventory(ItemStack stack) {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            int canAdd;
            ItemStack slotStack = this.inventory.m_8020_(i);
            if (slotStack.m_41619_()) {
                this.inventory.m_6836_(i, stack.m_41777_());
                return;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)stack) || (canAdd = slotStack.m_41741_() - slotStack.m_41613_()) <= 0) continue;
            int toAdd = Math.min(canAdd, stack.m_41613_());
            slotStack.m_41769_(toAdd);
            stack.m_41774_(toAdd);
            if (!stack.m_41619_()) continue;
            return;
        }
    }

    @Override
    public void setWorkRangeLeft(int range) {
        super.setWorkRangeLeft(range);
        this.rescanWorkArea();
    }

    @Override
    public void setWorkRangeRight(int range) {
        super.setWorkRangeRight(range);
        this.rescanWorkArea();
    }

    @Override
    public void setWorkRangeUp(int range) {
        super.setWorkRangeUp(range);
        this.rescanWorkArea();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.m_6596_();
    }

    @Override
    public void triggerWork() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.collectDroppedItems();
            this.doWork();
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("WorkTimer", this.workTimer);
        tag.m_128405_("NextWorkInterval", this.nextWorkInterval);
        tag.m_128359_("CurrentPhase", this.currentPhase.name());
        tag.m_128379_("Selected", this.selected);
        if (this.workCenter != null) {
            tag.m_128356_("WorkCenter", this.workCenter.m_121878_());
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.workTimer = tag.m_128451_("WorkTimer");
        this.nextWorkInterval = tag.m_128451_("NextWorkInterval");
        if (this.nextWorkInterval <= 0) {
            this.nextWorkInterval = 20;
        }
        try {
            this.currentPhase = WorkPhase.valueOf(tag.m_128461_("CurrentPhase"));
        }
        catch (IllegalArgumentException e) {
            this.currentPhase = WorkPhase.SCANNING;
        }
        this.selected = tag.m_128471_("Selected");
        if (tag.m_128441_("WorkCenter")) {
            this.workCenter = BlockPos.m_122022_((long)tag.m_128454_("WorkCenter"));
        } else {
            this.updateWorkCenter();
        }
    }

    private static enum WorkPhase {
        SCANNING,
        CHOPPING,
        PLANTING,
        BONE_MEALING;

    }
}

