/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.workstation.InventoryBoundedWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.MiningWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.MiningWorkstationScreenHandler;

public class MiningWorkstationBlockEntity
extends InventoryBoundedWorkstationBlockEntity {
    private static final int WORK_INTERVAL = 20;
    private static final int MINING_SCAN_RANGE = 3;
    public static final int MAX_RANGE_LEFT = 25;
    public static final int MAX_RANGE_RIGHT = 25;
    public static final int MAX_RANGE_UP = 50;
    public static final int MAX_RANGE_DOWN = 50;
    public static final int MIN_RANGE_DOWN = -50;
    private final Set<BlockPos> miningPositions = new HashSet<BlockPos>();
    private int workTimer = 0;
    private Integer currentMiningLevel = null;
    private boolean miningDirection = true;
    private int levelsUpMined = 0;
    private int levelsDownMined = 0;

    public MiningWorkstationBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.MINING_WORKSTATION_BLOCK_ENTITY.get(), pos, blockState);
        this.workRangeLeft = 3;
        this.workRangeRight = 3;
        this.workRangeUp = 3;
        this.workRangeDown = -1;
        this.showRange = true;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MiningWorkstationBlockEntity blockEntity) {
        if (level != null && !level.f_46443_) {
            blockEntity.serverTick();
        }
    }

    private void serverTick() {
        if (!this.activated) {
            return;
        }
        --this.workTimer;
        if (this.workTimer <= 0) {
            this.workTimer = 20;
            if (this.miningPositions.isEmpty()) {
                this.scanForMiningTargets();
            }
            if (!this.miningPositions.isEmpty()) {
                this.performMining();
            }
        }
    }

    @Override
    public void triggerWork() {
        this.collectDroppedItems();
        if (this.miningPositions.isEmpty()) {
            this.scanForMiningTargets();
        }
        if (!this.miningPositions.isEmpty()) {
            this.performMining();
        }
    }

    private void scanForMiningTargets() {
        boolean foundAnyBlocks;
        this.miningPositions.clear();
        AABB workArea = this.getWorkArea();
        int minX = (int)Math.floor(workArea.f_82288_);
        int maxX = (int)Math.floor(workArea.f_82291_ - 0.01);
        int minY = (int)Math.floor(workArea.f_82289_);
        int maxY = (int)Math.floor(workArea.f_82292_ - 0.01);
        int minZ = (int)Math.floor(workArea.f_82290_);
        int maxZ = (int)Math.floor(workArea.f_82293_ - 0.01);
        if (this.currentMiningLevel == null) {
            this.currentMiningLevel = this.m_58899_().m_123342_();
            this.currentMiningLevel = Math.max(minY, Math.min(maxY, this.currentMiningLevel));
        }
        if (!(foundAnyBlocks = this.scanLevel(this.currentMiningLevel, minX, maxX, minZ, maxZ))) {
            boolean foundNewLevel = false;
            for (int offset = 1; offset <= Math.max(maxY - this.currentMiningLevel, this.currentMiningLevel - minY); ++offset) {
                int upLevel = this.currentMiningLevel + offset;
                if (upLevel <= maxY && this.scanLevel(upLevel, minX, maxX, minZ, maxZ)) {
                    this.currentMiningLevel = upLevel;
                    foundNewLevel = true;
                    break;
                }
                int downLevel = this.currentMiningLevel - offset;
                if (downLevel < minY || !this.scanLevel(downLevel, minX, maxX, minZ, maxZ)) continue;
                this.currentMiningLevel = downLevel;
                foundNewLevel = true;
                break;
            }
            if (!foundNewLevel) {
                this.currentMiningLevel = this.m_58899_().m_123342_();
                this.currentMiningLevel = Math.max(minY, Math.min(maxY, this.currentMiningLevel));
            }
        }
    }

    private boolean scanLevel(int y, int minX, int maxX, int minZ, int maxZ) {
        boolean foundAny = false;
        int centerX = this.m_58899_().m_123341_();
        int centerZ = this.m_58899_().m_123343_();
        ArrayList<BlockPos> levelPositions = new ArrayList<BlockPos>();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                BlockPos checkPos = new BlockPos(x, y, z);
                if (!this.canMineAt(checkPos)) continue;
                levelPositions.add(checkPos);
                foundAny = true;
            }
        }
        levelPositions.sort((pos1, pos2) -> {
            double dist1 = Math.pow(pos1.m_123341_() - centerX, 2.0) + Math.pow(pos1.m_123343_() - centerZ, 2.0);
            double dist2 = Math.pow(pos2.m_123341_() - centerX, 2.0) + Math.pow(pos2.m_123343_() - centerZ, 2.0);
            return Double.compare(dist1, dist2);
        });
        this.miningPositions.addAll(levelPositions);
        return foundAny;
    }

    private boolean performMining() {
        if (this.miningPositions.isEmpty()) {
            return false;
        }
        Iterator<BlockPos> iterator = this.miningPositions.iterator();
        BlockPos minePos = iterator.next();
        iterator.remove();
        if (this.canMineAt(minePos)) {
            BlockState state = this.f_58857_.m_8055_(minePos);
            Block block = state.m_60734_();
            LootParams.Builder lootBuilder = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)minePos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287286_(LootContextParams.f_81461_, (Object)state);
            LootTable lootTable = this.f_58857_.m_7654_().m_278653_().m_278676_(block.m_60589_());
            ObjectArrayList drops = lootTable.m_287195_(lootBuilder.m_287235_(LootContextParamSets.f_81421_));
            boolean canStoreAll = true;
            ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>();
            for (ItemStack drop : drops) {
                ItemStack simulated = this.simulateInsertItem(drop.m_41777_());
                if (simulated.m_41619_()) continue;
                canStoreAll = false;
                remainingItems.add(simulated);
            }
            if (canStoreAll || drops.isEmpty()) {
                this.f_58857_.m_7731_(minePos, Blocks.f_50016_.m_49966_(), 3);
                this.f_58857_.m_5594_(null, minePos, state.m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.spawnBreakParticles(minePos, state);
                for (ItemStack drop : drops) {
                    ItemStack remaining = this.insertItem(drop.m_41777_());
                    if (remaining.m_41619_()) continue;
                    Block.m_49840_((Level)this.f_58857_, (BlockPos)minePos, (ItemStack)remaining);
                }
                return true;
            }
            this.miningPositions.add(minePos);
            return false;
        }
        return !this.miningPositions.isEmpty();
    }

    private boolean canMineAt(BlockPos pos) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return false;
        }
        BlockState state = this.f_58857_.m_8055_(pos);
        Block block = state.m_60734_();
        if (state.m_60795_() || block == Blocks.f_50752_ || state.m_60819_().m_76170_()) {
            return false;
        }
        if (pos.equals((Object)this.m_58899_())) {
            return false;
        }
        return this.isMineableBlock(state);
    }

    private boolean isMineableBlock(BlockState state) {
        Block block = state.m_60734_();
        float hardness = state.m_60800_((BlockGetter)this.f_58857_, BlockPos.f_121853_);
        if (hardness < 0.0f) {
            return false;
        }
        if (hardness <= 0.0f) {
            return false;
        }
        if (block == Blocks.f_50085_ || block == Blocks.f_50752_ || block == Blocks.f_50258_ || block == Blocks.f_50257_ || block == Blocks.f_50142_ || block == Blocks.f_50375_) {
            return false;
        }
        return hardness >= 0.1f && hardness <= 50.0f;
    }

    private ItemStack insertItem(ItemStack stack) {
        for (int i = 0; i < this.inventory.m_6643_() && !(stack = this.inventory.m_19173_(stack)).m_41619_(); ++i) {
        }
        return stack;
    }

    private ItemStack simulateInsertItem(ItemStack stack) {
        ItemStack remaining = stack.m_41777_();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            int space;
            ItemStack slotStack = this.inventory.m_8020_(i);
            if (slotStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)remaining) || (space = slotStack.m_41741_() - slotStack.m_41613_()) <= 0) continue;
            int toInsert = Math.min(space, remaining.m_41613_());
            remaining.m_41774_(toInsert);
            if (!remaining.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return remaining;
    }

    @Override
    public int getMaxRangeDown() {
        return 50;
    }

    @Override
    public int getMaxRangeLeft() {
        return 25;
    }

    @Override
    public int getMaxRangeRight() {
        return 25;
    }

    @Override
    public int getMaxRangeUp() {
        return 50;
    }

    @Override
    public void setWorkRangeLeft(int range) {
        super.setWorkRangeLeft(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeRight(int range) {
        super.setWorkRangeRight(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeUp(int range) {
        super.setWorkRangeUp(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeDown(int range) {
        this.workRangeDown = Math.max(-50, Math.min(range, this.getMaxRangeDown()));
        this.updateWorkCenter();
        this.m_6596_();
        this.syncToClient();
        this.updateRangeChunkLoading();
        this.clearWorkCache();
    }

    private void clearWorkCache() {
        this.miningPositions.clear();
        this.currentMiningLevel = null;
        this.levelsUpMined = 0;
        this.levelsDownMined = 0;
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new MiningWorkstationScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"hundred_years_war.mining_workstation");
    }

    @Override
    public Direction getFacing() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)MiningWorkstation.FACING)) {
            return (Direction)state.m_61143_((Property)MiningWorkstation.FACING);
        }
        return Direction.NORTH;
    }

    private void spawnBreakParticles(BlockPos pos, BlockState state) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.f_58857_;
        RandomSource random = serverLevel.m_213780_();
        BlockParticleOption particleOption = new BlockParticleOption(ParticleTypes.f_123794_, state);
        double centerX = (double)pos.m_123341_() + 0.5;
        double centerY = (double)pos.m_123342_() + 0.5;
        double centerZ = (double)pos.m_123343_() + 0.5;
        for (int i = 0; i < 12; ++i) {
            double offsetX = (random.m_188500_() - 0.5) * 0.8;
            double offsetY = (random.m_188500_() - 0.5) * 0.8;
            double offsetZ = (random.m_188500_() - 0.5) * 0.8;
            double velX = (random.m_188500_() - 0.5) * 0.2;
            double velY = random.m_188500_() * 0.15;
            double velZ = (random.m_188500_() - 0.5) * 0.2;
            serverLevel.m_8767_((ParticleOptions)particleOption, centerX + offsetX, centerY + offsetY, centerZ + offsetZ, 1, velX, velY, velZ, 0.1);
        }
    }
}

