/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import ydmsama.hundred_years_war.main.data.TransportData;
import ydmsama.hundred_years_war.main.item.TransportOrderItem;

public class TransportOrderScreenHandler
extends AbstractContainerMenu {
    public static final MenuType<TransportOrderScreenHandler> TYPE = new MenuType(TransportOrderScreenHandler::clientCreate, null);
    private static ItemStack clientItemStack = null;
    private final ItemStack itemStack;
    private final BlockPos boundPos;
    private final TransportData transportData;

    public static TransportOrderScreenHandler clientCreate(int syncId, Inventory playerInventory) {
        ItemStack stack = clientItemStack;
        clientItemStack = null;
        if (stack != null) {
            return new TransportOrderScreenHandler(syncId, playerInventory, stack);
        }
        throw new IllegalStateException("No ItemStack set for client screen handler creation");
    }

    public static void setClientItemStack(ItemStack stack) {
        clientItemStack = stack;
    }

    public TransportOrderScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf buf) {
        super(TYPE, syncId);
        this.itemStack = buf.m_130267_();
        this.boundPos = buf.m_130135_();
        this.transportData = new TransportData();
        if (buf.readBoolean()) {
            this.transportData.deserializeNBT(buf.m_130260_());
        }
        this.setupSlots(playerInventory);
    }

    public TransportOrderScreenHandler(int syncId, Inventory playerInventory, ItemStack stack) {
        super(TYPE, syncId);
        this.itemStack = stack;
        if (stack.m_41720_() instanceof TransportOrderItem) {
            this.boundPos = TransportOrderItem.getBoundWorkstation(stack);
            this.transportData = TransportOrderItem.getTransportData(stack);
        } else {
            this.boundPos = null;
            this.transportData = new TransportData();
        }
        this.setupSlots(playerInventory);
    }

    private void setupSlots(Inventory playerInventory) {
        int yOffset = 158;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 47 + col * 18, yOffset + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 47 + col * 18, yOffset + 58));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return !this.itemStack.m_41619_() && player.m_150109_().m_36063_(this.itemStack);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public BlockPos getBoundPos() {
        return this.boundPos;
    }

    public TransportData getTransportData() {
        return this.transportData;
    }
}

