/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.OpenWorkstationSyncPacket;

public class TransportWorkstation
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public TransportWorkstation(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        super.m_6402_(world, pos, state, placer, itemStack);
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof TransportWorkstationBlockEntity) {
            TransportWorkstationBlockEntity workstation = (TransportWorkstationBlockEntity)blockEntity;
            CompoundTag tag = itemStack.m_41783_();
            if (tag != null && tag.m_128441_("BlockEntityTag")) {
                CompoundTag blockEntityTag = tag.m_128469_("BlockEntityTag");
                workstation.m_142466_(blockEntityTag);
                workstation.getTransportData().validateAndUpdateRoutes(pos);
                if (placer instanceof Player) {
                    CompoundTag transportTag;
                    int originalCount;
                    Player player = (Player)placer;
                    int routeCount = workstation.getTransportData().getRoutes().size();
                    if (blockEntityTag.m_128441_("TransportData") && (originalCount = (transportTag = blockEntityTag.m_128469_("TransportData")).m_128437_("Routes", 10).size()) > routeCount) {
                        int removed = originalCount - routeCount;
                        player.m_5661_((Component)Component.m_237110_((String)"block.hundred_years_war.transport_workstation.routes_removed", (Object[])new Object[]{removed}), true);
                    }
                }
            }
            workstation.syncToClient();
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TransportWorkstationBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerPacketHandler.sendOpenWorkstationSync(serverPlayer, pos, OpenWorkstationSyncPacket.WorkstationType.TRANSPORT);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof TransportWorkstationBlockEntity) {
                TransportWorkstationBlockEntity transportWorkstation = (TransportWorkstationBlockEntity)blockEntity;
                ItemStack itemStack = new ItemStack((ItemLike)this);
                CompoundTag blockEntityTag = transportWorkstation.m_187482_();
                CompoundTag lastPosTag = new CompoundTag();
                lastPosTag.m_128405_("x", pos.m_123341_());
                lastPosTag.m_128405_("y", pos.m_123342_());
                lastPosTag.m_128405_("z", pos.m_123343_());
                blockEntityTag.m_128365_("LastPos", (Tag)lastPosTag);
                if (!blockEntityTag.m_128456_()) {
                    itemStack.m_41700_("BlockEntityTag", (Tag)blockEntityTag);
                }
                Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)itemStack);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return world.f_46443_ ? null : TransportWorkstation.createTransportWorkstationTicker(type);
    }

    @Nullable
    private static <T extends BlockEntity> BlockEntityTicker<T> createTransportWorkstationTicker(BlockEntityType<T> type) {
        return type == ModBlockEntities.TRANSPORT_WORKSTATION.get() ? TransportWorkstationBlockEntity::tick : null;
    }
}

