/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.workstation.InventoryBoundedWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.data.TransportData;

public class TransportWorkstationBlockEntity
extends InventoryBoundedWorkstationBlockEntity {
    private static final int INVENTORY_SIZE = 27;
    private TransportData transportData = new TransportData();

    public TransportWorkstationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRANSPORT_WORKSTATION.get(), pos, state);
        this.inventory = new SimpleContainer(27);
        this.workRangeLeft = 0;
        this.workRangeRight = 0;
        this.workRangeUp = 0;
        this.workRangeDown = 0;
        this.showRange = false;
    }

    @Override
    public int getMaxRangeLeft() {
        return 0;
    }

    @Override
    public int getMaxRangeRight() {
        return 0;
    }

    @Override
    public int getMaxRangeUp() {
        return 0;
    }

    @Override
    public int getMaxRangeDown() {
        return 0;
    }

    @Override
    public Direction getFacing() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)TransportWorkstation.FACING)) {
            return (Direction)state.m_61143_((Property)TransportWorkstation.FACING);
        }
        return Direction.NORTH;
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new TransportWorkstationScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"block.hundred_years_war.transport_workstation");
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TransportWorkstationBlockEntity blockEntity) {
        if (world.f_46443_) {
            return;
        }
    }

    public TransportData getTransportData() {
        return this.transportData;
    }

    public void setTransportData(TransportData data) {
        this.transportData = data;
        this.m_6596_();
    }

    public boolean performTransportWork() {
        if (this.transportData.isEmpty() || this.f_58857_ == null || this.f_58857_.f_46443_) {
            return false;
        }
        TransportData.TransportRoute currentRoute = this.transportData.getCurrentRoute();
        if (currentRoute == null) {
            return false;
        }
        boolean result = currentRoute.execute(this, this.f_58857_);
        this.transportData.moveToNext();
        this.m_6596_();
        return true;
    }

    @Override
    public void triggerWork() {
        this.performTransportWork();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("TransportData", (Tag)this.transportData.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("TransportData")) {
            this.transportData.deserializeNBT(tag.m_128469_("TransportData"));
        }
    }

    private boolean isContainerItem(ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof TransportWorkstation) {
            ListTag itemsTag;
            CompoundTag blockEntityTag;
            CompoundTag tag = stack.m_41783_();
            return tag != null && tag.m_128441_("BlockEntityTag") && (blockEntityTag = tag.m_128469_("BlockEntityTag")).m_128441_("Items") && !(itemsTag = blockEntityTag.m_128437_("Items", 10)).isEmpty();
        }
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            CompoundTag blockEntityTag;
            if (tag.m_128441_("BlockEntityTag") && this.hasContainerTags(blockEntityTag = tag.m_128469_("BlockEntityTag"))) {
                return true;
            }
            if (this.hasContainerTags(tag)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasContainerTags(CompoundTag tag) {
        String[] containerIndicators;
        for (String indicator : containerIndicators = new String[]{"Items", "Inventory", "Contents", "StoredItems", "ItemStorage", "items", "inventory", "BlockInventory", "TileItems"}) {
            CompoundTag compound;
            ListTag listTag;
            if (!tag.m_128441_(indicator) || !(tag.m_128425_(indicator, 9) ? !(listTag = tag.m_128437_(indicator, 10)).isEmpty() : tag.m_128425_(indicator, 10) && !(compound = tag.m_128469_(indicator)).m_128456_())) continue;
            return true;
        }
        if (tag.m_128440_() > 10) {
            return this.checkForDeepNesting(tag, 0);
        }
        return false;
    }

    private boolean checkForDeepNesting(CompoundTag tag, int depth) {
        if (depth > 2) {
            return true;
        }
        for (String key : tag.m_128431_()) {
            ListTag list;
            Tag element = tag.m_128423_(key);
            if (element instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)element;
                if (!this.checkForDeepNesting(compound, depth + 1)) continue;
                return true;
            }
            if (!(element instanceof ListTag) || (list = (ListTag)element).isEmpty() || list.m_7264_() != 10) continue;
            for (int i = 0; i < list.size(); ++i) {
                if (list.m_128728_(i).m_128440_() <= 3) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean m_7013_(int index, ItemStack stack) {
        return !this.isContainerItem(stack);
    }
}

