/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationBlockEntity;

public class TransportWorkstationScreenHandler
extends AbstractContainerMenu {
    public static final MenuType<TransportWorkstationScreenHandler> TYPE = new MenuType(TransportWorkstationScreenHandler::clientCreate, null);
    private static BlockPos clientBlockPos = null;
    private TransportWorkstationBlockEntity blockEntity;
    private final Level world;

    public static TransportWorkstationScreenHandler clientCreate(int syncId, Inventory playerInventory) {
        BlockPos pos = clientBlockPos;
        clientBlockPos = null;
        if (pos != null) {
            return new TransportWorkstationScreenHandler(syncId, playerInventory, pos);
        }
        throw new IllegalStateException("No BlockPos set for client screen handler creation");
    }

    public static void setClientBlockPos(BlockPos pos) {
        clientBlockPos = pos;
    }

    public TransportWorkstationScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf buf) {
        super(TYPE, syncId);
        BlockPos pos = buf.m_130135_();
        this.world = playerInventory.f_35978_.m_9236_();
        BlockEntity blockEntity = this.world.m_7702_(pos);
        if (blockEntity instanceof TransportWorkstationBlockEntity) {
            TransportWorkstationBlockEntity entity;
            this.blockEntity = entity = (TransportWorkstationBlockEntity)blockEntity;
        }
        this.setupSlots(playerInventory);
    }

    public TransportWorkstationScreenHandler(int syncId, Inventory playerInventory, BlockPos pos) {
        super(TYPE, syncId);
        this.world = playerInventory.f_35978_.m_9236_();
        BlockEntity blockEntity = this.world.m_7702_(pos);
        if (blockEntity instanceof TransportWorkstationBlockEntity) {
            TransportWorkstationBlockEntity entity;
            this.blockEntity = entity = (TransportWorkstationBlockEntity)blockEntity;
        }
        this.setupSlots(playerInventory);
    }

    public TransportWorkstationScreenHandler(int syncId, Inventory playerInventory, TransportWorkstationBlockEntity blockEntity) {
        super(TYPE, syncId);
        this.blockEntity = blockEntity;
        this.world = playerInventory.f_35978_.m_9236_();
        this.setupSlots(playerInventory);
    }

    private void setupSlots(Inventory playerInventory) {
        int col;
        int row;
        if (this.blockEntity != null) {
            for (row = 0; row < 3; ++row) {
                for (col = 0; col < 9; ++col) {
                    int index = row * 9 + col;
                    this.m_38897_(new RestrictedSlot((Container)this.blockEntity, index, 8 + col * 18, 18 + row * 18));
                }
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.m_38897_(new Slot((Container)playerInventory, col2, 8 + col2 * 18, 142));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            newStack = originalStack.m_41777_();
            if (index < 27 ? !this.m_38903_(originalStack, 27, this.f_38839_.size(), true) : !this.m_38903_(originalStack, 0, 27, false)) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return newStack;
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity != null && this.blockEntity.m_6542_(player);
    }

    public TransportWorkstationBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    private static class RestrictedSlot
    extends Slot {
        public RestrictedSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return this.f_40218_.m_7013_(this.f_40219_, stack);
        }
    }
}

