/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class PlayerRelationCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"hundred_years_war").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"relation").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (RelationSystem.RelationType type : RelationSystem.RelationType.values()) {
                builder.suggest(type.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> PlayerRelationCommands.setRelation((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"type"))))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).executes(PlayerRelationCommands::getRelation)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(PlayerRelationCommands::listAllRelations)).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (RelationSystem.RelationType type : RelationSystem.RelationType.values()) {
                builder.suggest(type.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> PlayerRelationCommands.listRelationsByType((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"type")))))));
    }

    private static int setRelation(CommandContext<CommandSourceStack> context, String relationTypeStr) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            Collection targets = GameProfileArgument.m_94590_(context, (String)"player");
            RelationSystem.RelationType relationType = RelationSystem.RelationType.valueOf(relationTypeStr.toUpperCase());
            for (GameProfile target : targets) {
                UUID targetUUID = target.getId();
                if (player.m_20148_().equals(targetUUID)) {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"relation.error.self"));
                    continue;
                }
                RelationSystem.setRelation(player.m_20148_(), targetUUID, relationType);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"relation.set.success", (Object[])new Object[]{target.getName(), Component.m_237115_((String)("relation.type." + relationType.name().toLowerCase()))}), false);
            }
            return 1;
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"relation.error.invalid_type"));
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"relation.error.generic", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }

    private static int getRelation(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            Collection targets = GameProfileArgument.m_94590_(context, (String)"player");
            for (GameProfile target : targets) {
                UUID targetUUID = target.getId();
                RelationSystem.RelationType myRelation = RelationSystem.getRelation(player.m_20148_(), targetUUID);
                RelationSystem.RelationType theirRelation = RelationSystem.getRelation(targetUUID, player.m_20148_());
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"relation.get.result.my", (Object[])new Object[]{target.getName(), Component.m_237115_((String)("relation.type." + myRelation.name().toLowerCase()))}), false);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"relation.get.result.their", (Object[])new Object[]{target.getName(), Component.m_237115_((String)("relation.type." + theirRelation.name().toLowerCase()))}), false);
                if (!RelationSystem.hasMutualRelation(player.m_20148_(), targetUUID)) continue;
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"relation.get.result.mutual", (Object[])new Object[]{Component.m_237115_((String)("relation.type." + myRelation.name().toLowerCase()))}), false);
            }
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"relation.error.get", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }

    private static int listAllRelations(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            Map<UUID, RelationSystem.RelationType> relations = RelationSystem.getAllRelations(player.m_20148_());
            if (relations.isEmpty()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"relation.list.empty"), false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"relation.list.header"), false);
            GameProfileCache profileCache = ((CommandSourceStack)context.getSource()).m_81377_().m_129927_();
            for (Map.Entry<UUID, RelationSystem.RelationType> entry : relations.entrySet()) {
                UUID targetUUID = entry.getKey();
                RelationSystem.RelationType relation = entry.getValue();
                Optional<String> nameOpt = profileCache.m_11002_(targetUUID).map(profile -> profile.getName());
                String name = nameOpt.orElse(targetUUID.toString());
                boolean isMutual = RelationSystem.hasMutualRelation(player.m_20148_(), targetUUID, relation);
                if (isMutual) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"relation.list.entry.mutual", (Object[])new Object[]{name, Component.m_237115_((String)("relation.type." + relation.name().toLowerCase()))}), false);
                    continue;
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"relation.list.entry", (Object[])new Object[]{name, Component.m_237115_((String)("relation.type." + relation.name().toLowerCase()))}), false);
            }
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"relation.error.list", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }

    private static int listRelationsByType(CommandContext<CommandSourceStack> context, String relationTypeStr) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            RelationSystem.RelationType relationType = RelationSystem.RelationType.valueOf(relationTypeStr.toUpperCase());
            Map<UUID, RelationSystem.RelationType> relations = RelationSystem.getRelationsByType(player.m_20148_(), relationType);
            if (relations.isEmpty()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"relation.list.type.empty", (Object[])new Object[]{Component.m_237115_((String)("relation.type." + relationType.name().toLowerCase()))}), false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"relation.list.type.header", (Object[])new Object[]{Component.m_237115_((String)("relation.type." + relationType.name().toLowerCase()))}), false);
            GameProfileCache profileCache = ((CommandSourceStack)context.getSource()).m_81377_().m_129927_();
            for (UUID targetUUID : relations.keySet()) {
                Optional<String> nameOpt = profileCache.m_11002_(targetUUID).map(profile -> profile.getName());
                String name = nameOpt.orElse(targetUUID.toString());
                boolean isMutual = RelationSystem.hasMutualRelation(player.m_20148_(), targetUUID, relationType);
                if (isMutual) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"relation.list.type.entry.mutual", (Object[])new Object[]{name}), false);
                    continue;
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"relation.list.type.entry", (Object[])new Object[]{name}), false);
            }
            return 1;
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"relation.error.invalid_type"));
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"relation.error.list_type", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }
}

