/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.action.CancelAction;
import ydmsama.hundred_years_war.main.entity.action.HoldAction;
import ydmsama.hundred_years_war.main.entity.action.PatrolAction;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.main.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.main.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.main.utils.ChunkLoadingUtils;

public abstract class BaseWorkerEntity
extends BaseCombatEntity {
    private boolean chunkLoadingActive = false;
    private ChunkPos lastChunkPos = null;

    public BaseWorkerEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(1, (Goal)new FollowEntityGoal(this, 1.0, ServerModConfig.INSTANCE.getFollowDistanceInner(), ServerModConfig.INSTANCE.getFollowDistanceOuter(), 25.0, 50.0));
        this.f_21345_.m_25352_(2, (Goal)new PatrolGoal(this, 1.0, 40));
        this.f_21345_.m_25352_(2, (Goal)new FollowEntityGoal(this, 1.0, ServerModConfig.INSTANCE.getFollowDistanceInner(), ServerModConfig.INSTANCE.getFollowDistanceInner(), Double.MAX_VALUE, 0.0));
        this.f_21345_.m_25352_(4, (Goal)new ReturnToHomeGoal(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    protected void initActions() {
        this.getActions().add(new HoldAction());
        this.getActions().add(new CancelAction());
        this.getActions().add(new PatrolAction());
        this.initCustomActions();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.updateChunkLoading();
        }
    }

    private void updateChunkLoading() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos currentBlockPos = this.m_20183_();
        ChunkPos currentChunkPos = new ChunkPos(currentBlockPos);
        if (!this.chunkLoadingActive) {
            ChunkLoadingUtils.addWorkerChunkLoading(serverLevel, currentBlockPos);
            this.chunkLoadingActive = true;
            this.lastChunkPos = currentChunkPos;
        } else if (this.lastChunkPos == null || !this.lastChunkPos.equals((Object)currentChunkPos)) {
            if (this.lastChunkPos != null) {
                BlockPos oldPos = new BlockPos(this.lastChunkPos.m_151390_(), currentBlockPos.m_123342_(), this.lastChunkPos.m_151393_());
                ChunkLoadingUtils.removeWorkerChunkLoading(serverLevel, oldPos);
            }
            ChunkLoadingUtils.addWorkerChunkLoading(serverLevel, currentBlockPos);
            this.lastChunkPos = currentChunkPos;
        }
    }

    private void deactivateChunkLoading() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.chunkLoadingActive) {
                BlockPos pos = this.lastChunkPos != null ? new BlockPos(this.lastChunkPos.m_151390_(), this.m_20183_().m_123342_(), this.lastChunkPos.m_151393_()) : this.m_20183_();
                ChunkLoadingUtils.removeWorkerChunkLoading(serverLevel, pos);
                this.chunkLoadingActive = false;
                this.lastChunkPos = null;
            }
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.deactivateChunkLoading();
        super.m_142687_(reason);
    }
}

