/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.UseCrossbow;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterHeavy;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.RangedUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.entity.utils.Mountable;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class CrossbowmanEntity
extends BaseCombatEntity
implements RangedAttackMob,
UseCrossbow,
LightUnit,
RangedUnit,
CounterHeavy,
Mountable {
    private static final float ATTACK_REACH = 80.0f;
    private static final float MOVEMENT_SPEED = 0.3f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 3.5f;
    private static final EntityDataAccessor<Integer> USE_ANGLE = SynchedEntityData.m_135353_(CrossbowmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public CrossbowmanEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(USE_ANGLE, (Object)1);
    }

    public static AttributeSupplier.Builder createCrossbowmanAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 80.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22278_, 0.4).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 80.0).m_22268_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get(), 3.5);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    protected void setDefaultEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
        this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42464_));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42465_));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42466_));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42467_));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    @Override
    public int getBaseAttackAnimationTime() {
        ItemStack crossbowStack = this.m_21120_(InteractionHand.MAIN_HAND);
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)crossbowStack);
        int baseCooldown = 25;
        int cooldownReduction = quickChargeLevel * 5;
        return baseCooldown - cooldownReduction;
    }

    @Override
    public int getAttackDamageTickDelay() {
        Random random = new Random();
        return Math.max(this.getBaseAttackAnimationTime() - random.nextInt(10), 5);
    }

    @Override
    public int getAttackCoolDownDuration() {
        ItemStack crossbowStack = this.m_21120_(InteractionHand.MAIN_HAND);
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)crossbowStack);
        Random random = new Random();
        int baseCooldown = 60 + random.nextInt(20);
        int cooldownReduction = quickChargeLevel * 10;
        return Math.max(baseCooldown - cooldownReduction, 20);
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        ItemStack crossbowStack = this.m_21120_(InteractionHand.MAIN_HAND);
        int piercingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crossbowStack);
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)crossbowStack);
        boolean hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)crossbowStack) > 0;
        float speed = 3.0f;
        float inaccuracy = 2.0f;
        if (hasMultishot) {
            for (int i = -1; i <= 1; ++i) {
                AbstractArrow arrow = this.createArrow(crossbowStack, piercingLevel);
                this.shootArrowAtTarget(arrow, target, speed, inaccuracy, i * 10);
            }
        } else {
            AbstractArrow arrow = this.createArrow(crossbowStack, piercingLevel);
            this.shootArrowAtTarget(arrow, target, speed, inaccuracy, 0.0f);
        }
        this.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_5810_();
    }

    private AbstractArrow createArrow(ItemStack crossbowStack, int piercingLevel) {
        AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)new ItemStack((ItemLike)Items.f_42412_), (float)1.0f);
        arrow.m_36781_(this.m_21133_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get()));
        if (piercingLevel > 0) {
            arrow.m_36767_((byte)piercingLevel);
        }
        return arrow;
    }

    private void shootArrowAtTarget(AbstractArrow arrow, LivingEntity target, float speed, float inaccuracy, float yawOffset) {
        double dy;
        double dz;
        double dx = target.m_20185_() - this.m_20185_();
        double distance = Math.sqrt(dx * dx + (dz = target.m_20189_() - this.m_20189_()) * dz + (dy = target.m_20227_(0.5) - arrow.m_20186_()) * dy);
        if (distance == 0.0) {
            return;
        }
        double gravity = 0.05;
        double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
        if (!(!Double.isNaN(angles[1]) && this.isPathClear(arrow, angles[1], speed, dx, dy, dz, distance, target) || distance < 5.0)) {
            return;
        }
        double angle = angles[1];
        double randomSpeedOffset = CrossbowmanEntity.getRandomInRange(-0.25, 0.75);
        double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
        double targetVelocityX = target.m_20184_().m_7096_();
        double targetVelocityZ = target.m_20184_().m_7094_();
        double predictedX = target.m_20185_() + targetVelocityX * timeToTarget;
        double predictedZ = target.m_20189_() + targetVelocityZ * timeToTarget;
        double predictedDistance = Math.sqrt((predictedX - this.m_20185_()) * (predictedX - this.m_20185_()) + (predictedZ - this.m_20189_()) * (predictedZ - this.m_20189_()));
        angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
        angle = angles[1];
        double yaw = Math.atan2(predictedZ - this.m_20189_(), predictedX - this.m_20185_());
        double yawOffsetRadians = Math.toRadians(yawOffset);
        double adjustedYaw = yaw + yawOffsetRadians;
        double horizontalSpeed = Math.cos(angle) * (double)speed;
        float velocityX = (float)(horizontalSpeed * Math.cos(adjustedYaw));
        float velocityY = (float)(Math.sin(angle) * (double)speed);
        float velocityZ = (float)(horizontalSpeed * Math.sin(adjustedYaw));
        arrow.m_6686_((double)velocityX, (double)velocityY, (double)velocityZ, speed, inaccuracy);
        this.m_9236_().m_7967_((Entity)arrow);
    }

    private boolean isPathClear(AbstractArrow arrow, double angle, float speed, double dx, double dy, double dz, double distance, LivingEntity target) {
        Vec3 startPos = this.m_146892_();
        Vec3 direction = new Vec3(dx / distance, Math.tan(angle), dz / distance).m_82541_();
        Vec3 endPos = startPos.m_82549_(direction.m_82490_(5.0));
        BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)arrow));
        return hitResult.m_6662_() == HitResult.Type.MISS;
    }

    private boolean isTargetExposedToSky(LivingEntity target) {
        BlockPos targetPos = target.m_20183_();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos posToCheck = targetPos.m_7918_(x, 0, z);
                if (!this.m_9236_().m_45527_(posToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.75));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_CROSSBOWMAN.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_CROSSBOWMAN_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_CROSSBOWMAN_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_CROSSBOWMAN_3.get();
            default -> null;
        };
    }

    @Override
    public boolean isValidTarget(LivingEntity potentialTarget) {
        if (this.isObstructed(potentialTarget)) {
            return false;
        }
        return super.isValidTarget(potentialTarget);
    }

    @Override
    public boolean canFireAtTarget(LivingEntity target) {
        if (this.isObstructed(target)) {
            return false;
        }
        return super.canFireAtTarget(target);
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        super.increaseStatsOnLevelUp();
        AttributeInstance rangedAttackDamage = this.m_21051_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get());
        if (rangedAttackDamage != null) {
            rangedAttackDamage.m_22100_(rangedAttackDamage.m_22115_() + 0.1);
        }
    }

    @Override
    public double getLightDamageModifier() {
        return 0.5;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 1.5;
    }
}

