/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterRanged;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.RangedUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.entity.goals.SkyExposedTargetGoal;
import ydmsama.hundred_years_war.main.entity.utils.BackItemHolder;
import ydmsama.hundred_years_war.main.entity.utils.MeleeCapableRangedAttacker;
import ydmsama.hundred_years_war.main.entity.utils.Mountable;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;
import ydmsama.hundred_years_war.main.utils.WeaponTypeHelper;

public class HywSkeletonArcherEntity
extends BaseCombatEntity
implements RangedAttackMob,
MeleeCapableRangedAttacker,
BackItemHolder,
LightUnit,
RangedUnit,
CounterRanged,
Mountable {
    private static final float ATTACK_REACH = 100.0f;
    private static final float MOVEMENT_SPEED = 0.3f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 2.5f;
    private float currentSpeed = 0.3f;
    private static final EntityDataAccessor<Integer> USE_ANGLE = SynchedEntityData.m_135353_(HywSkeletonArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> WEAPON_RANGED = SynchedEntityData.m_135353_(HywSkeletonArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> WEAPON_MELEE = SynchedEntityData.m_135353_(HywSkeletonArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> IS_USING_RANGED = SynchedEntityData.m_135353_(HywSkeletonArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int noTargetTicks = 0;
    private static final int SWITCH_THRESHOLD = 100;

    public HywSkeletonArcherEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(USE_ANGLE, (Object)1);
        this.f_19804_.m_135372_(WEAPON_RANGED, (Object)new ItemStack((ItemLike)Items.f_42411_));
        this.f_19804_.m_135372_(WEAPON_MELEE, (Object)new ItemStack((ItemLike)Items.f_42383_));
        this.f_19804_.m_135372_(IS_USING_RANGED, (Object)true);
    }

    public ItemStack getRangedWeapon() {
        return (ItemStack)this.f_19804_.m_135370_(WEAPON_RANGED);
    }

    public void setRangedWeapon(ItemStack stack) {
        this.f_19804_.m_135381_(WEAPON_RANGED, (Object)stack);
    }

    public ItemStack getMeleeWeapon() {
        return (ItemStack)this.f_19804_.m_135370_(WEAPON_MELEE);
    }

    public void setMeleeWeapon(ItemStack stack) {
        this.f_19804_.m_135381_(WEAPON_MELEE, (Object)stack);
    }

    @Override
    public boolean isUsingRanged() {
        return (Boolean)this.f_19804_.m_135370_(IS_USING_RANGED);
    }

    @Override
    public void setUsingRanged(boolean usingRanged) {
        boolean wasUsingRanged = this.isUsingRanged();
        this.f_19804_.m_135381_(IS_USING_RANGED, (Object)usingRanged);
        this.m_8061_(EquipmentSlot.MAINHAND, usingRanged ? this.getRangedWeapon() : this.getMeleeWeapon());
    }

    @Override
    public ItemStack getBackItem() {
        return this.isUsingRanged() ? this.getMeleeWeapon() : this.getRangedWeapon();
    }

    @Override
    public void setBackItem(ItemStack itemStack) {
        if (this.isUsingRanged()) {
            this.setMeleeWeapon(itemStack);
        } else {
            this.setRangedWeapon(itemStack);
        }
    }

    @Override
    public boolean shouldRenderBackItem() {
        return !this.getBackItem().m_41619_();
    }

    @Override
    public float getMeleeAttackReach() {
        return 2.5f;
    }

    public static AttributeSupplier.Builder createHywSkeletonArcherAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22278_, 0.4).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 100.0).m_22268_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get(), 2.5);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (this.getHywTarget() != null) {
                this.noTargetTicks = 0;
                double distanceToTarget = this.m_20280_((Entity)this.getHywTarget());
                if (distanceToTarget < 30.0) {
                    if (this.isUsingRanged()) {
                        this.setUsingRanged(false);
                    }
                } else if (distanceToTarget > 35.0 && !this.isUsingRanged()) {
                    this.setUsingRanged(true);
                }
            } else {
                ++this.noTargetTicks;
                if (this.noTargetTicks >= 100 && !this.isUsingRanged()) {
                    this.setUsingRanged(true);
                    this.noTargetTicks = 0;
                }
            }
        }
    }

    @Override
    public float getAttackReach() {
        if (this.isUsingRanged()) {
            return super.getAttackReach();
        }
        return this.getMeleeAttackReach();
    }

    @Override
    protected void setDefaultEquipment() {
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return this.isUsingRanged() ? 15 : 6;
    }

    @Override
    public int getAttackDamageTickDelay() {
        Random random = new Random();
        return this.isUsingRanged() ? Math.max(this.getBaseAttackAnimationTime() - random.nextInt(5), 5) : 5;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return this.isUsingRanged() ? 3 + random.nextInt(8) : 1 + random.nextInt(5);
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        double dy;
        double dz;
        double dx;
        double distance;
        if (!this.isUsingRanged()) {
            return;
        }
        AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)new ItemStack((ItemLike)Items.f_42412_), (float)pullProgress);
        arrow.m_36781_(this.m_21133_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get()));
        ItemStack bowStack = this.getRangedWeapon();
        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)bowStack);
        int punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)bowStack);
        int flameLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)bowStack);
        if (powerLevel > 0) {
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
        if (punchLevel > 0) {
            arrow.m_36735_(punchLevel);
        }
        if (flameLevel > 0) {
            arrow.m_20254_(100);
        }
        if ((distance = Math.sqrt((dx = target.m_20185_() - this.m_20185_()) * dx + (dz = target.m_20189_() - this.m_20189_()) * dz + (dy = target.m_20227_(0.5) - arrow.m_20186_()) * dy)) == 0.0) {
            return;
        }
        float speed = 2.0f;
        double gravity = 0.05;
        double angle = Double.NaN;
        float maxArrowSpeed = 3.0f;
        float miss = 2.5f;
        this.setUseAngle(-1);
        while (speed <= maxArrowSpeed) {
            double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
            if (!(this.isObstructed(target) && !this.m_20159_() || Double.isNaN(angles[1]) && !(distance < 5.0))) {
                angle = angles[1];
                this.setUseAngle(1);
                break;
            }
            if (!Double.isNaN(angles[0]) && this.isPathClear(arrow, angles[0], speed, dx, dy, dz, distance, target)) {
                angle = angles[0];
                this.setUseAngle(0);
                break;
            }
            if (!((speed += 0.25f) > maxArrowSpeed)) continue;
            break;
        }
        if (this.getUseAngle() == -1) {
            return;
        }
        double randomSpeedOffset = HywSkeletonArcherEntity.getRandomInRange(-0.25, 0.75);
        double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
        double targetVelocityX = target.m_20184_().m_7096_();
        double targetVelocityZ = target.m_20184_().m_7094_();
        double predictedX = target.m_20185_() + targetVelocityX * timeToTarget;
        double predictedZ = target.m_20189_() + targetVelocityZ * timeToTarget;
        double predictedDistance = Math.sqrt((predictedX - this.m_20185_()) * (predictedX - this.m_20185_()) + (predictedZ - this.m_20189_()) * (predictedZ - this.m_20189_()));
        double[] angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
        if (Double.isNaN(angles[0]) && Double.isNaN(angles[1])) {
            return;
        }
        angle = angles[this.getUseAngle()];
        dx = predictedX - this.m_20185_();
        double horizontalDistance = Math.sqrt(dx * dx + (dz = predictedZ - this.m_20189_()) * dz);
        if (horizontalDistance == 0.0) {
            return;
        }
        double horizontalSpeed = (double)speed * Math.cos(angle);
        double verticalSpeed = (double)speed * Math.sin(angle);
        float velocityX = (float)(dx / horizontalDistance * horizontalSpeed);
        float velocityY = (float)verticalSpeed;
        float velocityZ = (float)(dz / horizontalDistance * horizontalSpeed);
        if (this.getUseAngle() == 0) {
            miss = 3.5f;
            arrow.m_36781_(3.0);
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
        arrow.m_6686_((double)velocityX, (double)velocityY, (double)velocityZ, speed, miss);
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)arrow);
        this.m_5810_();
    }

    private boolean isPathClear(AbstractArrow arrow, double angle, float speed, double dx, double dy, double dz, double distance, LivingEntity target) {
        Vec3 startPos = this.m_146892_();
        Vec3 direction = new Vec3(dx / distance, Math.tan(angle), dz / distance).m_82541_();
        Vec3 endPos = startPos.m_82549_(direction.m_82490_(5.0));
        BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)arrow));
        return hitResult.m_6662_() == HitResult.Type.MISS;
    }

    private boolean isTargetExposedToSky(LivingEntity target) {
        BlockPos targetPos = target.m_20183_();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos posToCheck = targetPos.m_7918_(x, 0, z);
                if (!this.m_9236_().m_45527_(posToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }

    public int getUseAngle() {
        return (Integer)this.f_19804_.m_135370_(USE_ANGLE);
    }

    public void setUseAngle(int useAngle) {
        this.f_19804_.m_135381_(USE_ANGLE, (Object)useAngle);
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.75));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public void addTargetSelector() {
        Predicate<LivingEntity> unifiedPredicate = this::isValidTarget;
        this.f_21346_.m_25352_(1, (Goal)new SkyExposedTargetGoal(this, LivingEntity.class, 10, true, false, unifiedPredicate));
    }

    public boolean isShaking() {
        return false;
    }

    @Override
    public Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_SKELETON_ARCHER.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_SKELETON_ARCHER_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_SKELETON_ARCHER_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_SKELETON_ARCHER_3.get();
            default -> null;
        };
    }

    @Override
    protected void setEquipmentFromLevelData(EquipmentLevelData levelData) {
        EquipmentOption meleeWeaponOption;
        EquipmentOption rangedWeaponOption;
        super.setEquipmentFromLevelData(levelData);
        if (levelData.getRangedWeapon() != null && !levelData.getRangedWeapon().isEmpty() && (rangedWeaponOption = this.selectRandomItem(levelData.getRangedWeapon())) != null) {
            ItemStack rangedWeaponStack = this.createItemStack(rangedWeaponOption);
            this.setRangedWeapon(rangedWeaponStack);
        }
        if (levelData.getMeleeWeapon() != null && !levelData.getMeleeWeapon().isEmpty() && (meleeWeaponOption = this.selectRandomItem(levelData.getMeleeWeapon())) != null) {
            ItemStack meleeWeaponStack = this.createItemStack(meleeWeaponOption);
            this.setMeleeWeapon(meleeWeaponStack);
        }
        this.setUsingRanged(true);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        CompoundTag rangedWeaponTag = new CompoundTag();
        this.getRangedWeapon().m_41739_(rangedWeaponTag);
        compound.m_128365_("RangedWeapon", (Tag)rangedWeaponTag);
        CompoundTag meleeWeaponTag = new CompoundTag();
        this.getMeleeWeapon().m_41739_(meleeWeaponTag);
        compound.m_128365_("MeleeWeapon", (Tag)meleeWeaponTag);
        compound.m_128379_("IsUsingRanged", this.isUsingRanged());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("RangedWeapon")) {
            CompoundTag rangedWeaponTag = compound.m_128469_("RangedWeapon");
            ItemStack rangedWeaponStack = ItemStack.m_41712_((CompoundTag)rangedWeaponTag);
            this.setRangedWeapon(rangedWeaponStack);
        }
        if (compound.m_128441_("MeleeWeapon")) {
            CompoundTag meleeWeaponTag = compound.m_128469_("MeleeWeapon");
            ItemStack meleeWeaponStack = ItemStack.m_41712_((CompoundTag)meleeWeaponTag);
            this.setMeleeWeapon(meleeWeaponStack);
        }
        if (compound.m_128441_("IsUsingRanged")) {
            boolean isUsingRanged = compound.m_128471_("IsUsingRanged");
            this.setUsingRanged(isUsingRanged);
            this.m_8061_(EquipmentSlot.MAINHAND, isUsingRanged ? this.getRangedWeapon() : this.getMeleeWeapon());
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Player player;
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_6144_() && ServerRelationHelper.hasControlOver(player, (Entity)this) && ServerModConfig.INSTANCE.isAllowEquipmentChange()) {
            ArmorItem armorItem;
            EquipmentSlot slot;
            ItemStack playerItem = player.m_21120_(InteractionHand.MAIN_HAND);
            Item item = playerItem.m_41720_();
            if (item instanceof ArmorItem && ((slot = (armorItem = (ArmorItem)item).m_40402_()) == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET)) {
                return false;
            }
            if (WeaponTypeHelper.isBowLikeWeapon(playerItem)) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastWeaponReplaceTime < 1000L) {
                    return false;
                }
                ItemStack entityItem = this.getRangedWeapon();
                this.setRangedWeapon(playerItem.m_41777_());
                if (this.isUsingRanged()) {
                    this.m_8061_(EquipmentSlot.MAINHAND, playerItem.m_41777_());
                }
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                if (!entityItem.m_41619_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, entityItem);
                }
                this.lastWeaponReplaceTime = currentTime;
                return false;
            }
            if (WeaponTypeHelper.isSwordLikeWeapon(playerItem) || WeaponTypeHelper.isAxeLikeWeapon(playerItem)) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastWeaponReplaceTime < 1000L) {
                    return false;
                }
                ItemStack entityItem = this.getMeleeWeapon();
                this.setMeleeWeapon(playerItem.m_41777_());
                if (!this.isUsingRanged()) {
                    this.m_8061_(EquipmentSlot.MAINHAND, playerItem.m_41777_());
                }
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                if (!entityItem.m_41619_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, entityItem);
                }
                this.lastWeaponReplaceTime = currentTime;
                return false;
            }
        }
        return super.m_6469_(source, amount);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        super.increaseStatsOnLevelUp();
        AttributeInstance rangedAttackDamage = this.m_21051_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get());
        if (rangedAttackDamage != null) {
            rangedAttackDamage.m_22100_(rangedAttackDamage.m_22115_() + 0.1);
        }
    }

    @Override
    public double getRangedDamageModifier() {
        return 1.5;
    }
}

