/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.Random;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterLight;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterRanged;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterSiege;
import ydmsama.hundred_years_war.main.entity.entities.tags.HeavyUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.entity.utils.Mountable;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class HywWitherSkeletonEntity
extends BaseCombatEntity
implements HeavyUnit,
CounterLight,
CounterRanged,
CounterSiege,
Mountable {
    private static final float ATTACK_REACH = 2.5f;
    private static final float MOVEMENT_SPEED = 0.3f;

    public HywWitherSkeletonEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    protected boolean m_21527_() {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    public static AttributeSupplier.Builder createHywWitherSkeletonAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22278_, 0.8).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 2.5);
    }

    @Override
    protected void setDefaultEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42464_));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42465_));
    }

    public boolean m_7327_(Entity entity) {
        boolean success = super.m_7327_(entity);
        if (success && entity instanceof LivingEntity) {
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100, 0));
        }
        return success;
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 6;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 5;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 10 + random.nextInt(10);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.75));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12561_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12560_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12559_;
    }

    @Override
    public Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_WITHER_SKELETON.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_WITHER_SKELETON_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_WITHER_SKELETON_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_WITHER_SKELETON_3.get();
            default -> null;
        };
    }

    public boolean m_5825_() {
        return true;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public double getLightDamageModifier() {
        return 1.5;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 0.8;
    }

    @Override
    public double getRangedDamageModifier() {
        return 1.5;
    }

    @Override
    public double getSiegeDamageModifier() {
        return 1.5;
    }
}

