/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.entity.utils.Mountable;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class HywZombieEntity
extends BaseCombatEntity
implements Mountable {
    private static final float ATTACK_REACH = 2.0f;
    private static final float MOVEMENT_SPEED = 0.23f;

    public HywZombieEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.getHywTarget() != null && !this.commandHold() && !this.isHolding() && this.getGoalQueue().isEmpty()) {
            this.m_21573_().m_5624_((Entity)this.getHywTarget(), 1.0);
        }
    }

    public static AttributeSupplier.Builder createHywZombieAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22278_, 0.6).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 2.0);
    }

    @Override
    protected void setDefaultEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.FEET, ItemStack.f_41583_);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 15;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 1;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 5 + random.nextInt(8);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, amount *= 0.85f);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.65));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    @Override
    public Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_ZOMBIE.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_ZOMBIE_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_ZOMBIE_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_ZOMBIE_3.get();
            default -> null;
        };
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        AttributeInstance knockbackResistance;
        AttributeInstance attackDamage;
        AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            maxHealth.m_22100_(maxHealth.m_22115_() + 5.0);
            this.m_5634_(5.0f);
        }
        if ((attackDamage = this.m_21051_(Attributes.f_22281_)) != null) {
            attackDamage.m_22100_(attackDamage.m_22115_() + 0.5);
        }
        if ((knockbackResistance = this.m_21051_(Attributes.f_22278_)) != null) {
            knockbackResistance.m_22100_(knockbackResistance.m_22115_() + 0.1);
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12608_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12603_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12598_;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }
}

