/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.mounted;

import java.util.Random;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.entities.UseShield;
import ydmsama.hundred_years_war.main.entity.entities.tags.CavalryUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterHeavy;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterSiege;
import ydmsama.hundred_years_war.main.entity.entities.tags.HeavyUnit;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.entity.utils.Chargeable;
import ydmsama.hundred_years_war.main.entity.utils.HorseRider;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.main.item.BaseScrollItem;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;
import ydmsama.hundred_years_war.main.utils.WeaponTypeHelper;

public class MountedLancerRiderEntity
extends BaseCombatEntity
implements HorseRider,
UseShield,
CavalryUnit,
HeavyUnit,
CounterHeavy,
CounterSiege,
Chargeable {
    private static final float ATTACK_REACH = 3.0f;
    private static final float MOVEMENT_SPEED = 0.33f;
    protected static float BASE_CHARGE_SPEED_MULTIPLIER = 0.25f;
    protected static float BASE_CHARGE_DAMAGE_MULTIPLIER = 3.0f;
    protected static float BASE_CHARGE_KNOCKBACK_STRENGTH = 1.5f;
    protected static float MIN_CHARGE_DISTANCE_SQUARED = 25.0f;
    protected static float MAX_CHARGE_DISTANCE_SQUARED = 900.0f;
    protected static int BASE_CHARGE_COOLDOWN_TICKS = 240;
    protected static int BASE_MAX_CHARGE_DURATION_TICKS = 160;
    protected static int BASE_READY_STANCE_DELAY = 40;
    private final Random shieldBlockRandom = new Random();
    protected int chargeCooldownCounter = 0;
    protected int chargeDurationCounter = 0;
    protected int readyStanceCounter = 0;
    private boolean horseSpawned = false;
    protected AbstractHorse mountedHorse;
    private UUID horseUUID;
    private CompoundTag savedHorseData;
    private boolean needsHorseSpawn = false;
    private static final EntityDataAccessor<Boolean> IS_CHARGING = SynchedEntityData.m_135353_(MountedLancerRiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<ItemStack> DATA_CHARGE_WEAPON = SynchedEntityData.m_135353_(MountedLancerRiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<ItemStack> DATA_MAIN_WEAPON = SynchedEntityData.m_135353_(MountedLancerRiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Boolean> DATA_IS_USING_CHARGE_WEAPON = SynchedEntityData.m_135353_(MountedLancerRiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public MountedLancerRiderEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CHARGE_WEAPON, (Object)this.getDefaultChargeWeapon());
        this.f_19804_.m_135372_(DATA_MAIN_WEAPON, (Object)this.getDefaultMainWeapon());
        this.f_19804_.m_135372_(DATA_IS_USING_CHARGE_WEAPON, (Object)false);
        this.f_19804_.m_135372_(IS_CHARGING, (Object)false);
    }

    protected ItemStack getDefaultChargeWeapon() {
        return new ItemStack((ItemLike)HywItemRegistry.WOODEN_LANCE.get());
    }

    protected ItemStack getDefaultMainWeapon() {
        return new ItemStack((ItemLike)Items.f_42383_);
    }

    public ItemStack getChargeWeapon() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_CHARGE_WEAPON);
    }

    public void setChargeWeapon(ItemStack stack) {
        this.f_19804_.m_135381_(DATA_CHARGE_WEAPON, (Object)stack);
    }

    public ItemStack getMainWeapon() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_MAIN_WEAPON);
    }

    public void setMainWeapon(ItemStack stack) {
        this.f_19804_.m_135381_(DATA_MAIN_WEAPON, (Object)stack);
    }

    public boolean isUsingChargeWeapon() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_USING_CHARGE_WEAPON);
    }

    public void setUsingChargeWeapon(boolean usingChargeWeapon) {
        this.f_19804_.m_135381_(DATA_IS_USING_CHARGE_WEAPON, (Object)usingChargeWeapon);
        this.m_8061_(EquipmentSlot.MAINHAND, usingChargeWeapon ? this.getChargeWeapon() : this.getMainWeapon());
    }

    @Override
    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(IS_CHARGING, (Object)charging);
    }

    @Override
    protected void setDefaultEquipment() {
        this.setMainWeapon(this.getDefaultMainWeapon());
        this.setChargeWeapon(this.getDefaultChargeWeapon());
        this.setUsingChargeWeapon(false);
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42468_));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42470_));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        CompoundTag chargeWeaponTag = new CompoundTag();
        this.getChargeWeapon().m_41739_(chargeWeaponTag);
        compound.m_128365_("ChargeWeapon", (Tag)chargeWeaponTag);
        CompoundTag mainWeaponTag = new CompoundTag();
        this.getMainWeapon().m_41739_(mainWeaponTag);
        compound.m_128365_("MainWeapon", (Tag)mainWeaponTag);
        compound.m_128379_("HorseSpawned", this.horseSpawned);
        if (this.horseUUID != null) {
            compound.m_128362_("HorseUUID", this.horseUUID);
        }
        if (this.savedHorseData != null) {
            compound.m_128365_("SavedHorseData", (Tag)this.savedHorseData);
        }
        compound.m_128379_("IsCharging", this.isCharging());
        compound.m_128405_("ChargeCooldown", this.chargeCooldownCounter);
        compound.m_128405_("ChargeDuration", this.chargeDurationCounter);
        compound.m_128405_("ReadyStance", this.readyStanceCounter);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("ChargeWeapon")) {
            CompoundTag chargeWeaponTag = compound.m_128469_("ChargeWeapon");
            ItemStack chargeWeaponStack = ItemStack.m_41712_((CompoundTag)chargeWeaponTag);
            this.setChargeWeapon(chargeWeaponStack);
        }
        if (compound.m_128441_("MainWeapon")) {
            CompoundTag mainWeaponTag = compound.m_128469_("MainWeapon");
            ItemStack mainWeaponStack = ItemStack.m_41712_((CompoundTag)mainWeaponTag);
            this.setMainWeapon(mainWeaponStack);
        }
        this.horseSpawned = compound.m_128471_("HorseSpawned");
        if (compound.m_128403_("HorseUUID")) {
            this.horseUUID = compound.m_128342_("HorseUUID");
        }
        if (compound.m_128441_("SavedHorseData")) {
            this.savedHorseData = compound.m_128469_("SavedHorseData");
            this.needsHorseSpawn = true;
            this.horseSpawned = false;
        }
        this.setCharging(compound.m_128471_("IsCharging"));
        this.chargeCooldownCounter = compound.m_128451_("ChargeCooldown");
        this.chargeDurationCounter = compound.m_128451_("ChargeDuration");
        this.readyStanceCounter = compound.m_128451_("ReadyStance");
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.needsHorseSpawn && this.m_6084_()) {
            this.spawnHorse();
            this.needsHorseSpawn = false;
        } else if (!this.m_9236_().f_46443_ && !this.horseSpawned && this.m_6084_() && !this.m_20159_()) {
            this.spawnHorse();
        }
        if (!this.m_9236_().f_46443_ && this.horseSpawned && this.mountedHorse == null && this.horseUUID != null) {
            for (Entity entity : this.m_9236_().m_45976_(AbstractHorse.class, this.m_20191_().m_82400_(10.0))) {
                if (!entity.m_20148_().equals(this.horseUUID)) continue;
                this.mountedHorse = (AbstractHorse)entity;
                if (this.m_20159_()) break;
                this.m_7998_((Entity)this.mountedHorse, true);
                break;
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.handleChargeLogic();
            this.manageHorseChargeSpeed();
        }
    }

    private void spawnHorse() {
        this.mountedHorse = this.createHorseEntity();
        if (this.mountedHorse != null) {
            BaseCombatSupport support;
            this.mountedHorse.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            AbstractHorse abstractHorse = this.mountedHorse;
            if (abstractHorse instanceof BaseCombatSupport) {
                support = (BaseCombatSupport)abstractHorse;
                support.m_30586_(this.m_21805_());
            }
            if ((abstractHorse = this.mountedHorse) instanceof HywHorseEntity) {
                HywHorseEntity hywHorse = (HywHorseEntity)abstractHorse;
                hywHorse.setRiderEntity(this);
                hywHorse.setNpcHorse(true);
            }
            if (this.savedHorseData != null) {
                try {
                    this.mountedHorse.m_7378_(this.savedHorseData);
                    this.savedHorseData = null;
                }
                catch (Exception e) {
                    System.err.println("Failed to restore horse data: " + e.getMessage());
                }
            } else {
                abstractHorse = this.mountedHorse;
                if (abstractHorse instanceof BaseCombatSupport) {
                    support = (BaseCombatSupport)abstractHorse;
                    support.setEquipment(this.getEquipmentLevel());
                }
            }
            this.m_9236_().m_7967_((Entity)this.mountedHorse);
            this.m_7998_((Entity)this.mountedHorse, true);
            this.horseSpawned = true;
            this.horseUUID = this.mountedHorse.m_20148_();
        }
    }

    protected HywHorseEntity createHorseEntity() {
        return (HywHorseEntity)((EntityType)HywEntityRegistry.HORSE.get()).m_20615_(this.m_9236_());
    }

    private void handleChargeLogic() {
        if (this.chargeCooldownCounter > 0) {
            --this.chargeCooldownCounter;
        } else if (this.getHywTarget() == null) {
            ++this.readyStanceCounter;
            if (this.readyStanceCounter > this.getReadyStanceDelay() && !this.isUsingChargeWeapon() && this.getHywTarget() == null) {
                this.setUsingChargeWeapon(true);
            }
        } else {
            this.readyStanceCounter = 0;
        }
        if (this.getHywTarget() != null) {
            double distanceToTarget = this.m_20280_((Entity)this.getHywTarget());
            if (!this.isCharging() && distanceToTarget < (double)this.getMinChargeDistanceSquared()) {
                this.setUsingChargeWeapon(false);
            }
            if (this.canCharge() && !this.isCharging() && this.isFacingTarget(this.getHywTarget(), 10.0f)) {
                this.startCharge();
            }
        }
        if (this.isCharging()) {
            ++this.chargeDurationCounter;
            this.applyChargeImpulse();
            if (this.chargeDurationCounter >= this.getMaxChargeDurationTicks()) {
                this.endCharge(false);
            } else if (this.getHywTarget() != null && this.m_20280_((Entity)this.getHywTarget()) <= (double)(this.getChargeAttackReach() * this.getChargeAttackReach())) {
                this.performChargeAttack();
                this.endCharge(true);
            }
        }
    }

    protected float getMinChargeDistanceSquared() {
        return MIN_CHARGE_DISTANCE_SQUARED;
    }

    protected float getMaxChargeDistanceSquared() {
        return MAX_CHARGE_DISTANCE_SQUARED;
    }

    protected int getChargeCooldownTicks() {
        return BASE_CHARGE_COOLDOWN_TICKS;
    }

    protected int getMaxChargeDurationTicks() {
        return BASE_MAX_CHARGE_DURATION_TICKS;
    }

    protected float getChargeSpeedMultiplier() {
        return BASE_CHARGE_SPEED_MULTIPLIER;
    }

    protected float getChargeDamageMultiplier() {
        return 6.0f;
    }

    protected float getChargeKnockbackStrength() {
        return BASE_CHARGE_KNOCKBACK_STRENGTH;
    }

    protected int getReadyStanceDelay() {
        return BASE_READY_STANCE_DELAY;
    }

    public float getChargeAttackReach() {
        AttributeInstance attackReachAttr = this.m_21051_((Attribute)HywAttributes.ATTACK_REACH.get());
        float baseReach = attackReachAttr != null ? (float)attackReachAttr.m_22135_() : 3.0f;
        return baseReach + 0.5f;
    }

    protected boolean canCharge() {
        if (this.chargeCooldownCounter > 0 || this.getHywTarget() == null || !this.isUsingChargeWeapon() || this.shouldMoveOnly()) {
            return false;
        }
        if (this.m_20202_() == null || !(this.m_20202_() instanceof AbstractHorse)) {
            return false;
        }
        if (this.isHolding()) {
            return false;
        }
        double distance = this.m_20280_((Entity)this.getHywTarget());
        return distance >= (double)this.getMinChargeDistanceSquared() && distance <= (double)this.getMaxChargeDistanceSquared();
    }

    protected boolean isFacingTarget(LivingEntity target, float maxAngle) {
        float yaw = this.m_20202_() != null ? this.m_20202_().m_146908_() : this.m_146908_();
        Vec3 forward = new Vec3((double)(-Mth.m_14031_((float)(yaw * (float)Math.PI / 180.0f))), 0.0, (double)Mth.m_14089_((float)(yaw * (float)Math.PI / 180.0f))).m_82541_();
        Vec3 toTarget = new Vec3(target.m_20185_() - this.m_20185_(), 0.0, target.m_20189_() - this.m_20189_()).m_82541_();
        double dot = forward.m_82526_(toTarget);
        double angle = Math.acos(dot) * 57.29577951308232;
        return angle <= (double)maxAngle;
    }

    protected void startCharge() {
        this.setCharging(true);
        this.chargeDurationCounter = 0;
    }

    protected void performChargeAttack() {
        LivingEntity target = this.getHywTarget();
        if (target != null) {
            float weaponDamage = this.getMainHandWeaponDamage();
            float chargeDamage = weaponDamage * this.getChargeDamageMultiplier() + this.getChargeDamageBonus();
            target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), chargeDamage);
            target.m_147240_((double)this.getChargeKnockbackStrength(), this.m_20185_() - target.m_20185_(), this.m_20189_() - target.m_20189_());
        }
    }

    private float getMainHandWeaponDamage() {
        ItemStack mainHandItem = this.m_21120_(InteractionHand.MAIN_HAND);
        Item item = mainHandItem.m_41720_();
        if (item instanceof SwordItem) {
            SwordItem swordItem = (SwordItem)item;
            return swordItem.m_43299_();
        }
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    private float getChargeDamageBonus() {
        return (float)(this.getEquipmentLevel() - 1) * 0.5f;
    }

    protected void endCharge(boolean attacked) {
        this.setCharging(false);
        this.chargeCooldownCounter = this.getChargeCooldownTicks();
        this.chargeDurationCounter = 0;
        this.setUsingChargeWeapon(false);
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 12;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 5;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 3 + random.nextInt(8);
    }

    protected void m_6731_(LivingEntity livingEntity) {
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        super.m_8099_();
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        AttributeInstance attackDamage;
        super.increaseStatsOnLevelUp();
        AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            maxHealth.m_22100_(maxHealth.m_22115_() + 2.0);
            this.m_5634_(2.0f);
        }
        if ((attackDamage = this.m_21051_(Attributes.f_22281_)) != null) {
            attackDamage.m_22100_(attackDamage.m_22115_() + 0.2);
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Player player;
        Entity entity;
        Entity entity2;
        if (this.mountedHorse != null && this.mountedHorse.m_6084_()) {
            this.mountedHorse.m_6469_(source, 0.0f);
        }
        if (this.m_6844_(EquipmentSlot.OFFHAND).m_41720_() instanceof ShieldItem && this.m_6117_() && this.shieldBlockRandom.nextInt(100) < 50) {
            amount *= 0.2f;
            this.m_5496_(SoundEvents.f_12346_, this.m_6121_(), this.m_6100_());
        }
        if ((entity2 = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            this.m_6728_(livingEntity);
        }
        if ((entity = source.m_7639_()) instanceof Player && (player = (Player)entity).m_6144_() && (ServerRelationHelper.hasControlOver(player, (Entity)this) || CreativeModeSettings.canControlAllUnits(player)) && ServerModConfig.INSTANCE.isAllowEquipmentChange()) {
            ItemStack playerItem = player.m_21120_(InteractionHand.MAIN_HAND);
            if (WeaponTypeHelper.isLanceLikeWeapon(playerItem)) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastWeaponReplaceTime < 1000L) {
                    return false;
                }
                ItemStack entityItem = this.getChargeWeapon();
                this.setChargeWeapon(playerItem.m_41777_());
                if (this.isUsingChargeWeapon()) {
                    this.m_8061_(EquipmentSlot.MAINHAND, playerItem.m_41777_());
                }
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                if (!entityItem.m_41619_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, entityItem);
                }
                this.lastWeaponReplaceTime = currentTime;
                return false;
            }
            if (WeaponTypeHelper.isSwordLikeWeapon(playerItem)) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastWeaponReplaceTime < 1000L) {
                    return false;
                }
                ItemStack entityItem = this.getMainWeapon();
                this.setMainWeapon(playerItem.m_41777_());
                if (!this.isUsingChargeWeapon()) {
                    this.m_8061_(EquipmentSlot.MAINHAND, playerItem.m_41777_());
                }
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                if (!entityItem.m_41619_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, entityItem);
                }
                this.lastWeaponReplaceTime = currentTime;
                return false;
            }
        }
        return super.m_6469_(source, amount);
    }

    protected boolean isChargeWeaponItem(ItemStack stack) {
        return WeaponTypeHelper.isLanceLikeWeapon(stack);
    }

    public static AttributeSupplier.Builder createMountedLancerRiderAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, (double)0.33f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22276_, 34.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 3.0);
    }

    @Override
    protected void setEquipmentFromLevelData(EquipmentLevelData levelData) {
        super.setEquipmentFromLevelData(levelData);
        this.loadWeaponsFromLevelData(levelData);
    }

    protected void loadWeaponsFromLevelData(EquipmentLevelData levelData) {
        EquipmentOption chargeWeaponOption = this.selectRandomItem(levelData.getLanceWeapon());
        ItemStack chargeWeaponStack = this.createItemStack(chargeWeaponOption);
        this.setChargeWeapon(chargeWeaponStack);
        EquipmentOption mainWeaponOption = this.selectRandomItem(levelData.getMainWeapon());
        ItemStack mainWeaponStack = this.createItemStack(mainWeaponOption);
        this.setMainWeapon(mainWeaponStack);
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_6144_() && hand == InteractionHand.MAIN_HAND) {
            if ((ServerModConfig.INSTANCE.isAllowSoldierRecall() || player.m_7500_() && CreativeModeSettings.canControlAllUnits(player)) && this.getScrollType() != null) {
                return this.handleScrollConversion(player);
            }
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    private InteractionResult handleScrollConversion(Player player) {
        ItemStack stack = new ItemStack((ItemLike)this.getScrollType());
        CompoundTag entityData = new CompoundTag();
        if (this.mountedHorse != null && this.mountedHorse.m_6084_()) {
            CompoundTag horseData = new CompoundTag();
            this.m_8127_();
            AbstractHorse abstractHorse = this.mountedHorse;
            if (abstractHorse instanceof HywHorseEntity) {
                HywHorseEntity hywHorse = (HywHorseEntity)abstractHorse;
                hywHorse.setRiderEntity(null);
            }
            this.mountedHorse.m_20240_(horseData);
            entityData.m_128365_("SavedHorseData", (Tag)horseData);
            this.mountedHorse.m_146870_();
            this.mountedHorse = null;
        }
        this.m_20240_(entityData);
        ((BaseScrollItem)stack.m_41720_()).saveEntityDataToItem(stack, entityData);
        if (!player.m_150109_().m_36054_(stack)) {
            player.m_36176_(stack, false);
        }
        this.spawnDespawnParticles();
        this.m_146870_();
        return InteractionResult.SUCCESS;
    }

    private void spawnDespawnParticles() {
        int particleCount = 40;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 1.0;
                double offsetY = this.m_9236_().f_46441_.m_188500_() * 0.5 + 0.5;
                double offsetZ = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 1.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    protected void applyChargeImpulse() {
        double deltaZ;
        double deltaX;
        double distance;
        Entity entity;
        if (this.m_20202_() == null || !((entity = this.m_20202_()) instanceof AbstractHorse)) {
            return;
        }
        AbstractHorse horse = (AbstractHorse)entity;
        if (!horse.m_20096_()) {
            return;
        }
        LivingEntity target = this.getHywTarget();
        if (target != null && (distance = Math.sqrt((deltaX = target.m_20185_() - horse.m_20185_()) * deltaX + (deltaZ = target.m_20189_() - horse.m_20189_()) * deltaZ)) > 0.0) {
            deltaX = deltaX / distance * (double)this.getChargeSpeedMultiplier();
            deltaZ = deltaZ / distance * (double)this.getChargeSpeedMultiplier();
            horse.m_5997_(deltaX, 0.0, deltaZ);
        }
    }

    @Override
    public double getLightDamageModifier() {
        return 1.0;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 1.5;
    }

    @Override
    public double getSiegeDamageModifier() {
        return 1.2;
    }

    @Override
    public LivingEntity asLivingEntity() {
        return this;
    }

    @Override
    public boolean hasValidTarget() {
        return this.getHywTarget() != null;
    }

    @Override
    public double getHorseSpeed() {
        return 0.38;
    }

    @Override
    public Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_MOUNTED_LANCER.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_MOUNTED_LANCER_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_MOUNTED_LANCER_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_MOUNTED_LANCER_3.get();
            default -> null;
        };
    }

    @Override
    public void m_6667_(DamageSource damageSource) {
        if (this.mountedHorse != null && this.mountedHorse.m_6084_()) {
            this.mountedHorse.m_6074_();
        }
        super.m_6667_(damageSource);
    }

    @Override
    public float getRotationLimit() {
        return 30.0f;
    }

    @Override
    public double getArrivalThreshold() {
        return 2.0;
    }
}

