/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.projectile;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.projectile.BlockBreakable;
import ydmsama.hundred_years_war.main.utils.BlockBreakHandler;
import ydmsama.hundred_years_war.main.utils.ProjectileHitUtils;

public class TrebuchetsBulletEntity
extends AbstractArrow
implements BlockBreakable {
    private boolean canBreakBlocks = false;
    private float breakRadius = 3.0f;
    private float maxBreakableHardness = 30.0f;
    private int maxBreakableBlocks = 15;
    private float baseBreakProbability = 1.0f;

    public TrebuchetsBulletEntity(EntityType<? extends TrebuchetsBulletEntity> entityType, LivingEntity livingEntity, Level level) {
        super(entityType, livingEntity, level);
    }

    public TrebuchetsBulletEntity(EntityType<TrebuchetsBulletEntity> TrebuchetsBulletEntityEntityType, Level level) {
        super(TrebuchetsBulletEntityEntityType, level);
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            Vec3 hitPos = ProjectileHitUtils.getPreciseHitLocation(hitResult, (Projectile)this);
            this.m_9236_().m_255391_((Entity)this, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 1.0f, false, Level.ExplosionInteraction.NONE);
            this.applyAreaDamage(hitPos);
            if (this.canBreakBlocks) {
                BlockBreakHandler.getInstance().handleBlockBreaking((Projectile)this, this.m_9236_(), hitPos);
            }
            if (this.m_9236_() instanceof ServerLevel) {
                this.sendParticlesToAllNearby((ServerLevel)this.m_9236_(), ParticleTypes.f_123812_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.1);
            }
            this.m_146870_();
        }
    }

    private void applyAreaDamage(Vec3 hitPos) {
        double damageRadius = 10.0;
        float damageAmount = (float)this.m_36789_() * 0.2f;
        AABB damageArea = new AABB(hitPos.f_82479_ - damageRadius, hitPos.f_82480_ - damageRadius, hitPos.f_82481_ - damageRadius, hitPos.f_82479_ + damageRadius, hitPos.f_82480_ + damageRadius, hitPos.f_82481_ + damageRadius);
        Holder.Reference explosionDamageType = this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268565_);
        DamageSource damageSource = new DamageSource((Holder)explosionDamageType, this.m_19749_(), (Entity)this);
        for (Entity entity : this.m_9236_().m_45933_((Entity)this, damageArea)) {
            BaseCombatEntity combatEntity;
            Entity entity2;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == this.m_19749_() || !((entity2 = this.m_19749_()) instanceof BaseCombatEntity) || !(combatEntity = (BaseCombatEntity)entity2).isValidTarget(livingEntity)) continue;
            entity.m_6469_(damageSource, damageAmount);
        }
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    protected ItemStack m_7941_() {
        return null;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_11667_;
    }

    public <T extends ParticleOptions> int sendParticlesToAllNearby(ServerLevel serverLevel, T particleOptions, double x, double y, double z, int count, double xOffset, double yOffset, double zOffset, double speed) {
        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(particleOptions, true, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, count);
        int sentCount = 0;
        for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
            if (!this.sendParticlesToPlayer(serverLevel, serverPlayer, x, y, z, (Packet<?>)packet)) continue;
            ++sentCount;
        }
        return sentCount;
    }

    private boolean sendParticlesToPlayer(ServerLevel serverLevel, ServerPlayer serverPlayer, double x, double y, double z, Packet<?> packet) {
        if (serverPlayer.m_9236_() != serverLevel) {
            return false;
        }
        double distanceSquared = serverPlayer.m_20182_().m_82557_(new Vec3(x, y, z));
        if (distanceSquared < 262144.0) {
            serverPlayer.f_8906_.m_9829_(packet);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBreakBlocks() {
        return this.canBreakBlocks;
    }

    @Override
    public void setCanBreakBlocks(boolean canBreak) {
        this.canBreakBlocks = canBreak;
    }

    @Override
    public float getBreakRadius() {
        return this.breakRadius;
    }

    @Override
    public float getMaxBreakableHardness() {
        return this.maxBreakableHardness;
    }

    @Override
    public int getMaxBreakableBlocks() {
        return this.maxBreakableBlocks;
    }

    @Override
    public float getBaseBreakProbability() {
        return this.baseBreakProbability;
    }
}

