/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.puppets;

import java.util.UUID;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.entity.entities.CrossbowmanEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.entity.utils.HorseRider;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.utils.PuppetUtils;

public class CrossbowPuppetEntity
extends CrossbowmanEntity
implements IPuppet,
HorseRider {
    private static final float ATTACK_REACH = 80.0f;
    private static final float MOVEMENT_SPEED = 0.3f;

    public CrossbowPuppetEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.checkOwnerFreecamStatus();
            this.syncHealthWithPassenger();
        } else {
            this.syncPlayerHeadRotation();
        }
    }

    @Override
    public void syncHealthWithPassenger() {
        PuppetUtils.syncHealthWithPassenger(this);
    }

    @Override
    public void checkOwnerFreecamStatus() {
        PuppetUtils.checkOwnerFreecamStatus(this);
    }

    public void syncPlayerHeadRotation() {
        PuppetUtils.syncPuppetHeadRotationToPlayer(this);
    }

    @Override
    public void removePuppetSafely() {
        PuppetUtils.removePuppetSafely(this);
    }

    @Override
    public Entity m_146895_() {
        return super.m_146895_();
    }

    public static AttributeSupplier.Builder createCrossbowPuppetAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 80.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22278_, 0.4).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 80.0).m_22268_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get(), 3.0);
    }

    public double m_6048_() {
        return PuppetUtils.getPassengersRidingOffset();
    }

    @NotNull
    public Vec3 m_7688_(LivingEntity passenger) {
        return PuppetUtils.getDismountLocationForPassenger(this, passenger);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return PuppetUtils.handleHurt(this, source, amount);
    }

    @Override
    public UUID m_21805_() {
        return super.m_21805_();
    }

    @Override
    public void m_30586_(UUID ownerUUID) {
        super.m_30586_(ownerUUID);
    }

    @Override
    public LivingEntity asLivingEntity() {
        return this;
    }

    @Override
    public boolean hasValidTarget() {
        return this.getHywTarget() != null;
    }

    @Override
    public double getHorseSpeed() {
        return 0.38;
    }
}

