/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.siege;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.action.Action;
import ydmsama.hundred_years_war.main.entity.action.PositionAttackAction;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.projectile.RocketEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.main.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.main.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.main.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.main.entity.goals.SkyExposedTargetGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.RocketTrajectoryCalculator;

public class NestOfBeesEntity
extends BaseCombatEntity
implements RangedAttackMob,
SiegeUnit,
PositionAttackable {
    private static final float ATTACK_REACH = 100.0f;
    private static final float MOVEMENT_SPEED = 0.15f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 25.0f;
    private static final EntityDataAccessor<BlockPos> TARGET_POS = SynchedEntityData.m_135353_(NestOfBeesEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> HAS_POSITION_TARGET = SynchedEntityData.m_135353_(NestOfBeesEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int ROCKET_COUNT = 36;
    private static final int FIRE_DELAY_TICKS = 5;
    private static final float TUBE_LATERAL_SPACING = 0.18f;
    private static final float TUBE_VERTICAL_SPACING = -0.05f;
    private static final float TUBE_HEIGHT_SPACING = 0.15f;
    private static final float MATRIX_FORWARD_OFFSET = 1.2f;
    private static final float MATRIX_HEIGHT_OFFSET = 1.8f;
    private static final float PREDICTION_INTENSITY = 3.0f;
    private int currentRocketIndex = 0;
    private int fireDelay = 0;
    private boolean inFiringSequence = false;
    private LivingEntity currentTarget = null;
    private Vec3 lastTargetPos = null;
    private int attackCooldown = 0;
    private Vec3 positionTarget;
    private PositionAttackAction positionAttackAction;
    private static final RocketTubePosition[] ROCKET_POSITIONS = NestOfBeesEntity.createRocketPositions();

    public NestOfBeesEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.f_19804_.m_135372_(TARGET_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(HAS_POSITION_TARGET, (Object)false);
        this.positionAttackAction = new PositionAttackAction();
        this.positionTarget = null;
    }

    public static AttributeSupplier.Builder createNestOfBeesAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 100.0).m_22268_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get(), 25.0);
    }

    @Override
    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>(super.getActions());
        actions.add(this.positionAttackAction);
        return actions;
    }

    private static RocketTubePosition[] createRocketPositions() {
        RocketTubePosition[] positions = new RocketTubePosition[36];
        int index = 0;
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 6; ++col) {
                float lateralOffset = row <= 3 ? ((float)col - 2.5f) * 0.18f * 1.8f : ((float)col - 2.5f) * 0.18f;
                float longitudinalOffset = ((float)row - 2.5f) * -0.05f;
                float verticalOffset = row <= 3 ? ((float)row - 2.5f) * 0.15f * 0.8f : ((float)row - 2.5f) * 0.15f * 1.5f;
                positions[index] = new RocketTubePosition(lateralOffset, longitudinalOffset, verticalOffset);
                ++index;
            }
        }
        return positions;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.attackCooldown > 0) {
                --this.attackCooldown;
            }
            if (this.hasPositionTarget() && this.getPositionTarget() != null) {
                BlockPos targetBlockPos = new BlockPos((int)this.getPositionTarget().f_82479_, (int)this.getPositionTarget().f_82480_, (int)this.getPositionTarget().f_82481_);
                this.setTargetPosition(targetBlockPos);
            } else if (this.getHywTarget() != null) {
                this.setTargetPosition(this.getHywTarget().m_20183_());
            } else {
                this.setTargetPosition(BlockPos.f_121853_);
            }
            if (this.inFiringSequence && this.fireDelay > 0) {
                --this.fireDelay;
                if (this.fireDelay == 0 && this.currentRocketIndex < 36) {
                    this.fireSingleRocket(this.currentRocketIndex);
                    ++this.currentRocketIndex;
                    if (this.currentRocketIndex < 36) {
                        this.fireDelay = 5;
                    } else {
                        this.finishFiringSequence();
                    }
                }
            }
        }
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        this.PerformRangedAttackBoth(null, target);
    }

    @Override
    public void performPositionAttack(Vec3 targetPosition, float pullProgress) {
        this.PerformRangedAttackBoth(targetPosition, null);
    }

    @Override
    public void PerformRangedAttackBoth(Vec3 targetPosition, LivingEntity target) {
        if (this.attackCooldown > 0 || this.inFiringSequence) {
            return;
        }
        if (target != null && !this.canFireAtTarget(target)) {
            return;
        }
        if (targetPosition != null && !this.canFireAtPosition(targetPosition)) {
            return;
        }
        if (target != null) {
            this.startFiringSequence(target);
        } else if (targetPosition != null) {
            this.startFiringSequenceAtPosition(targetPosition);
        }
    }

    private void startFiringSequence(LivingEntity target) {
        this.currentTarget = target;
        this.lastTargetPos = target.m_20182_();
        this.currentRocketIndex = 0;
        this.inFiringSequence = true;
        this.fireSingleRocket(this.currentRocketIndex);
        ++this.currentRocketIndex;
        this.fireDelay = 5;
        this.m_5496_(SoundEvents.f_11932_, 3.5f, 0.8f);
    }

    private void startFiringSequenceAtPosition(Vec3 targetPosition) {
        this.currentTarget = null;
        this.lastTargetPos = targetPosition;
        this.currentRocketIndex = 0;
        this.inFiringSequence = true;
        this.fireSingleRocket(this.currentRocketIndex);
        ++this.currentRocketIndex;
        this.fireDelay = 5;
        this.m_5496_(SoundEvents.f_11932_, 3.5f, 0.8f);
    }

    private void fireSingleRocket(int rocketIndex) {
        RocketTubePosition tubePos = ROCKET_POSITIONS[rocketIndex];
        Vec3 launchPosition = this.calculateLaunchPosition(tubePos);
        RocketEntity rocket = new RocketEntity((EntityType<? extends RocketEntity>)((EntityType)HywEntityRegistry.ROCKET.get()), (LivingEntity)this, this.m_9236_());
        rocket.m_6034_(launchPosition.f_82479_, launchPosition.f_82480_, launchPosition.f_82481_);
        Vec3 targetPosition = this.determineTargetPosition();
        RocketTrajectoryCalculator.TrajectoryResult trajectoryResult = RocketTrajectoryCalculator.calculateForRocketLauncher(launchPosition, targetPosition, true);
        if (trajectoryResult.success) {
            launchVector = trajectoryResult.launchVector;
            rocket.setRocketParamsFromCalculator((float)launchVector.f_82479_, (float)launchVector.f_82480_, (float)launchVector.f_82481_, trajectoryResult.velocity);
        } else {
            launchVector = this.calculateFallbackLaunchVector(launchPosition, targetPosition);
            rocket.setRocketParams((float)launchVector.f_82479_, (float)launchVector.f_82480_, (float)launchVector.f_82481_);
        }
        rocket.m_36781_(this.m_21133_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get()));
        this.m_9236_().m_7967_((Entity)rocket);
        float randomPitch = 1.0f + (float)NestOfBeesEntity.getRandomInRange(-0.2, 0.2);
        this.m_5496_(SoundEvents.f_11932_, 2.5f, randomPitch);
    }

    private Vec3 calculateLaunchPosition(RocketTubePosition tubePos) {
        float yBodyRot = this.getTrueYBodyRot() + 90.0f;
        float yBodyRotRad = (float)Math.toRadians(yBodyRot);
        double forwardX = Math.cos(yBodyRotRad);
        double forwardZ = Math.sin(yBodyRotRad);
        double rightX = Math.cos((double)yBodyRotRad + 1.5707963267948966);
        double rightZ = Math.sin((double)yBodyRotRad + 1.5707963267948966);
        double totalForwardOffset = 1.2f + tubePos.longitudinalOffset;
        double offsetX = forwardX * totalForwardOffset + rightX * (double)tubePos.lateralOffset;
        double offsetZ = forwardZ * totalForwardOffset + rightZ * (double)tubePos.lateralOffset;
        double offsetY = 1.8f + tubePos.verticalOffset;
        return new Vec3(this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ);
    }

    private Vec3 determineTargetPosition() {
        Vec3 defaultPos;
        if (this.hasPositionTarget() && this.getPositionTarget() != null) {
            Vec3 posTarget;
            this.lastTargetPos = posTarget = this.getPositionTarget();
            return posTarget;
        }
        LivingEntity dynamicTarget = this.getHywTarget();
        if (dynamicTarget != null && dynamicTarget.m_6084_()) {
            Vec3 predictedPos;
            this.lastTargetPos = predictedPos = this.calculateTargetPrediction(dynamicTarget);
            return predictedPos;
        }
        if (this.lastTargetPos != null) {
            return this.lastTargetPos;
        }
        float yaw = this.getTrueYBodyRot() + 90.0f;
        float yawRad = (float)Math.toRadians(yaw);
        this.lastTargetPos = defaultPos = new Vec3(this.m_20185_() + Math.cos(yawRad) * 50.0, this.m_20186_() + 2.0, this.m_20189_() + Math.sin(yawRad) * 50.0);
        return defaultPos;
    }

    private Vec3 calculateTargetPrediction(LivingEntity target) {
        Vec3 baseTargetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
        Vec3 sampleLaunchPos = this.calculateLaunchPosition(ROCKET_POSITIONS[0]);
        double dx = baseTargetPos.f_82479_ - sampleLaunchPos.f_82479_;
        double dy = baseTargetPos.f_82480_ - sampleLaunchPos.f_82480_;
        double dz = baseTargetPos.f_82481_ - sampleLaunchPos.f_82481_;
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        if (horizontalDistance == 0.0) {
            return baseTargetPos;
        }
        double timeToTarget = this.calculateRocketFlightTime(sampleLaunchPos, baseTargetPos);
        double targetVelocityX = target.m_20184_().m_7096_();
        double targetVelocityZ = target.m_20184_().m_7094_();
        double targetSpeedPerSecond = Math.sqrt(targetVelocityX * targetVelocityX + targetVelocityZ * targetVelocityZ) * 20.0;
        double predictedX = target.m_20185_() + targetVelocityX * 20.0 * timeToTarget * 3.0;
        double predictedZ = target.m_20189_() + targetVelocityZ * 20.0 * timeToTarget * 3.0;
        double baseSpread = 2.0;
        double distanceSpread = horizontalDistance * 0.02;
        double speedSpread = targetSpeedPerSecond * 0.5;
        double totalSpread = baseSpread + distanceSpread + speedSpread;
        double randomTargetOffsetX = NestOfBeesEntity.getRandomInRange(-totalSpread, totalSpread);
        double randomTargetOffsetZ = NestOfBeesEntity.getRandomInRange(-totalSpread, totalSpread);
        double randomTargetOffsetY = NestOfBeesEntity.getRandomInRange(-1.0, 1.0);
        Vec3 finalPredictedPos = new Vec3(predictedX + randomTargetOffsetX, baseTargetPos.f_82480_ + randomTargetOffsetY, predictedZ + randomTargetOffsetZ);
        return finalPredictedPos;
    }

    private double calculateRocketFlightTime(Vec3 launchPos, Vec3 targetPos) {
        RocketTrajectoryCalculator.TrajectoryResult result = RocketTrajectoryCalculator.calculateForRocketLauncher(launchPos, targetPos, false);
        if (!result.success) {
            double distance = launchPos.m_82554_(targetPos);
            return Math.max(1.0, distance * 0.15);
        }
        Vec3 launchVector = result.launchVector;
        float velocity = result.velocity;
        float motionX = (float)launchVector.f_82479_ * 0.05f;
        float motionY = (float)launchVector.f_82480_ * 0.05f;
        float motionZ = (float)launchVector.f_82481_ * 0.05f;
        float motionMagnitude = Mth.m_14116_((float)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        float BURN_TIME_FACTOR = 3.0f;
        int rocketBurnTime = (int)(motionMagnitude * 20.0f * 3.0f);
        double burnTimeSeconds = (double)rocketBurnTime / 20.0;
        double dx = targetPos.f_82479_ - launchPos.f_82479_;
        double dy = targetPos.f_82480_ - launchPos.f_82480_;
        double dz = targetPos.f_82481_ - launchPos.f_82481_;
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        float ACCELERATION_FACTOR = 0.01f;
        double finalBurnVelocity = motionMagnitude + 0.01f * (float)rocketBurnTime;
        double burnPhaseDistance = (double)(motionMagnitude * (float)rocketBurnTime) + (double)0.005f * (double)rocketBurnTime * (double)rocketBurnTime;
        double remainingDistance = Math.max(0.0, horizontalDistance - burnPhaseDistance);
        double gravityPhaseTime = remainingDistance / Math.max(0.1, finalBurnVelocity * 20.0);
        double totalFlightTime = burnTimeSeconds + gravityPhaseTime;
        double randomVariation = NestOfBeesEntity.getRandomInRange(0.8, 1.2);
        return Math.max(0.5, totalFlightTime * randomVariation);
    }

    private Vec3 calculateFallbackLaunchVector(Vec3 launchPos, Vec3 targetPos) {
        double dx = targetPos.f_82479_ - launchPos.f_82479_;
        double dy = targetPos.f_82480_ - launchPos.f_82480_;
        double dz = targetPos.f_82481_ - launchPos.f_82481_;
        float baseAngle = RocketTrajectoryCalculator.calculateOptimalLaunchAngle(launchPos, targetPos);
        float baseVelocity = 35.0f;
        float accuracy = 0.25f;
        float spreadFactor = (1.0f - accuracy) * 25.0f;
        float yawSpread = (float)NestOfBeesEntity.getRandomInRange(-spreadFactor, spreadFactor);
        float pitchSpread = (float)NestOfBeesEntity.getRandomInRange(-spreadFactor * 0.3f, spreadFactor * 0.3f);
        float velocitySpread = (float)NestOfBeesEntity.getRandomInRange(-3.0, 3.0);
        float adjustedAngle = Math.max(20.0f, Math.min(70.0f, baseAngle + pitchSpread));
        float adjustedVelocity = Math.max(5.0f, baseVelocity + velocitySpread);
        float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz)) + yawSpread;
        double yawRad = Math.toRadians(yaw);
        double pitchRad = Math.toRadians(adjustedAngle);
        double horizontalComponent = (double)adjustedVelocity * Math.cos(pitchRad);
        double verticalComponent = (double)adjustedVelocity * Math.sin(pitchRad);
        return new Vec3(horizontalComponent * Math.sin(yawRad), verticalComponent, horizontalComponent * Math.cos(yawRad));
    }

    private void finishFiringSequence() {
        this.inFiringSequence = false;
        this.currentRocketIndex = 0;
        this.fireDelay = 0;
        this.currentTarget = null;
        this.attackCooldown = this.getAttackCoolDownDuration();
        this.m_5810_();
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 30;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 10;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 20 + random.nextInt(20);
    }

    @Override
    public float getRotationLimit() {
        return 2.0f;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
    }

    public void debugShowAngleSelection(LivingEntity target) {
        if (target != null && !this.m_9236_().f_46443_) {
            Vec3 launchPos = this.calculateLaunchPosition(ROCKET_POSITIONS[0]);
            Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
            float optimalAngle = RocketTrajectoryCalculator.calculateOptimalLaunchAngle(launchPos, targetPos);
            double heightDiff = targetPos.f_82480_ - launchPos.f_82480_;
            double horizontalDistance = Math.sqrt(Math.pow(targetPos.f_82479_ - launchPos.f_82479_, 2.0) + Math.pow(targetPos.f_82481_ - launchPos.f_82481_, 2.0));
            float heightRatio = (float)(heightDiff / Math.max(horizontalDistance, 1.0));
            System.out.printf("=== \u667a\u80fd\u89d2\u5ea6\u9009\u62e9\u8c03\u8bd5\u4fe1\u606f ===%n", new Object[0]);
            System.out.printf("\u76ee\u6807: %s%n", target.m_7755_().getString());
            System.out.printf("\u9ad8\u5ea6\u5dee: %.1f \u65b9\u5757%n", heightDiff);
            System.out.printf("\u6c34\u5e73\u8ddd\u79bb: %.1f \u65b9\u5757%n", horizontalDistance);
            System.out.printf("\u9ad8\u5ea6\u6bd4\u7387: %.3f%n", Float.valueOf(heightRatio));
            System.out.printf("\u9009\u62e9\u89d2\u5ea6: %.1f\u00b0%n", Float.valueOf(optimalAngle));
            String strategy = "";
            strategy = heightRatio > 0.5f ? "\u9ad8\u89d2\u5ea6\u5c04\u51fb\uff08\u653b\u51fb\u9ad8\u76ee\u6807\uff09" : (heightRatio > 0.2f ? "\u4e2d\u7b49\u504f\u9ad8\u89d2\u5ea6" : (heightRatio > -0.2f ? "AW2\u6807\u51c6\u89d2\u5ea6" : (heightRatio > -0.5f ? "\u4e2d\u7b49\u504f\u4f4e\u89d2\u5ea6" : "\u4f4e\u89d2\u5ea6\u5c04\u51fb\uff08\u653b\u51fb\u4f4e\u76ee\u6807\uff09")));
            System.out.printf("\u7b56\u7565: %s%n", strategy);
            System.out.printf("============================%n", new Object[0]);
        }
    }

    @Override
    public double getDesiredDistance() {
        return 2.5;
    }

    @Override
    public boolean canFireAtTarget(LivingEntity target) {
        Vec3 targetPosition = new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_());
        return this.canFireAtPosition(targetPosition);
    }

    @Override
    public boolean canFireAtPosition(Vec3 targetPosition) {
        if (targetPosition == null) {
            return false;
        }
        float allowedRotationDifference = 20.0f;
        double dx = targetPosition.f_82479_ - this.m_20185_();
        double dz = targetPosition.f_82481_ - this.m_20189_();
        float actualTargetRot = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float actualRotDifference = Mth.m_14177_((float)(actualTargetRot - this.currentRot));
        float rotationDifference = Mth.m_14177_((float)(this.targetRot - this.currentRot));
        return Math.abs(rotationDifference) <= allowedRotationDifference && Math.abs(actualRotDifference) <= allowedRotationDifference;
    }

    @Override
    public boolean isValidTarget(LivingEntity potentialTarget) {
        double minimumAttackDistance = 20.0;
        double distanceToTarget = this.m_20275_(potentialTarget.m_20185_(), potentialTarget.m_20186_(), potentialTarget.m_20189_());
        if (distanceToTarget < minimumAttackDistance * minimumAttackDistance) {
            return false;
        }
        return super.isValidTarget(potentialTarget);
    }

    public void setTargetPosition(BlockPos pos) {
        this.f_19804_.m_135381_(TARGET_POS, (Object)pos);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("AttackCooldown", this.attackCooldown);
        compound.m_128379_("InFiringSequence", this.inFiringSequence);
        compound.m_128405_("CurrentRocketIndex", this.currentRocketIndex);
        compound.m_128405_("FireDelay", this.fireDelay);
        if (this.lastTargetPos != null) {
            compound.m_128347_("LastTargetPosX", this.lastTargetPos.f_82479_);
            compound.m_128347_("LastTargetPosY", this.lastTargetPos.f_82480_);
            compound.m_128347_("LastTargetPosZ", this.lastTargetPos.f_82481_);
        }
        if (this.currentTarget != null) {
            compound.m_128362_("CurrentTargetUUID", this.currentTarget.m_20148_());
        }
        compound.m_128379_("HasPositionTarget", this.hasPositionTarget());
        if (this.hasPositionTarget() && this.positionTarget != null) {
            compound.m_128347_("PositionTargetX", this.positionTarget.f_82479_);
            compound.m_128347_("PositionTargetY", this.positionTarget.f_82480_);
            compound.m_128347_("PositionTargetZ", this.positionTarget.f_82481_);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        double z;
        double y;
        double x;
        super.m_7378_(compound);
        this.attackCooldown = compound.m_128451_("AttackCooldown");
        this.inFiringSequence = compound.m_128471_("InFiringSequence");
        this.currentRocketIndex = compound.m_128451_("CurrentRocketIndex");
        this.fireDelay = compound.m_128451_("FireDelay");
        if (compound.m_128441_("LastTargetPosX")) {
            x = compound.m_128459_("LastTargetPosX");
            y = compound.m_128459_("LastTargetPosY");
            z = compound.m_128459_("LastTargetPosZ");
            this.lastTargetPos = new Vec3(x, y, z);
        }
        if (compound.m_128441_("CurrentTargetUUID")) {
            UUID targetUUID = compound.m_128342_("CurrentTargetUUID");
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_7654_().execute(() -> {
                    Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(targetUUID);
                    if (entity instanceof LivingEntity) {
                        this.currentTarget = (LivingEntity)entity;
                    }
                });
            }
        }
        if (compound.m_128441_("HasPositionTarget") && compound.m_128471_("HasPositionTarget")) {
            x = compound.m_128459_("PositionTargetX");
            y = compound.m_128459_("PositionTargetY");
            z = compound.m_128459_("PositionTargetZ");
            this.setPositionTarget(new Vec3(x, y, z));
        } else {
            this.setPositionTarget(null);
        }
        if (this.inFiringSequence && (this.currentRocketIndex >= 36 || this.fireDelay < 0)) {
            this.finishFiringSequence();
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FollowEntityGoal(this, 1.0, 5.0, 30.0, 40.0, 80.0));
        this.f_21345_.m_25352_(2, (Goal)new BaseCombatEntityAttackGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new PatrolGoal(this, 1.0, 40));
        this.f_21345_.m_25352_(3, (Goal)new FollowEntityGoal(this, 1.0, 5.0, 5.0, Double.MAX_VALUE, 0.0));
        this.f_21345_.m_25352_(4, (Goal)new ReturnToHomeGoal(this, 1.0));
        this.addTargetSelector();
    }

    @Override
    public void addTargetSelector() {
        Predicate<LivingEntity> unifiedPredicate = this::isValidTarget;
        this.f_21346_.m_25352_(1, (Goal)new SkyExposedTargetGoal(this, LivingEntity.class, 10, true, false, unifiedPredicate));
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.NEST_OF_BEES.get();
    }

    @Override
    public double getArrivalThreshold() {
        return 3.0;
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    public <T extends ParticleOptions> int sendParticlesToAllNearby(ServerLevel serverLevel, T particleOptions, double x, double y, double z, int count, double xOffset, double yOffset, double zOffset, double speed) {
        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(particleOptions, true, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, count);
        int sentCount = 0;
        for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
            if (!this.sendParticlesToPlayer(serverLevel, serverPlayer, x, y, z, (Packet<?>)packet)) continue;
            ++sentCount;
        }
        return sentCount;
    }

    private boolean sendParticlesToPlayer(ServerLevel serverLevel, ServerPlayer serverPlayer, double x, double y, double z, Packet<?> packet) {
        if (serverPlayer.m_9236_() != serverLevel) {
            return false;
        }
        double distanceSquared = serverPlayer.m_20182_().m_82557_(new Vec3(x, y, z));
        if (distanceSquared < 262144.0) {
            serverPlayer.f_8906_.m_9829_(packet);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPositionTarget() {
        return (Boolean)this.f_19804_.m_135370_(HAS_POSITION_TARGET);
    }

    @Override
    public Vec3 getPositionTarget() {
        return this.positionTarget;
    }

    @Override
    public void setPositionTarget(Vec3 targetPosition) {
        this.positionTarget = targetPosition;
        this.f_19804_.m_135381_(HAS_POSITION_TARGET, (Object)(targetPosition != null ? 1 : 0));
        if (targetPosition != null) {
            this.setTargetPosition(BlockPos.m_274446_((Position)targetPosition));
        } else {
            this.setTargetPosition(BlockPos.f_121853_);
        }
    }

    private static class RocketTubePosition {
        public final float lateralOffset;
        public final float longitudinalOffset;
        public final float verticalOffset;

        public RocketTubePosition(float lateralOffset, float longitudinalOffset, float verticalOffset) {
            this.lateralOffset = lateralOffset;
            this.longitudinalOffset = longitudinalOffset;
            this.verticalOffset = verticalOffset;
        }
    }
}

