/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.siege;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.entity.entities.siege.UnloadPassengerable;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.main.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.main.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.main.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.main.entity.utils.MultiSeatVehicle;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class SiegeTowerEntity
extends BaseCombatEntity
implements SiegeUnit,
MultiSeatVehicle,
UnloadPassengerable {
    private static final float MOVEMENT_SPEED = 0.18f;
    private static final EntityDataAccessor<Boolean> IS_DEPLOYING = SynchedEntityData.m_135353_(SiegeTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState deployAnimationState = new AnimationState();
    public final AnimationState undeployAnimationState = new AnimationState();
    private final List<MultiSeatVehicle.Seat> seats = new ArrayList<MultiSeatVehicle.Seat>();
    private final Map<Entity, MultiSeatVehicle.Seat> entitySeatMap = new HashMap<Entity, MultiSeatVehicle.Seat>();
    private static final int MAX_PASSENGERS = 15;
    private Vec3 unloadTarget;
    private static final double MAX_UNLOAD_DISTANCE = 6.0;
    private static final double UNLOAD_HEIGHT_RANGE = 15.0;
    private int unloadInitDelay = 0;
    private int unloadInterval = 0;
    private static final int UNLOAD_INIT_DELAY = 30;
    private static final int UNLOAD_INTERVAL = 20;
    private int lastAnimationTick = 0;
    private static final int ANIMATION_COOLDOWN = 30;
    private boolean isLastStateDeploying = false;

    public SiegeTowerEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_20088_().m_135372_(IS_DEPLOYING, (Object)false);
        this.m_274367_(1.0f);
        this.initializeSeats();
        this.isLastStateDeploying = false;
    }

    private void initializeSeats() {
        this.seats.clear();
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.PLAYER, new Vec3(0.0, 11.8, 0.0), false, MultiSeatVehicle.SeatPose.STANDING));
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.RANGED, new Vec3(0.8, 11.8, 0.8), false, MultiSeatVehicle.SeatPose.STANDING));
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.RANGED, new Vec3(-0.8, 11.8, 0.8), false, MultiSeatVehicle.SeatPose.STANDING));
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.RANGED, new Vec3(0.8, 11.8, -0.8), false, MultiSeatVehicle.SeatPose.STANDING));
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.RANGED, new Vec3(-0.8, 11.8, -0.8), false, MultiSeatVehicle.SeatPose.STANDING));
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.INTERNAL, new Vec3(0.0, 0.5, 0.0), true, MultiSeatVehicle.SeatPose.SITTING));
    }

    @Override
    public List<MultiSeatVehicle.Seat> getAllSeats() {
        return new ArrayList<MultiSeatVehicle.Seat>(this.seats);
    }

    @Override
    public int getMaxPassengers() {
        return 15;
    }

    @Override
    public Optional<MultiSeatVehicle.Seat> assignSeat(Entity entity) {
        MultiSeatVehicle.SeatType[] preferredTypes;
        if (this.entitySeatMap.containsKey(entity)) {
            MultiSeatVehicle.Seat currentSeat = this.entitySeatMap.get(entity);
            if (currentSeat.getType() == MultiSeatVehicle.SeatType.INTERNAL && entity instanceof LivingEntity && this.isRangedUnit((LivingEntity)entity)) {
                for (MultiSeatVehicle.Seat seat : this.seats) {
                    if (seat.getType() != MultiSeatVehicle.SeatType.RANGED || !seat.canAccept(entity)) continue;
                    if (!currentSeat.isAllowMultiple()) {
                        currentSeat.setOccupant(null);
                    }
                    if (!seat.isAllowMultiple()) {
                        seat.setOccupant(entity);
                    }
                    this.entitySeatMap.put(entity, seat);
                    return Optional.of(seat);
                }
            }
            return Optional.of(currentSeat);
        }
        for (MultiSeatVehicle.SeatType type : preferredTypes = this.getPreferredSeatTypes(entity)) {
            for (MultiSeatVehicle.Seat seat : this.seats) {
                if (seat.getType() != type || !seat.canAccept(entity)) continue;
                if (!seat.isAllowMultiple()) {
                    seat.setOccupant(entity);
                }
                this.entitySeatMap.put(entity, seat);
                return Optional.of(seat);
            }
        }
        return Optional.empty();
    }

    @Override
    public void releaseSeat(Entity entity) {
        MultiSeatVehicle.Seat seat = this.entitySeatMap.remove(entity);
        if (seat != null && !seat.isAllowMultiple()) {
            seat.setOccupant(null);
        }
    }

    @Override
    public Optional<MultiSeatVehicle.Seat> getSeatForEntity(Entity entity) {
        return Optional.ofNullable(this.entitySeatMap.get(entity));
    }

    @Override
    public int getPassengerCount() {
        return this.m_20197_().size();
    }

    @Override
    public MultiSeatVehicle.SeatType[] getPreferredSeatTypes(Entity entity) {
        if (entity instanceof Player || entity instanceof IPuppet) {
            return new MultiSeatVehicle.SeatType[]{MultiSeatVehicle.SeatType.PLAYER, MultiSeatVehicle.SeatType.INTERNAL};
        }
        if (entity instanceof LivingEntity && this.isRangedUnit((LivingEntity)entity)) {
            return new MultiSeatVehicle.SeatType[]{MultiSeatVehicle.SeatType.RANGED, MultiSeatVehicle.SeatType.INTERNAL};
        }
        return new MultiSeatVehicle.SeatType[]{MultiSeatVehicle.SeatType.INTERNAL};
    }

    public static AttributeSupplier.Builder createSiegeTowerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, (double)0.18f).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 5.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FollowEntityGoal(this, 1.0, 5.0, 20.0, 25.0, 50.0));
        this.f_21345_.m_25352_(2, (Goal)new BaseCombatEntityAttackGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new PatrolGoal(this, 1.0, 40));
        this.f_21345_.m_25352_(3, (Goal)new FollowEntityGoal(this, 1.0, 5.0, 5.0, Double.MAX_VALUE, 0.0));
        this.f_21345_.m_25352_(4, (Goal)new ReturnToHomeGoal(this, 1.0));
        super.addTargetSelector();
    }

    @Override
    public boolean isValidTarget(LivingEntity potentialTarget) {
        return false;
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 25;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 12;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 120;
    }

    @Override
    public float getRotationLimit() {
        return 1.0f;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
    }

    @Override
    public double getDesiredDistance() {
        return 4.0;
    }

    @Override
    public double getArrivalThreshold() {
        return 2.0;
    }

    @Override
    protected void updateAnimationState() {
        boolean stateChanged;
        boolean currentIsDeploying = this.getIsDeploying();
        boolean bl = stateChanged = currentIsDeploying != this.isLastStateDeploying;
        if (stateChanged) {
            int currentTick = this.f_19797_;
            if (currentTick - this.lastAnimationTick < 30) {
                return;
            }
            this.lastAnimationTick = currentTick;
            this.isLastStateDeploying = currentIsDeploying;
        }
        if (currentIsDeploying) {
            if (!this.deployAnimationState.m_216984_()) {
                this.undeployAnimationState.m_216973_();
                this.deployAnimationState.m_216977_(this.f_19797_);
            }
        } else if (!this.undeployAnimationState.m_216984_()) {
            this.deployAnimationState.m_216973_();
            this.undeployAnimationState.m_216977_(this.f_19797_);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.handleUnloadLogic();
        }
    }

    private void handleUnloadLogic() {
        if (!this.hasUnloadTarget()) {
            this.resetUnloadState();
            return;
        }
        Vec3 target = this.getUnloadTarget();
        if (!this.canUnloadAtPosition(target)) {
            this.resetUnloadState();
            return;
        }
        if (!this.getIsDeploying()) {
            this.setIsDeploying(true);
            this.unloadInitDelay = 30;
            this.unloadInterval = 0;
            return;
        }
        if (this.unloadInitDelay > 0) {
            --this.unloadInitDelay;
            return;
        }
        if (this.unloadInterval > 0) {
            --this.unloadInterval;
            return;
        }
        this.unloadInterval = !this.executeUnload(target) ? 20 : 20;
    }

    private void resetUnloadState() {
        if (this.getIsDeploying()) {
            this.setIsDeploying(false);
            this.unloadInitDelay = 0;
            this.unloadInterval = 0;
        }
    }

    private boolean executeUnload(Vec3 target) {
        ArrayList passengers = new ArrayList(this.m_20197_());
        if (passengers.isEmpty()) {
            return true;
        }
        passengers.sort((e1, e2) -> Integer.compare(this.getUnloadPriority((Entity)e1), this.getUnloadPriority((Entity)e2)));
        Entity passenger = (Entity)passengers.get(0);
        Vec3 unloadPos = this.findAvailableUnloadPosition(target);
        if (unloadPos == null) {
            return false;
        }
        passenger.m_8127_();
        double offsetX = (this.m_217043_().m_188500_() - 0.5) * 0.8;
        double offsetZ = (this.m_217043_().m_188500_() - 0.5) * 0.8;
        double finalX = unloadPos.f_82479_ + offsetX;
        double finalZ = unloadPos.f_82481_ + offsetZ;
        passenger.m_6021_(finalX, unloadPos.f_82480_, finalZ);
        if (passenger instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)passenger;
            combatEntity.setHomePosition(BlockPos.m_274561_((double)finalX, (double)unloadPos.f_82480_, (double)finalZ));
            combatEntity.setHomeReturnRadius(999.0);
            combatEntity.setShouldRender(false);
        }
        return true;
    }

    private int getUnloadPriority(Entity entity) {
        Optional<MultiSeatVehicle.Seat> seatOpt = this.getSeatForEntity(entity);
        if (seatOpt.isPresent()) {
            switch (seatOpt.get().getType()) {
                case INTERNAL: {
                    return 0;
                }
                case RANGED: {
                    return 1;
                }
                case PLAYER: {
                    return 2;
                }
            }
        }
        return 3;
    }

    private Vec3 findAvailableUnloadPosition(Vec3 targetPos) {
        for (int y = 0; y <= 3; ++y) {
            Vec3 checkPos = new Vec3(targetPos.f_82479_, targetPos.f_82480_ + (double)y + 1.0, targetPos.f_82481_);
            if (!this.isValidUnloadPosition(checkPos)) continue;
            return checkPos;
        }
        return null;
    }

    private boolean isValidUnloadPosition(Vec3 pos) {
        BlockPos blockPos = new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_);
        return this.m_9236_().m_46859_(blockPos) && this.m_9236_().m_46859_(blockPos.m_7494_());
    }

    protected boolean m_7310_(Entity entity) {
        return this.canEntityMount(entity);
    }

    protected void m_20348_(Entity entity) {
        super.m_20348_(entity);
        this.assignSeat(entity);
        if (!this.m_9236_().f_46443_) {
            this.optimizeSeatAssignments();
        }
        if (!this.m_9236_().f_46443_ && entity instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
            combatEntity.setFollowTarget(null);
            ServerPacketHandler.sendClearFollowTargetToAll(entity.m_20148_());
            ServerPacketHandler.sendClearSelectionToAll(entity.m_20148_());
        }
    }

    protected void m_20351_(Entity entity) {
        this.unloadPassengerToGround(entity);
        super.m_20351_(entity);
        this.releaseSeat(entity);
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        Optional<MultiSeatVehicle.Seat> seatOpt = this.getSeatForEntity(passenger);
        if (seatOpt.isPresent()) {
            BaseCombatEntity combatEntity;
            MultiSeatVehicle.Seat seat = seatOpt.get();
            Vec3 seatPos = seat.getPosition();
            float yBodyRot = this.getTrueYBodyRot() + 90.0f;
            float yBodyRotRad = (float)Math.toRadians(yBodyRot);
            double forwardX = Math.cos(yBodyRotRad);
            double forwardZ = Math.sin(yBodyRotRad);
            double rightX = Math.cos((double)yBodyRotRad + 1.5707963267948966);
            double rightZ = Math.sin((double)yBodyRotRad + 1.5707963267948966);
            double offsetX = forwardX * seatPos.f_82481_ + rightX * seatPos.f_82479_;
            double offsetZ = forwardZ * seatPos.f_82481_ + rightZ * seatPos.f_82479_;
            moveFunction.m_20372_(passenger, this.m_20185_() + offsetX, this.m_20186_() + seatPos.f_82480_, this.m_20189_() + offsetZ);
            if (passenger instanceof BaseCombatEntity && !(combatEntity = (BaseCombatEntity)passenger).getHasTarget()) {
                passenger.m_5616_(this.getTrueYBodyRot());
            }
        } else {
            super.m_19956_(passenger, moveFunction);
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().f_46443_ && this.canEntityMount((Entity)player)) {
            player.m_20329_((Entity)this);
        }
        return super.m_6071_(player, hand);
    }

    public MultiSeatVehicle.SeatPose getEntitySeatPose(Entity entity) {
        return this.getSeatForEntity(entity).map(MultiSeatVehicle.Seat::getPose).orElse(MultiSeatVehicle.SeatPose.SITTING);
    }

    private void optimizeSeatAssignments() {
        ArrayList passengers = new ArrayList(this.m_20197_());
        ArrayList<Entity> rangedUnits = new ArrayList<Entity>();
        ArrayList<Entity> otherUnits = new ArrayList<Entity>();
        for (Entity passenger : passengers) {
            if (passenger instanceof LivingEntity && this.isRangedUnit((LivingEntity)passenger)) {
                rangedUnits.add(passenger);
                continue;
            }
            otherUnits.add(passenger);
        }
        this.entitySeatMap.clear();
        for (MultiSeatVehicle.Seat seat : this.seats) {
            if (seat.isAllowMultiple()) continue;
            seat.setOccupant(null);
        }
        block2: for (Entity rangedUnit : rangedUnits) {
            boolean assigned = false;
            for (MultiSeatVehicle.Seat seat : this.seats) {
                if (seat.getType() != MultiSeatVehicle.SeatType.RANGED || !seat.canAccept(rangedUnit)) continue;
                if (!seat.isAllowMultiple()) {
                    seat.setOccupant(rangedUnit);
                }
                this.entitySeatMap.put(rangedUnit, seat);
                assigned = true;
                break;
            }
            if (assigned) continue;
            for (MultiSeatVehicle.Seat seat : this.seats) {
                if (seat.getType() != MultiSeatVehicle.SeatType.INTERNAL || !seat.canAccept(rangedUnit)) continue;
                this.entitySeatMap.put(rangedUnit, seat);
                continue block2;
            }
        }
        for (Entity otherUnit : otherUnits) {
            this.assignSeat(otherUnit);
        }
    }

    public LivingEntity m_6688_() {
        return null;
    }

    @Override
    public boolean canUnloadAtPosition(Vec3 targetPosition) {
        if (targetPosition == null) {
            return false;
        }
        double horizontalDistance = Math.sqrt(Math.pow(targetPosition.f_82479_ - this.m_20185_(), 2.0) + Math.pow(targetPosition.f_82481_ - this.m_20189_(), 2.0));
        if (horizontalDistance > this.getMaxUnloadDistance()) {
            return false;
        }
        double heightDiff = targetPosition.f_82480_ - this.m_20186_();
        return heightDiff >= -0.5 * this.getUnloadHeightRange() && heightDiff <= this.getUnloadHeightRange();
    }

    @Override
    public boolean hasUnloadTarget() {
        return this.unloadTarget != null;
    }

    @Override
    public Vec3 getUnloadTarget() {
        return this.unloadTarget;
    }

    @Override
    public void setUnloadTarget(Vec3 targetPosition) {
        this.unloadTarget = targetPosition;
        if (targetPosition != null) {
            this.resetUnloadState();
        }
    }

    @Override
    public double getMaxUnloadDistance() {
        return 6.0;
    }

    @Override
    public double getUnloadHeightRange() {
        return 15.0;
    }

    @Override
    public void unloadPassengerToGround(Entity passenger) {
        if (this.m_9236_().f_46443_ || passenger == null) {
            return;
        }
        Random random = new Random();
        double maxDistance = this.getMaxUnloadDistance();
        double angle = random.nextDouble() * 2.0 * Math.PI;
        double distance = random.nextDouble() * maxDistance;
        double offsetX = Math.cos(angle) * distance;
        double offsetZ = Math.sin(angle) * distance;
        double targetX = this.m_20185_() + offsetX;
        double targetZ = this.m_20189_() + offsetZ;
        BlockPos groundPos = new BlockPos((int)targetX, (int)this.m_20186_(), (int)targetZ);
        double groundY = this.findGroundLevel(groundPos);
        passenger.m_8127_();
        passenger.m_6021_(targetX, groundY, targetZ);
        if (passenger instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)passenger;
            combatEntity.setHomePosition(BlockPos.m_274561_((double)targetX, (double)groundY, (double)targetZ));
            combatEntity.setHomeReturnRadius(999.0);
            combatEntity.setShouldRender(false);
        }
    }

    private double findGroundLevel(BlockPos startPos) {
        for (int y = startPos.m_123342_(); y >= startPos.m_123342_() - 10; --y) {
            BlockPos checkPos = new BlockPos(startPos.m_123341_(), y, startPos.m_123343_());
            if (this.m_9236_().m_46859_(checkPos)) continue;
            BlockPos abovePos = checkPos.m_7494_();
            if (!this.m_9236_().m_46859_(abovePos) || !this.m_9236_().m_46859_(abovePos.m_7494_())) continue;
            return abovePos.m_123342_();
        }
        return startPos.m_123342_();
    }

    public void setIsDeploying(boolean deploying) {
        this.m_20088_().m_135381_(IS_DEPLOYING, (Object)deploying);
    }

    public boolean getIsDeploying() {
        return (Boolean)this.m_20088_().m_135370_(IS_DEPLOYING);
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.SIEGE_TOWER.get();
    }

    @Override
    public void m_6667_(DamageSource damageSource) {
        ArrayList passengers = new ArrayList(this.m_20197_());
        for (Entity passenger : passengers) {
            this.unloadPassengerToGround(passenger);
        }
        super.m_6667_(damageSource);
    }

    @Override
    public boolean canFireAtTarget(LivingEntity target) {
        return false;
    }
}

