/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.block.entity.BlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.BreedingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.entity.entities.BreederEntity;

public class BreederActivateWorkstationGoal
extends Goal {
    private final BreederEntity breeder;
    private final int searchRange;
    private BlockPos targetWorkstation;
    private int workCooldown;
    private int searchCooldown;
    private int armSwingCooldown;
    private static final int MIN_WORK_INTERVAL = 10;
    private static final int MAX_WORK_INTERVAL = 30;
    private static final int SEARCH_COOLDOWN = 30;
    private static final int ARM_SWING_INTERVAL = 5;
    private static final int ARM_SWING_RANDOMNESS = 2;
    private final Random random = new Random();

    public BreederActivateWorkstationGoal(BreederEntity breeder, int searchRange) {
        this.breeder = breeder;
        this.searchRange = searchRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.breeder.commandHold()) {
            return false;
        }
        if (this.searchCooldown > 0) {
            --this.searchCooldown;
            return false;
        }
        if (this.targetWorkstation != null && this.isWorkstationValid(this.targetWorkstation)) {
            return true;
        }
        this.targetWorkstation = this.findNearestBreedingWorkstation();
        return this.targetWorkstation != null;
    }

    public boolean m_8045_() {
        if (this.breeder.commandHold()) {
            return false;
        }
        return this.targetWorkstation != null && this.isWorkstationValid(this.targetWorkstation);
    }

    private boolean isWorkstationValid(BlockPos pos) {
        if (this.breeder.m_9236_() == null) {
            return false;
        }
        BlockEntity blockEntity = this.breeder.m_9236_().m_7702_(pos);
        return blockEntity instanceof BreedingWorkstationBlockEntity;
    }

    private BlockPos findNearestBreedingWorkstation() {
        BlockPos entityPos = this.breeder.m_20183_();
        BlockPos nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (int x = -this.searchRange; x <= this.searchRange; ++x) {
            for (int y = -this.searchRange; y <= this.searchRange; ++y) {
                for (int z = -this.searchRange; z <= this.searchRange; ++z) {
                    double distance;
                    BlockPos checkPos = entityPos.m_7918_(x, y, z);
                    BlockEntity blockEntity = this.breeder.m_9236_().m_7702_(checkPos);
                    if (!(blockEntity instanceof BreedingWorkstationBlockEntity) || !((distance = entityPos.m_123331_((Vec3i)checkPos)) < nearestDistance)) continue;
                    nearestDistance = distance;
                    nearest = checkPos;
                }
            }
        }
        return nearest;
    }

    public void m_8056_() {
        if (this.targetWorkstation != null) {
            PathNavigation navigation = this.breeder.m_21573_();
            navigation.m_26519_((double)this.targetWorkstation.m_123341_() + 0.5, (double)this.targetWorkstation.m_123342_(), (double)this.targetWorkstation.m_123343_() + 0.5, 1.0);
            this.resetWorkCooldown();
            this.armSwingCooldown = 5 + this.random.nextInt(5) - 2;
        }
    }

    public void m_8037_() {
        if (this.targetWorkstation == null) {
            return;
        }
        double distanceToWorkstation = this.breeder.m_20275_((double)this.targetWorkstation.m_123341_() + 0.5, this.targetWorkstation.m_123342_(), (double)this.targetWorkstation.m_123343_() + 0.5);
        if (distanceToWorkstation <= 9.0) {
            if (this.armSwingCooldown > 0) {
                --this.armSwingCooldown;
            } else {
                this.breeder.m_6674_(InteractionHand.MAIN_HAND);
                this.armSwingCooldown = 5 + this.random.nextInt(5) - 2;
            }
            if (this.workCooldown > 0) {
                --this.workCooldown;
            } else {
                this.triggerWorkstationWork();
                this.resetWorkCooldown();
            }
            this.breeder.m_21573_().m_26573_();
        } else {
            PathNavigation navigation = this.breeder.m_21573_();
            if (navigation.m_26571_()) {
                navigation.m_26519_((double)this.targetWorkstation.m_123341_() + 0.5, (double)this.targetWorkstation.m_123342_(), (double)this.targetWorkstation.m_123343_() + 0.5, 1.0);
            }
        }
    }

    private void resetWorkCooldown() {
        this.workCooldown = this.breeder.m_217043_().m_188503_(21) + 10;
    }

    private void triggerWorkstationWork() {
        BlockEntity blockEntity = this.breeder.m_9236_().m_7702_(this.targetWorkstation);
        if (blockEntity instanceof BreedingWorkstationBlockEntity) {
            BreedingWorkstationBlockEntity workstation = (BreedingWorkstationBlockEntity)blockEntity;
            workstation.triggerWork();
        }
    }

    public void m_8041_() {
        this.searchCooldown = 30;
        this.targetWorkstation = null;
        this.breeder.m_21573_().m_26573_();
    }
}

