/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.block.entity.BlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.entity.entities.FisherEntity;

public class FisherActivateWorkstationGoal
extends Goal {
    private final FisherEntity fisher;
    private final int searchRange;
    private BlockPos targetWorkstation;
    private int workCooldown;
    private int searchCooldown;
    private int armSwingCooldown;
    private static final int MIN_WORK_INTERVAL = 15;
    private static final int MAX_WORK_INTERVAL = 40;
    private static final int SEARCH_COOLDOWN = 30;
    private static final int ARM_SWING_INTERVAL = 8;
    private static final int ARM_SWING_RANDOMNESS = 2;
    private final Random random = new Random();

    public FisherActivateWorkstationGoal(FisherEntity fisher, int searchRange) {
        this.fisher = fisher;
        this.searchRange = searchRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.fisher.commandHold()) {
            return false;
        }
        if (this.searchCooldown > 0) {
            --this.searchCooldown;
            return false;
        }
        if (this.targetWorkstation != null && this.isWorkstationValid(this.targetWorkstation)) {
            return true;
        }
        this.targetWorkstation = this.fisher.findNearestWorkstation();
        return this.targetWorkstation != null;
    }

    public boolean m_8045_() {
        if (this.fisher.commandHold()) {
            return false;
        }
        return this.targetWorkstation != null && this.isWorkstationValid(this.targetWorkstation);
    }

    private boolean isWorkstationValid(BlockPos pos) {
        if (this.fisher.m_9236_() == null) {
            return false;
        }
        BlockEntity blockEntity = this.fisher.m_9236_().m_7702_(pos);
        return blockEntity instanceof FishingWorkstationBlockEntity;
    }

    public void m_8056_() {
        if (this.targetWorkstation != null) {
            PathNavigation navigation = this.fisher.m_21573_();
            navigation.m_26519_((double)this.targetWorkstation.m_123341_() + 0.5, (double)this.targetWorkstation.m_123342_(), (double)this.targetWorkstation.m_123343_() + 0.5, 1.0);
            this.resetWorkCooldown();
            this.armSwingCooldown = 8 + this.random.nextInt(5) - 2;
        }
    }

    public void m_8037_() {
        if (this.targetWorkstation == null) {
            return;
        }
        double distanceToWorkstation = this.fisher.m_20275_((double)this.targetWorkstation.m_123341_() + 0.5, this.targetWorkstation.m_123342_(), (double)this.targetWorkstation.m_123343_() + 0.5);
        if (distanceToWorkstation <= 9.0) {
            if (this.armSwingCooldown > 0) {
                --this.armSwingCooldown;
            } else {
                this.fisher.m_6674_(InteractionHand.MAIN_HAND);
                this.armSwingCooldown = 8 + this.random.nextInt(5) - 2;
            }
            if (this.workCooldown > 0) {
                --this.workCooldown;
            } else {
                this.triggerWorkstationWork();
                this.resetWorkCooldown();
            }
            this.fisher.m_21573_().m_26573_();
        } else {
            PathNavigation navigation = this.fisher.m_21573_();
            if (navigation.m_26571_()) {
                navigation.m_26519_((double)this.targetWorkstation.m_123341_() + 0.5, (double)this.targetWorkstation.m_123342_(), (double)this.targetWorkstation.m_123343_() + 0.5, 1.0);
            }
        }
    }

    private void resetWorkCooldown() {
        this.workCooldown = this.fisher.m_217043_().m_188503_(26) + 15;
    }

    private void triggerWorkstationWork() {
        BlockEntity blockEntity = this.fisher.m_9236_().m_7702_(this.targetWorkstation);
        if (blockEntity instanceof FishingWorkstationBlockEntity) {
            FishingWorkstationBlockEntity workstation = (FishingWorkstationBlockEntity)blockEntity;
            workstation.triggerWork();
        }
    }

    public void m_8041_() {
        this.searchCooldown = 30;
        this.targetWorkstation = null;
        this.fisher.m_21573_().m_26573_();
    }
}

