/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.navigation.BaseCombatNavigation;

public class LadderAwareMoveControl
extends MoveControl {
    private static final double LADDER_CLIMB_SPEED = 0.2;
    private static final double LADDER_DESCEND_SPEED = 0.3;
    private static final double HORIZONTAL_MOVE_THRESHOLD = 0.3;

    public LadderAwareMoveControl(Mob mob) {
        super(mob);
    }

    public void m_8126_() {
        if (this.isStandingOnPlatform() || this.isAtLadderTopNearPlatform()) {
            super.m_8126_();
        } else if (this.isOnLadder()) {
            this.handleLadderMovement();
        } else {
            super.m_8126_();
        }
    }

    private void handleLadderMovement() {
        Node nextNode;
        Path path;
        if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
            if (this.hasActiveMovementTarget()) {
                this.f_24981_ = MoveControl.Operation.MOVE_TO;
            } else {
                if (this.isStandingOnPlatform() || this.isAtLadderTopNearPlatform()) {
                    super.m_8126_();
                    return;
                }
                this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82542_(1.0, 0.0, 1.0));
                return;
            }
        }
        if ((path = this.f_24974_.m_21573_().m_26570_()) == null || path.m_77392_()) {
            if (this.tryCreateNewPath()) {
                path = this.f_24974_.m_21573_().m_26570_();
            } else {
                this.stopOnLadder();
                return;
            }
        }
        if ((nextNode = this.getNextPathNode(path)) == null) {
            this.stopOnLadder();
            return;
        }
        Vec3 nodePos = new Vec3((double)nextNode.f_77271_ + 0.5, (double)nextNode.f_77272_, (double)nextNode.f_77273_ + 0.5);
        if (this.hasReachedPlatformTarget(nodePos)) {
            this.f_24974_.m_21573_().m_26573_();
            return;
        }
        Vec3 targetPos = new Vec3((double)nextNode.f_77271_ + 0.5, (double)nextNode.f_77272_, (double)nextNode.f_77273_ + 0.5);
        Vec3 currentPos = this.f_24974_.m_20182_();
        double dx = targetPos.f_82479_ - currentPos.f_82479_;
        double dy = targetPos.f_82480_ - currentPos.f_82480_;
        double dz = targetPos.f_82481_ - currentPos.f_82481_;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        if (horizontalDist > 0.1) {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f, 90.0f));
        }
        Vec3 motion = Vec3.f_82478_;
        if (Math.abs(dy) > 0.05) {
            BlockPos targetBlockPos = new BlockPos((int)targetPos.f_82479_, (int)targetPos.f_82480_, (int)targetPos.f_82481_);
            boolean isPlatformTarget = this.isAdjacentPlatform(targetBlockPos);
            if (dy > 0.0) {
                double verticalSpeed = isPlatformTarget && dy < 1.5 ? 0.30000000000000004 : 0.2;
                double horizontalSpeed = Math.min(horizontalDist, 0.1) * this.f_24978_ * 0.3;
                motion = horizontalDist > 0.01 ? new Vec3(dx / horizontalDist * horizontalSpeed, verticalSpeed, dz / horizontalDist * horizontalSpeed) : new Vec3(0.0, verticalSpeed, 0.0);
            } else {
                double verticalSpeed = -0.3;
                if (this.isTargetOnLadderPath(targetBlockPos)) {
                    double safeHorizontalSpeed = Math.min(horizontalDist, 0.05) * 0.5;
                    motion = horizontalDist > 0.002 ? new Vec3(dx / horizontalDist * safeHorizontalSpeed, verticalSpeed, dz / horizontalDist * safeHorizontalSpeed) : new Vec3(0.0, verticalSpeed, 0.0);
                } else {
                    double horizontalSpeed = Math.min(horizontalDist, 0.08) * this.f_24978_ * 0.2;
                    motion = new Vec3(dx / horizontalDist * horizontalSpeed, verticalSpeed, dz / horizontalDist * horizontalSpeed);
                }
            }
        } else if (horizontalDist > 0.1) {
            BlockPos targetBlockPos = new BlockPos((int)targetPos.f_82479_, (int)targetPos.f_82480_, (int)targetPos.f_82481_);
            if (this.isAdjacentPlatform(targetBlockPos)) {
                double moveSpeed = this.f_24978_ * 0.2;
                double jumpHeight = 0.1;
                motion = new Vec3(dx / horizontalDist * moveSpeed, jumpHeight, dz / horizontalDist * moveSpeed);
            } else {
                double moveSpeed = this.f_24978_ * 0.1;
                motion = new Vec3(dx / horizontalDist * moveSpeed, 0.0, dz / horizontalDist * moveSpeed);
            }
        }
        this.f_24974_.m_20256_(motion);
        this.f_24974_.m_21564_(0.0f);
        this.f_24974_.m_21570_(0.0f);
        this.f_24974_.m_6862_(false);
        this.f_24981_ = MoveControl.Operation.WAIT;
    }

    private void stopOnLadder() {
        this.f_24974_.m_20334_(0.0, 0.0, 0.0);
        this.f_24974_.m_21564_(0.0f);
        this.f_24974_.m_21570_(0.0f);
        this.f_24974_.m_6862_(false);
    }

    private boolean isOnLadder() {
        if (this.isOnSafeGround()) {
            return false;
        }
        if (this.isStandingOnPlatform()) {
            return false;
        }
        if (this.isAtLadderTopNearPlatform()) {
            return false;
        }
        BlockPos pos = this.f_24974_.m_20183_();
        boolean hasClimbableBlock = this.f_24974_.m_9236_().m_8055_(pos).m_204336_(BlockTags.f_13082_) || this.f_24974_.m_9236_().m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13082_);
        return hasClimbableBlock;
    }

    private Node getNextPathNode(Path path) {
        int nextIndex = path.m_77399_();
        if (nextIndex < path.m_77398_()) {
            return path.m_77375_(nextIndex);
        }
        if (nextIndex > 0 && nextIndex - 1 < path.m_77398_()) {
            return path.m_77375_(nextIndex - 1);
        }
        return null;
    }

    private boolean isAdjacentPlatform(BlockPos targetPos) {
        BlockPos currentPos = this.f_24974_.m_20183_();
        if (Math.abs(targetPos.m_123342_() - currentPos.m_123342_()) <= 2) {
            int dx = Math.abs(targetPos.m_123341_() - currentPos.m_123341_());
            int dz = Math.abs(targetPos.m_123343_() - currentPos.m_123343_());
            if (dx <= 1 && dz == 0 || dx == 0 && dz <= 1) {
                return this.f_24974_.m_9236_().m_8055_(targetPos).m_60795_() && this.f_24974_.m_9236_().m_8055_(targetPos.m_7495_()).m_60804_((BlockGetter)this.f_24974_.m_9236_(), targetPos.m_7495_());
            }
        }
        return false;
    }

    private boolean isStandingOnPlatform() {
        BlockPos currentPos = this.f_24974_.m_20183_();
        BlockPos belowPos = currentPos.m_7495_();
        boolean isOnSolidGround = this.f_24974_.m_9236_().m_8055_(belowPos).m_60804_((BlockGetter)this.f_24974_.m_9236_(), belowPos);
        boolean hasHeadroom = this.f_24974_.m_9236_().m_8055_(currentPos.m_7494_()).m_60795_();
        Vec3 entityPos = this.f_24974_.m_20182_();
        double floorY = (double)belowPos.m_123342_() + 1.0;
        boolean isNearGround = Math.abs(entityPos.f_82480_ - floorY) < 0.3;
        return isOnSolidGround && hasHeadroom && isNearGround;
    }

    private boolean isAtLadderTopNearPlatform() {
        Direction[] directions;
        boolean noLadderAbove;
        BlockPos currentPos = this.f_24974_.m_20183_();
        boolean hasLadderBelow = this.f_24974_.m_9236_().m_8055_(currentPos).m_204336_(BlockTags.f_13082_) || this.f_24974_.m_9236_().m_8055_(currentPos.m_7495_()).m_204336_(BlockTags.f_13082_);
        boolean bl = noLadderAbove = !this.f_24974_.m_9236_().m_8055_(currentPos.m_7494_()).m_204336_(BlockTags.f_13082_);
        if (!hasLadderBelow || !noLadderAbove) {
            return false;
        }
        for (Direction dir : directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos adjacentPos = currentPos.m_121945_(dir);
            if (this.isPlatformAccessible(adjacentPos)) {
                return true;
            }
            BlockPos adjacentAbove = adjacentPos.m_7494_();
            if (!this.isPlatformAccessible(adjacentAbove)) continue;
            return true;
        }
        return false;
    }

    private boolean isPlatformAccessible(BlockPos pos) {
        boolean isSolidBlock = this.f_24974_.m_9236_().m_8055_(pos).m_60804_((BlockGetter)this.f_24974_.m_9236_(), pos);
        boolean hasSpace1 = this.f_24974_.m_9236_().m_8055_(pos.m_7494_()).m_60795_();
        boolean hasSpace2 = this.f_24974_.m_9236_().m_8055_(pos.m_6630_(2)).m_60795_();
        return isSolidBlock && hasSpace1 && hasSpace2;
    }

    private boolean isTargetOnLadderPath(BlockPos targetPos) {
        if (this.f_24974_.m_9236_().m_8055_(targetPos).m_204336_(BlockTags.f_13082_)) {
            return true;
        }
        if (this.f_24974_.m_9236_().m_8055_(targetPos.m_7495_()).m_204336_(BlockTags.f_13082_)) {
            return true;
        }
        Vec3 currentPos = this.f_24974_.m_20182_();
        int currentY = (int)currentPos.f_82480_;
        int targetY = targetPos.m_123342_();
        if (targetPos.m_123341_() == (int)currentPos.f_82479_ && targetPos.m_123343_() == (int)currentPos.f_82481_) {
            int minY = Math.min(currentY, targetY);
            int maxY = Math.max(currentY, targetY);
            for (int y = minY; y <= maxY; ++y) {
                BlockPos checkPos = new BlockPos(targetPos.m_123341_(), y, targetPos.m_123343_());
                if (this.f_24974_.m_9236_().m_8055_(checkPos).m_204336_(BlockTags.f_13082_)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean hasReachedPlatformTarget(Vec3 targetPos) {
        Vec3 currentPos = this.f_24974_.m_20182_();
        BlockPos targetBlockPos = new BlockPos((int)targetPos.f_82479_, (int)targetPos.f_82480_, (int)targetPos.f_82481_);
        if (!this.isAdjacentPlatform(targetBlockPos)) {
            return false;
        }
        double horizontalDist = Math.sqrt(Math.pow(currentPos.f_82479_ - targetPos.f_82479_, 2.0) + Math.pow(currentPos.f_82481_ - targetPos.f_82481_, 2.0));
        double verticalDist = Math.abs(currentPos.f_82480_ - targetPos.f_82480_);
        boolean isWithinRange = horizontalDist < 0.6 && verticalDist < 0.5;
        boolean isOnSolidGround = this.f_24974_.m_9236_().m_8055_(this.f_24974_.m_20183_().m_7495_()).m_60804_((BlockGetter)this.f_24974_.m_9236_(), this.f_24974_.m_20183_().m_7495_());
        return isWithinRange && isOnSolidGround;
    }

    private boolean hasActiveMovementTarget() {
        Path path = this.f_24974_.m_21573_().m_26570_();
        if (path != null && !path.m_77392_()) {
            return true;
        }
        return this.f_24975_ != 0.0 || this.f_24976_ != 0.0 || this.f_24977_ != 0.0;
    }

    private boolean tryCreateNewPath() {
        PathNavigation navigation = this.f_24974_.m_21573_();
        if (!(navigation instanceof BaseCombatNavigation)) {
            return this.tryBasicPathRecreation();
        }
        BaseCombatNavigation combatNav = (BaseCombatNavigation)navigation;
        if (this.f_24975_ != 0.0 || this.f_24976_ != 0.0 || this.f_24977_ != 0.0) {
            return combatNav.m_26519_(this.f_24975_, this.f_24976_, this.f_24977_, this.f_24978_);
        }
        if (navigation.m_26567_() != null) {
            BlockPos targetPos = navigation.m_26567_();
            return combatNav.m_26519_(targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_(), this.f_24978_);
        }
        if (this.f_24974_.m_5448_() != null) {
            return combatNav.m_5624_((Entity)this.f_24974_.m_5448_(), this.f_24978_);
        }
        return false;
    }

    private boolean tryBasicPathRecreation() {
        PathNavigation navigation = this.f_24974_.m_21573_();
        if (this.f_24975_ != 0.0 || this.f_24976_ != 0.0 || this.f_24977_ != 0.0) {
            return navigation.m_26519_(this.f_24975_, this.f_24976_, this.f_24977_, this.f_24978_);
        }
        if (this.f_24974_.m_5448_() != null) {
            return navigation.m_5624_((Entity)this.f_24974_.m_5448_(), this.f_24978_);
        }
        return false;
    }

    protected float m_24991_(float current, float target, float maxDelta) {
        float result;
        float delta = Mth.m_14177_((float)(target - current));
        if (delta > maxDelta) {
            delta = maxDelta;
        }
        if (delta < -maxDelta) {
            delta = -maxDelta;
        }
        if ((result = current + delta) < 0.0f) {
            result += 360.0f;
        } else if (result > 360.0f) {
            result -= 360.0f;
        }
        return result;
    }

    private boolean isOnSafeGround() {
        Direction[] directions;
        BlockPos currentPos = this.f_24974_.m_20183_();
        BlockPos belowPos = currentPos.m_7495_();
        if (!this.f_24974_.m_20096_()) {
            return false;
        }
        if (!this.f_24974_.m_9236_().m_8055_(belowPos).m_60804_((BlockGetter)this.f_24974_.m_9236_(), belowPos)) {
            return false;
        }
        if (this.f_24974_.m_9236_().m_8055_(currentPos).m_204336_(BlockTags.f_13082_) || this.f_24974_.m_9236_().m_8055_(belowPos).m_204336_(BlockTags.f_13082_)) {
            return false;
        }
        for (Direction dir : directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            for (int i = 1; i <= 3; ++i) {
                BlockPos checkPos = currentPos.m_5484_(dir, i);
                if (!this.f_24974_.m_9236_().m_8055_(checkPos).m_204336_(BlockTags.f_13082_) && !this.f_24974_.m_9236_().m_8055_(checkPos.m_7495_()).m_204336_(BlockTags.f_13082_) && !this.f_24974_.m_9236_().m_8055_(checkPos.m_7494_()).m_204336_(BlockTags.f_13082_)) continue;
                return false;
            }
        }
        Vec3 entityPos = this.f_24974_.m_20182_();
        double expectedY = (double)belowPos.m_123342_() + 1.0;
        return !(Math.abs(entityPos.f_82480_ - expectedY) > 0.1);
    }
}

