/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class LadderAwareNodeEvaluator
extends WalkNodeEvaluator {
    public int m_6065_(Node[] nodes, Node node) {
        Direction[] directions;
        int count = super.m_6065_(nodes, node);
        BlockPos currentPos = new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_);
        if (!this.shouldUseLadderPathfinding(currentPos)) {
            return count;
        }
        count = this.addVerticalNodes(nodes, count, node, currentPos);
        count = this.addLadderNodesAtLevel(nodes, count, node, currentPos.m_7494_());
        count = this.addLadderNodesAtLevel(nodes, count, node, currentPos.m_7495_());
        for (Direction dir : directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos adjacentPos = currentPos.m_121945_(dir);
            count = this.addLadderNodesAtLevel(nodes, count, node, adjacentPos);
            count = this.addLadderNodesAtLevel(nodes, count, node, adjacentPos.m_7494_());
            count = this.addLadderNodesAtLevel(nodes, count, node, adjacentPos.m_7495_());
        }
        return Math.min(count, nodes.length - 1);
    }

    private int addVerticalNodes(Node[] nodes, int currentCount, Node centerNode, BlockPos currentPos) {
        int count = currentCount;
        if (this.f_77312_.m_8055_(currentPos).m_204336_(BlockTags.f_13082_)) {
            Node downNode;
            Node upNode = this.getVerticalNode(centerNode.f_77271_, centerNode.f_77272_ + 1, centerNode.f_77273_, Direction.UP);
            if (upNode != null && this.m_77626_(upNode, centerNode) && count < nodes.length) {
                nodes[count++] = upNode;
            }
            if ((downNode = this.getVerticalNode(centerNode.f_77271_, centerNode.f_77272_ - 1, centerNode.f_77273_, Direction.DOWN)) != null && this.m_77626_(downNode, centerNode) && count < nodes.length) {
                nodes[count++] = downNode;
            }
        }
        return count;
    }

    private int addLadderNodesAtLevel(Node[] nodes, int currentCount, Node centerNode, BlockPos checkPos) {
        BlockPos standingPos;
        Node platformNode;
        int count = currentCount;
        if (checkPos.m_123342_() < this.f_77312_.m_141937_() || checkPos.m_123342_() >= this.f_77312_.m_151558_()) {
            return count;
        }
        if (this.f_77312_.m_8055_(checkPos).m_204336_(BlockTags.f_13082_)) {
            Node ladderNode = this.m_5676_(checkPos.m_123341_(), checkPos.m_123342_(), checkPos.m_123343_());
            if (ladderNode != null && this.m_77626_(ladderNode, centerNode) && count < nodes.length) {
                ladderNode.f_77282_ = BlockPathTypes.OPEN;
                int deltaY = checkPos.m_123342_() - centerNode.f_77272_;
                ladderNode.f_77281_ = deltaY > 0 ? 0.0f : (deltaY < 0 ? 0.0f : 0.0f);
                nodes[count++] = ladderNode;
            }
            count = this.addAdjacentPlatformNodes(nodes, count, centerNode, checkPos);
        } else if (this.isStandablePlatform(checkPos) && (platformNode = this.m_5676_((standingPos = checkPos.m_7494_()).m_123341_(), standingPos.m_123342_(), standingPos.m_123343_())) != null && this.m_77626_(platformNode, centerNode) && count < nodes.length) {
            platformNode.f_77282_ = BlockPathTypes.OPEN;
            int deltaY = standingPos.m_123342_() - centerNode.f_77272_;
            platformNode.f_77281_ = deltaY > 0 ? 1.8f : (deltaY < 0 ? 1.5f : 1.2f);
            nodes[count++] = platformNode;
        }
        return count;
    }

    private Node getVerticalNode(int x, int y, int z, Direction direction) {
        Node verticalNode;
        if (y < this.f_77312_.m_141937_() || y >= this.f_77312_.m_151558_()) {
            return null;
        }
        BlockPos targetPos = new BlockPos(x, y, z);
        if (direction == Direction.UP) {
            Node verticalNode2;
            if ((this.f_77312_.m_8055_(targetPos).m_204336_(BlockTags.f_13082_) || this.f_77312_.m_8055_(targetPos).m_60795_() || this.isStandablePlatform(targetPos)) && (verticalNode2 = this.m_5676_(x, y, z)) != null) {
                verticalNode2.f_77282_ = BlockPathTypes.OPEN;
                verticalNode2.f_77281_ = this.isStandablePlatform(targetPos) ? 1.5f : 1.1f;
                return verticalNode2;
            }
        } else if (direction == Direction.DOWN && this.f_77312_.m_8055_(targetPos).m_204336_(BlockTags.f_13082_) && (verticalNode = this.m_5676_(x, y, z)) != null) {
            verticalNode.f_77282_ = BlockPathTypes.OPEN;
            verticalNode.f_77281_ = 1.0f;
            return verticalNode;
        }
        return null;
    }

    private boolean isStandablePlatform(BlockPos pos) {
        if (!this.f_77312_.m_8055_(pos).m_60804_((BlockGetter)this.f_77312_, pos)) {
            return false;
        }
        BlockPos above1 = pos.m_7494_();
        BlockPos above2 = pos.m_6630_(2);
        return this.f_77312_.m_8055_(above1).m_60795_() && this.f_77312_.m_8055_(above2).m_60795_();
    }

    private int addAdjacentPlatformNodes(Node[] nodes, int currentCount, Node centerNode, BlockPos ladderPos) {
        Direction[] directions;
        int count = currentCount;
        for (Direction dir : directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos standingPos;
            Node platformNode;
            BlockPos adjacentPos = ladderPos.m_121945_(dir);
            if (!this.isStandablePlatform(adjacentPos) || count >= nodes.length || (platformNode = this.m_5676_((standingPos = adjacentPos.m_7494_()).m_123341_(), standingPos.m_123342_(), standingPos.m_123343_())) == null || !this.m_77626_(platformNode, centerNode)) continue;
            platformNode.f_77282_ = BlockPathTypes.OPEN;
            platformNode.f_77281_ = 1.6f;
            nodes[count++] = platformNode;
        }
        return count;
    }

    protected boolean m_262494_(BlockPos blockPos) {
        BlockPathTypes blockPathTypes = this.m_77572_(this.f_77313_, blockPos);
        if (this.f_77312_.m_8055_(blockPos).m_204336_(BlockTags.f_13082_)) {
            return true;
        }
        if (this.isStandablePlatform(blockPos)) {
            return true;
        }
        return blockPathTypes != BlockPathTypes.OPEN && this.f_77313_.m_21439_(blockPathTypes) >= 0.0f;
    }

    public boolean m_77626_(Node node, Node neighbor) {
        int deltaY;
        if (node == null || neighbor == null) {
            return false;
        }
        if ((this.isLadderNode(node) || this.isLadderNode(neighbor)) && (deltaY = Math.abs(node.f_77272_ - neighbor.f_77272_)) > 1) {
            return this.hasLadderConnection(node, neighbor);
        }
        return super.m_77626_(node, neighbor);
    }

    private boolean isLadderNode(Node node) {
        if (node == null) {
            return false;
        }
        BlockPos pos = new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_);
        return this.f_77312_.m_8055_(pos).m_204336_(BlockTags.f_13082_);
    }

    private boolean shouldUseLadderPathfinding(BlockPos currentPos) {
        Direction[] directions;
        if (this.f_77312_.m_8055_(currentPos).m_204336_(BlockTags.f_13082_) || this.f_77312_.m_8055_(currentPos.m_7495_()).m_204336_(BlockTags.f_13082_) || this.f_77312_.m_8055_(currentPos.m_7494_()).m_204336_(BlockTags.f_13082_)) {
            return true;
        }
        for (Direction dir : directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos adjacentPos = currentPos.m_121945_(dir);
            if (this.f_77312_.m_8055_(adjacentPos).m_204336_(BlockTags.f_13082_) || this.f_77312_.m_8055_(adjacentPos.m_7495_()).m_204336_(BlockTags.f_13082_) || this.f_77312_.m_8055_(adjacentPos.m_7494_()).m_204336_(BlockTags.f_13082_)) {
                return true;
            }
            BlockPos farPos = currentPos.m_5484_(dir, 2);
            if (!this.f_77312_.m_8055_(farPos).m_204336_(BlockTags.f_13082_) && !this.f_77312_.m_8055_(farPos.m_7495_()).m_204336_(BlockTags.f_13082_) && !this.f_77312_.m_8055_(farPos.m_7494_()).m_204336_(BlockTags.f_13082_)) continue;
            return true;
        }
        return false;
    }

    private boolean hasLadderConnection(Node from, Node to) {
        if (from == null || to == null) {
            return false;
        }
        if (from.f_77271_ != to.f_77271_ || from.f_77273_ != to.f_77273_) {
            return false;
        }
        int minY = Math.min(from.f_77272_, to.f_77272_);
        int maxY = Math.max(from.f_77272_, to.f_77272_);
        for (int y = minY; y <= maxY; ++y) {
            BlockPos checkPos = new BlockPos(from.f_77271_, y, from.f_77273_);
            if (this.f_77312_.m_8055_(checkPos).m_204336_(BlockTags.f_13082_)) continue;
            return false;
        }
        return true;
    }

    public Node m_7171_() {
        BlockPos currentPos = this.f_77313_.m_20183_();
        if (this.f_77312_.m_8055_(currentPos).m_204336_(BlockTags.f_13082_) || this.f_77312_.m_8055_(currentPos.m_7495_()).m_204336_(BlockTags.f_13082_)) {
            if (this.m_262494_(currentPos)) {
                return this.m_230631_(currentPos);
            }
            BlockPos abovePos = currentPos.m_7494_();
            if (this.m_262494_(abovePos)) {
                return this.m_230631_(abovePos);
            }
            BlockPos belowPos = currentPos.m_7495_();
            if (this.m_262494_(belowPos)) {
                return this.m_230631_(belowPos);
            }
        }
        return super.m_7171_();
    }
}

