/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.utils;

import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import ydmsama.hundred_years_war.main.entity.utils.HorseRider;

public interface Chargeable {
    public boolean isCharging();

    default public void manageHorseChargeSpeed() {
        Chargeable chargeable = this;
        if (!(chargeable instanceof HorseRider)) {
            return;
        }
        HorseRider horseRider = (HorseRider)((Object)chargeable);
        Entity entity = horseRider.asLivingEntity().m_20202_();
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            AttributeInstance speedAttr = horse.m_21051_(Attributes.f_22279_);
            if (speedAttr == null) {
                return;
            }
            boolean shouldStop = this.isCharging() && horseRider.hasValidTarget();
            UUID modifierUUID = this.getChargeSpeedModifierUUID();
            AttributeModifier currentModifier = speedAttr.m_22111_(modifierUUID);
            if (shouldStop) {
                if (currentModifier == null) {
                    speedAttr.m_22118_(new AttributeModifier(modifierUUID, "Charge speed stop", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
                }
            } else if (currentModifier != null) {
                speedAttr.m_22120_(modifierUUID);
            }
        }
    }

    default public UUID getChargeSpeedModifierUUID() {
        return UUID.fromString("550e8400-e29b-41d4-a716-446655440010");
    }
}

