/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.utils;

import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public interface MultiSeatVehicle {
    public List<Seat> getAllSeats();

    public int getMaxPassengers();

    public Optional<Seat> assignSeat(Entity var1);

    public void releaseSeat(Entity var1);

    public Optional<Seat> getSeatForEntity(Entity var1);

    default public boolean canEntityMount(Entity entity) {
        if (this.getPassengerCount() >= this.getMaxPassengers()) {
            return false;
        }
        return this.assignSeat(entity).isPresent();
    }

    public int getPassengerCount();

    default public SeatType[] getPreferredSeatTypes(Entity entity) {
        if (entity instanceof Player) {
            return new SeatType[]{SeatType.PLAYER, SeatType.INTERNAL};
        }
        if (entity instanceof LivingEntity && this.isRangedUnit((LivingEntity)entity)) {
            return new SeatType[]{SeatType.RANGED, SeatType.INTERNAL};
        }
        return new SeatType[]{SeatType.INTERNAL};
    }

    default public boolean isRangedUnit(LivingEntity entity) {
        return entity instanceof RangedAttackMob;
    }

    public static enum SeatType {
        PLAYER,
        RANGED,
        INTERNAL;

    }

    public static class Seat {
        private final SeatType type;
        private final Vec3 position;
        private final boolean allowMultiple;
        private final SeatPose pose;
        private Entity occupant;

        public Seat(SeatType type, Vec3 position, boolean allowMultiple, SeatPose pose) {
            this.type = type;
            this.position = position;
            this.allowMultiple = allowMultiple;
            this.pose = pose;
        }

        public Seat(SeatType type, Vec3 position, boolean allowMultiple) {
            this(type, position, allowMultiple, SeatPose.SITTING);
        }

        public SeatType getType() {
            return this.type;
        }

        public Vec3 getPosition() {
            return this.position;
        }

        public boolean isAllowMultiple() {
            return this.allowMultiple;
        }

        public SeatPose getPose() {
            return this.pose;
        }

        public Entity getOccupant() {
            return this.occupant;
        }

        public void setOccupant(Entity entity) {
            this.occupant = entity;
        }

        public boolean isOccupied() {
            return this.occupant != null;
        }

        public boolean canAccept(Entity entity) {
            if (this.allowMultiple) {
                return true;
            }
            return !this.isOccupied();
        }
    }

    public static enum SeatPose {
        STANDING,
        SITTING;

    }
}

