/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.item;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;

public class BaseScrollItem<T extends LivingEntity>
extends Item {
    private int equipmentLevel = 1;
    private final Supplier<EntityType<T>> entityTypeSupplier;

    public BaseScrollItem(Item.Properties properties, Supplier<EntityType<T>> entityTypeSupplier, int equipmentLevel) {
        super(properties);
        this.entityTypeSupplier = entityTypeSupplier;
        this.equipmentLevel = equipmentLevel;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        String itemName = this.m_5671_(stack);
        String descriptionKey = itemName + ".description";
        MutableComponent description = Component.m_237115_((String)descriptionKey);
        if (!description.getString().equals(descriptionKey)) {
            if (world != null && world.f_46443_) {
                BaseScrollItem.addWrappedTooltip(tooltip, (Component)description);
            } else {
                tooltip.add((Component)description);
            }
        }
    }

    private static void addWrappedTooltip(List<Component> tooltip, Component component) {
        try {
            Class<?> helperClass = Class.forName("ydmsama.hundred_years_war.client.utils.TooltipHelper");
            Method method = helperClass.getMethod("addToTooltip", List.class, Component.class);
            method.invoke(null, tooltip, component);
        }
        catch (Exception e) {
            tooltip.add(component);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        BlockHitResult hitResult;
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (world.f_46443_) {
            player.m_21011_(hand, true);
        }
        if (!world.f_46443_ && (hitResult = BaseScrollItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE)).m_6662_() == HitResult.Type.BLOCK) {
            CompoundTag entityData = this.getEntityDataFromItem(stack);
            if (this.m_5812_(stack)) {
                LivingEntity entity = (LivingEntity)this.getEntityType().m_20615_(world);
                if (entity instanceof BaseCombatSupport) {
                    BaseCombatSupport baseCombatSupport = (BaseCombatSupport)entity;
                    entity.m_7378_(entityData);
                    boolean friendly = !player.m_7500_() || CreativeModeSettings.isSummonFriendly(player);
                    baseCombatSupport.m_30586_(friendly ? player.m_20148_() : null);
                    BlockPos spawnPos = this.getSafeSpawnPosition(world, hitResult.m_82425_(), player);
                    entity.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                    this.spawnParticles(world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                    world.m_7967_((Entity)entity);
                    baseCombatSupport.setHomePosition(spawnPos);
                    CreativeModeSettings.sendSummonFeedback(player);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
                }
            } else if (player.m_7500_() || player.m_150110_().f_35937_) {
                LivingEntity entity = (LivingEntity)this.getEntityType().m_20615_(world);
                if (entity instanceof BaseCombatSupport) {
                    BaseCombatSupport baseCombatSupport = (BaseCombatSupport)entity;
                    BlockPos blockPos = hitResult.m_82425_();
                    if (player.m_7500_() && CreativeModeSettings.isSummonFriendly(player)) {
                        baseCombatSupport.m_30586_(player.m_20148_());
                    } else {
                        baseCombatSupport.m_30586_(null);
                    }
                    baseCombatSupport.setEquipment(this.getEquipmentLevel());
                    BlockPos spawnPos = this.getSafeSpawnPosition(world, blockPos, player);
                    entity.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                    this.spawnParticles(world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                    world.m_7967_((Entity)entity);
                    baseCombatSupport.setHomePosition(spawnPos);
                    CreativeModeSettings.sendSummonFeedback(player);
                    return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
                }
            } else {
                LivingEntity entity = (LivingEntity)this.getEntityType().m_20615_(world);
                if (entity instanceof BaseCombatSupport) {
                    BaseCombatSupport baseCombatSupport = (BaseCombatSupport)entity;
                    BlockPos blockPos = hitResult.m_82425_();
                    baseCombatSupport.m_30586_(player.m_20148_());
                    baseCombatSupport.setEquipment(this.getEquipmentLevel());
                    BlockPos spawnPos = this.getSafeSpawnPosition(world, blockPos, player);
                    entity.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                    this.spawnParticles(world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                    world.m_7967_((Entity)entity);
                    baseCombatSupport.setHomePosition(spawnPos);
                    CreativeModeSettings.sendSummonFeedback(player);
                    stack.m_41774_(1);
                    return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void saveEntityDataToItem(ItemStack stack, CompoundTag entityData) {
        stack.m_41784_().m_128365_("EntityData", (Tag)entityData);
    }

    public CompoundTag getEntityDataFromItem(ItemStack stack) {
        return stack.m_41784_().m_128469_("EntityData");
    }

    public boolean m_5812_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("EntityData");
    }

    public int getEquipmentLevel() {
        return this.equipmentLevel;
    }

    public void setEquipmentLevel(int equipmentLevel) {
        this.equipmentLevel = equipmentLevel;
    }

    private void spawnParticles(Level world, double x, double y, double z) {
        int particleCount = 40;
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (world.f_46441_.m_188500_() - 0.5) * 1.0;
                double offsetY = world.f_46441_.m_188500_() * 0.5 + 0.5;
                double offsetZ = (world.f_46441_.m_188500_() - 0.5) * 1.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y + 0.5, z, 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    public EntityType<T> getEntityType() {
        return this.entityTypeSupplier.get();
    }

    private BlockPos getSafeSpawnPosition(Level world, BlockPos hitPos, Player player) {
        BlockPos spawnPos = hitPos.m_7494_();
        if (this.isSafePosition(world, spawnPos)) {
            return spawnPos;
        }
        double radians = Math.toRadians(player.m_146908_());
        int offsetX = (int)Math.round(Math.sin(radians));
        int offsetZ = (int)Math.round(-Math.cos(radians));
        for (int i = 1; i <= 3; ++i) {
            BlockPos testPos = hitPos.m_7918_(offsetX * i, 0, offsetZ * i);
            for (int y = 0; y <= 2; ++y) {
                BlockPos potentialPos = testPos.m_6630_(y);
                if (!this.isSafePosition(world, potentialPos)) continue;
                return potentialPos;
            }
        }
        return player.m_20183_();
    }

    private boolean isSafePosition(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60795_() && world.m_8055_(pos.m_7494_()).m_60795_();
    }
}

