/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.item;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.config.RecruitBalanceConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.recruitment.PlayerRecruitmentData;
import ydmsama.hundred_years_war.main.recruitment.RecruitmentConfigManager;
import ydmsama.hundred_years_war.main.recruitment.data.RecruitmentConfig;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;

public class ConquerorsStaffItem
extends Item {
    public ConquerorsStaffItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack stack) {
        return 20;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    @NotNull
    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entityLiving) {
        if (!(entityLiving instanceof Player)) {
            return stack;
        }
        Player player = (Player)entityLiving;
        if (!world.f_46443_) {
            this.spawnArmy(world, player);
        }
        return stack;
    }

    private void spawnArmy(Level world, Player player) {
        PlayerRecruitmentData.RecruitmentSelection selection = PlayerRecruitmentData.getPlayerSelection(player);
        RecruitmentConfig.ArmyLevelConfig armyConfig = RecruitmentConfigManager.getArmyLevelConfig(selection.getCategoryId(), selection.getUnitTypeId(), selection.getLevel());
        if (armyConfig == null) {
            player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.army_config_not_found"), true);
            return;
        }
        if (!RecruitmentConfigManager.canPlayerRecruit(player, selection.getCategoryId(), selection.getUnitTypeId(), selection.getLevel())) {
            int requiredExp;
            int playerExp = this.getTotalExperience(player);
            if (playerExp < (requiredExp = armyConfig.getExpCost())) {
                player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.not_enough_exp_detail", (Object[])new Object[]{requiredExp, playerExp}), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.cannot_recruit_army"), true);
            }
            return;
        }
        for (RecruitmentConfig.UnitEntry unitEntry : armyConfig.getUnits()) {
            int count = unitEntry.getCountRange().getRandomCount();
            ResourceLocation entityRL = new ResourceLocation(unitEntry.getEntityType());
            EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(entityRL);
            for (int i = 0; i < count; ++i) {
                Entity entity;
                Vec3 spawnPos = this.findSafeSpawnPosition(world, player.m_20183_(), 5, 5);
                if (spawnPos == null) {
                    spawnPos = player.m_20183_().m_252807_();
                }
                if (!((entity = entityType.m_20615_(world)) instanceof BaseCombatSupport)) continue;
                BaseCombatSupport baseCombatSupport = (BaseCombatSupport)entity;
                if (player.m_7500_()) {
                    if (CreativeModeSettings.isSummonFriendly(player)) {
                        baseCombatSupport.m_30586_(player.m_20148_());
                    } else {
                        baseCombatSupport.m_30586_(null);
                    }
                } else {
                    baseCombatSupport.m_30586_(player.m_20148_());
                }
                baseCombatSupport.setEquipment(unitEntry.getEquipmentLevel());
                baseCombatSupport.asLivingEntity().m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
                baseCombatSupport.setHomePosition(new BlockPos((int)spawnPos.f_82479_, (int)spawnPos.f_82480_, (int)spawnPos.f_82481_));
                if (entity instanceof BaseCombatEntity) {
                    BaseCombatEntity baseCombatEntity = (BaseCombatEntity)entity;
                    if (RecruitBalanceConfig.ENABLE_RECRUIT_BALANCE && !player.m_7500_() && !player.m_20310_(2)) {
                        baseCombatEntity.setSummonWeaknessTimer(RecruitBalanceConfig.SUMMON_DEBUFF_DURATION);
                        baseCombatEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, RecruitBalanceConfig.SUMMON_DEBUFF_DURATION, RecruitBalanceConfig.SLOWNESS_LEVEL - 1, false, true, true));
                        baseCombatEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, RecruitBalanceConfig.SUMMON_DEBUFF_DURATION, RecruitBalanceConfig.WEAKNESS_LEVEL - 1, false, true, true));
                    }
                }
                world.m_7967_((Entity)baseCombatSupport.asLivingEntity());
                this.spawnParticles(world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            }
        }
        this.removeExperience(player, armyConfig.getExpCost());
        player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.army_summoned", (Object[])new Object[]{Component.m_237115_((String)armyConfig.getTranslationKey())}), true);
        CreativeModeSettings.sendSummonFeedback(player);
    }

    private Vec3 findSafeSpawnPosition(Level world, BlockPos centerPos, int range, int heightLimit) {
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            BlockPos pos;
            int yOffset;
            int offsetX = random.nextInt(range * 2 + 1) - range;
            int offsetZ = random.nextInt(range * 2 + 1) - range;
            int newX = centerPos.m_123341_() + offsetX;
            int newZ = centerPos.m_123343_() + offsetZ;
            for (yOffset = 1; yOffset <= heightLimit; ++yOffset) {
                pos = new BlockPos(newX, centerPos.m_123342_() + yOffset, newZ);
                if (!this.isSafeSpawnLocation(world, pos)) continue;
                return new Vec3((double)newX + 0.5, (double)pos.m_123342_(), (double)newZ + 0.5);
            }
            for (yOffset = 0; yOffset <= heightLimit; ++yOffset) {
                pos = new BlockPos(newX, centerPos.m_123342_() - yOffset, newZ);
                if (!this.isSafeSpawnLocation(world, pos)) continue;
                return new Vec3((double)newX + 0.5, (double)pos.m_123342_(), (double)newZ + 0.5);
            }
        }
        return null;
    }

    private boolean isSafeSpawnLocation(Level world, BlockPos pos) {
        BlockState blockStateBelow = world.m_8055_(pos.m_7495_());
        if (!blockStateBelow.m_280296_()) {
            return false;
        }
        BlockState blockStateAtPos = world.m_8055_(pos);
        BlockState blockStateAbove = world.m_8055_(pos.m_7494_());
        boolean canPassThroughAtPos = blockStateAtPos.m_60795_() || this.canPassThroughBlock(blockStateAtPos);
        boolean canPassThroughAbove = blockStateAbove.m_60795_() || this.canPassThroughBlock(blockStateAbove);
        return canPassThroughAtPos && canPassThroughAbove;
    }

    private boolean canPassThroughBlock(BlockState blockState) {
        String blockName = blockState.m_60734_().toString();
        return blockName.contains("snow") && !blockState.m_280296_();
    }

    private void spawnParticles(Level world, double x, double y, double z) {
        int particleCount = 40;
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (world.f_46441_.m_188500_() - 0.5) * 1.0;
                double offsetY = world.f_46441_.m_188500_() * 0.5 + 0.5;
                double offsetZ = (world.f_46441_.m_188500_() - 0.5) * 1.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y + 0.5, z, 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    private int getTotalExperienceForLevel(int level) {
        if (level < 0) {
            return 0;
        }
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    private int getTotalExperience(Player player) {
        int currentExp = (int)(player.f_36080_ * (float)player.m_36323_()) + this.getTotalExperienceForLevel(player.f_36078_);
        return currentExp;
    }

    private void removeExperience(Player player, int amount) {
        int currentExp = (int)(player.f_36080_ * (float)player.m_36323_()) + this.getTotalExperienceForLevel(player.f_36078_);
        int newExp = Math.max(0, currentExp - amount);
        player.f_36078_ = 0;
        player.f_36080_ = 0.0f;
        player.m_6756_(newExp);
    }
}

