/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.item;

import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class TransportWorkstationItem
extends BlockItem {
    public TransportWorkstationItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("BlockEntityTag")) {
            CompoundTag blockEntityTag = tag.m_128469_("BlockEntityTag");
            if (level != null && level.f_46443_) {
                this.addDetailedTooltip(tooltip, blockEntityTag);
            } else {
                this.addBasicTooltip(tooltip, blockEntityTag);
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.hundred_years_war.transport_workstation.empty"));
        }
    }

    private void addBasicTooltip(List<Component> tooltip, CompoundTag blockEntityTag) {
        boolean hasData = blockEntityTag.m_128441_("TransportData");
        boolean hasItems = blockEntityTag.m_128441_("Items");
        if (hasData || hasItems) {
            ListTag routes;
            int routeCount;
            CompoundTag transportData;
            tooltip.add((Component)Component.m_237115_((String)"item.hundred_years_war.transport_workstation.has_data"));
            if (hasData && (transportData = blockEntityTag.m_128469_("TransportData")).m_128441_("Routes") && (routeCount = (routes = transportData.m_128437_("Routes", 10)).size()) > 0) {
                tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.transport_workstation.routes", (Object[])new Object[]{routeCount}));
            }
            if (hasItems) {
                ListTag items = blockEntityTag.m_128437_("Items", 10);
                int itemCount = 0;
                for (int i = 0; i < items.size(); ++i) {
                    CompoundTag itemTag = items.m_128728_(i);
                    if (!itemTag.m_128441_("Count")) continue;
                    itemCount += itemTag.m_128445_("Count");
                }
                if (itemCount > 0) {
                    tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.transport_workstation.items", (Object[])new Object[]{itemCount}));
                }
            }
        }
    }

    private void addDetailedTooltip(List<Component> tooltip, CompoundTag blockEntityTag) {
        ListTag routes;
        CompoundTag transportData;
        this.addBasicTooltip(tooltip, blockEntityTag);
        if (blockEntityTag.m_128441_("LastPos")) {
            CompoundTag lastPosTag = blockEntityTag.m_128469_("LastPos");
            int x = lastPosTag.m_128451_("x");
            int y = lastPosTag.m_128451_("y");
            int z = lastPosTag.m_128451_("z");
            TransportWorkstationItem.addWrappedTooltip(tooltip, (Component)Component.m_237110_((String)"item.hundred_years_war.transport_workstation.last_pos", (Object[])new Object[]{x, y, z}));
        }
        if (blockEntityTag.m_128441_("TransportData") && (transportData = blockEntityTag.m_128469_("TransportData")).m_128441_("Routes") && !(routes = transportData.m_128437_("Routes", 10)).isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"item.hundred_years_war.transport_workstation.route_preview"));
            int displayCount = Math.min(3, routes.size());
            for (int i = 0; i < displayCount; ++i) {
                CompoundTag route = routes.m_128728_(i);
                if (!route.m_128441_("TargetPos")) continue;
                long targetPosLong = route.m_128454_("TargetPos");
                BlockPos targetPos = BlockPos.m_122022_((long)targetPosLong);
                String mode = route.m_128461_("Mode");
                MutableComponent modeText = mode.equals("DEPOSIT") ? Component.m_237115_((String)"item.hundred_years_war.transport_workstation.deposit") : Component.m_237115_((String)"item.hundred_years_war.transport_workstation.withdraw");
                tooltip.add((Component)Component.m_237113_((String)("  \u00a77- [" + targetPos.m_123341_() + ", " + targetPos.m_123342_() + ", " + targetPos.m_123343_() + "] " + modeText.getString())));
            }
            if (routes.size() > 3) {
                tooltip.add((Component)Component.m_237113_((String)"  \u00a77..."));
            }
        }
    }

    private static void addWrappedTooltip(List<Component> tooltip, Component component) {
        try {
            Class<?> helperClass = Class.forName("ydmsama.hundred_years_war.client.utils.TooltipHelper");
            Method method = helperClass.getMethod("addToTooltip", List.class, Component.class);
            method.invoke(null, tooltip, component);
        }
        catch (Exception e) {
            tooltip.add(component);
        }
    }
}

