/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.mixins;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.projectile.RocketEntity;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

@Mixin(value={AbstractArrow.class})
public class AbstractArrowMixin {
    @ModifyVariable(method={"tick"}, at=@At(value="STORE"), ordinal=0)
    private float modifyAirResistance(float m) {
        AbstractArrow arrow = (AbstractArrow)this;
        if (arrow.m_19749_() instanceof BaseCombatEntity && arrow.m_19749_() instanceof RangedAttackMob || arrow instanceof RocketEntity) {
            return 1.0f;
        }
        return m;
    }

    @ModifyConstant(method={"tickDespawn"}, constant={@Constant(intValue=1200)})
    private int modifyDespawnTime(int original) {
        AbstractArrow arrow = (AbstractArrow)this;
        if (arrow.m_19749_() instanceof BaseCombatEntity && arrow.m_19749_() instanceof RangedAttackMob) {
            return 60;
        }
        return original;
    }

    @Inject(method={"canHitEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void canHitEntity(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity petOwner;
        TamableAnimal tamable;
        Entity owner = ((AbstractArrow)this).m_19749_();
        if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_() && (petOwner = tamable.m_269323_()) != null) {
            if (owner instanceof BaseCombatEntity) {
                if (!ServerRelationHelper.isEnemyRelation(owner, (Entity)petOwner)) {
                    cir.setReturnValue((Object)false);
                    return;
                }
            } else if (owner instanceof Player && (ServerRelationHelper.isFriendlyRelation(owner, (Entity)petOwner) || ServerRelationHelper.hasControlOver((Player)owner, (Entity)petOwner) || owner == petOwner)) {
                cir.setReturnValue((Object)false);
                return;
            }
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            for (Entity passenger : horse.m_20197_()) {
                if (!(passenger instanceof BaseCombatEntity) && !(passenger instanceof Player)) continue;
                if (owner instanceof BaseCombatEntity) {
                    if (ServerRelationHelper.isEnemyRelation(owner, passenger) || ServerRelationHelper.isNeutralRelation(owner, passenger)) continue;
                    cir.setReturnValue((Object)false);
                    return;
                }
                if (!(owner instanceof Player) || !ServerRelationHelper.isFriendlyRelation(owner, passenger) && !ServerRelationHelper.hasControlOver((Player)owner, passenger)) continue;
                cir.setReturnValue((Object)false);
                return;
            }
        }
        if (owner instanceof BaseCombatEntity) {
            if ((entity instanceof BaseCombatEntity || entity instanceof Player) && !ServerRelationHelper.isEnemyRelation(owner, entity) && !ServerRelationHelper.isNeutralRelation(owner, entity)) {
                cir.setReturnValue((Object)false);
            }
        } else if (owner instanceof Player && (entity instanceof BaseCombatEntity || entity instanceof Player) && (ServerRelationHelper.isFriendlyRelation(owner, entity) || ServerRelationHelper.hasControlOver((Player)owner, entity))) {
            cir.setReturnValue((Object)false);
        }
    }
}

