/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.mixins;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.utils.HorseRider;

@Mixin(value={AbstractHorse.class})
public class AbstractHorseMixin {
    private static final UUID RIDER_KNOCKBACK_RESISTANCE_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440011");
    private static final UUID RIDER_SPEED_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440012");
    private static final UUID FORMATION_SPEED_MODIFIER_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440001");
    @Unique
    private float hyw$originalMaxHealth = -1.0f;
    @Unique
    private float hyw$originalHealth = -1.0f;
    @Unique
    private boolean hyw$hadPassengerLastTick = false;

    @Inject(method={"getControllingPassenger"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetControllingPassenger(CallbackInfoReturnable<LivingEntity> cir) {
        AbstractHorse horse = (AbstractHorse)this;
        Entity firstPassenger = horse.m_146895_();
        if (firstPassenger instanceof BaseCombatEntity) {
            BaseCombatEntity baseCombatEntity = (BaseCombatEntity)firstPassenger;
            if (horse.m_30614_() && horse.m_6254_()) {
                cir.setReturnValue((Object)baseCombatEntity);
            } else {
                cir.setReturnValue(null);
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHurt(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        AbstractHorse horse = (AbstractHorse)this;
        if (horse.m_9236_().f_46443_) {
            return;
        }
        Entity entity = horse.m_146895_();
        if (entity instanceof BaseCombatEntity) {
            BaseCombatEntity rider = (BaseCombatEntity)entity;
            if (amount > 0.0f) {
                rider.m_6469_(damageSource, amount);
                boolean result = horse.m_6469_(damageSource, 0.0f);
                cir.setReturnValue((Object)result);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        Entity entity;
        boolean hasPassengerNow;
        AbstractHorse horse = (AbstractHorse)this;
        if (horse.m_9236_().f_46443_) {
            return;
        }
        boolean bl = hasPassengerNow = horse.m_146895_() != null;
        if (!hasPassengerNow) {
            if (this.hyw$hadPassengerLastTick && this.hyw$originalMaxHealth > 0.0f && !horse.m_21224_() && horse.m_21223_() > 0.0f) {
                AttributeInstance maxHealthAttr = horse.m_21051_(Attributes.f_22276_);
                if (maxHealthAttr != null) {
                    maxHealthAttr.m_22100_((double)this.hyw$originalMaxHealth);
                }
                horse.m_21153_(Math.min(this.hyw$originalHealth, this.hyw$originalMaxHealth));
            }
            this.hyw$originalMaxHealth = horse.m_21233_();
            this.hyw$originalHealth = horse.m_21223_();
        }
        if ((entity = horse.m_146895_()) instanceof BaseCombatEntity) {
            AttributeModifier currentModifier;
            BaseCombatEntity rider = (BaseCombatEntity)entity;
            knockbackResistanceAttr = horse.m_21051_(Attributes.f_22278_);
            if (knockbackResistanceAttr != null && (currentModifier = knockbackResistanceAttr.m_22111_(RIDER_KNOCKBACK_RESISTANCE_UUID)) == null) {
                knockbackResistanceAttr.m_22118_(new AttributeModifier(RIDER_KNOCKBACK_RESISTANCE_UUID, "BaseCombatEntity rider knockback resistance", 0.8, AttributeModifier.Operation.ADDITION));
            }
            if (rider instanceof HorseRider) {
                HorseRider horseRider = (HorseRider)((Object)rider);
                AttributeInstance speedAttr = horse.m_21051_(Attributes.f_22279_);
                if (speedAttr != null) {
                    AttributeModifier formationModifier = speedAttr.m_22111_(FORMATION_SPEED_MODIFIER_UUID);
                    if (formationModifier == null) {
                        double riderSpeed = horseRider.getHorseSpeed();
                        AttributeModifier currentSpeedModifier = speedAttr.m_22111_(RIDER_SPEED_UUID);
                        double speedDifference = riderSpeed - speedAttr.m_22115_();
                        if (currentSpeedModifier == null) {
                            speedAttr.m_22118_(new AttributeModifier(RIDER_SPEED_UUID, "BaseCombatEntity rider speed", speedDifference, AttributeModifier.Operation.ADDITION));
                        } else if (Math.abs(currentSpeedModifier.m_22218_() - speedDifference) > 0.001) {
                            speedAttr.m_22120_(RIDER_SPEED_UUID);
                            speedAttr.m_22118_(new AttributeModifier(RIDER_SPEED_UUID, "BaseCombatEntity rider speed", speedDifference, AttributeModifier.Operation.ADDITION));
                        }
                    } else {
                        AttributeModifier currentSpeedModifier = speedAttr.m_22111_(RIDER_SPEED_UUID);
                        if (currentSpeedModifier != null) {
                            speedAttr.m_22120_(RIDER_SPEED_UUID);
                        }
                    }
                }
            }
        } else {
            AttributeModifier currentSpeedModifier;
            AttributeInstance speedAttr;
            AttributeModifier currentModifier;
            knockbackResistanceAttr = horse.m_21051_(Attributes.f_22278_);
            if (knockbackResistanceAttr != null && (currentModifier = knockbackResistanceAttr.m_22111_(RIDER_KNOCKBACK_RESISTANCE_UUID)) != null) {
                knockbackResistanceAttr.m_22120_(RIDER_KNOCKBACK_RESISTANCE_UUID);
            }
            if ((speedAttr = horse.m_21051_(Attributes.f_22279_)) != null && (currentSpeedModifier = speedAttr.m_22111_(RIDER_SPEED_UUID)) != null) {
                speedAttr.m_22120_(RIDER_SPEED_UUID);
            }
        }
        this.hyw$hadPassengerLastTick = hasPassengerNow;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void onAddAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        compound.m_128350_("hyw_originalMaxHealth", this.hyw$originalMaxHealth);
        compound.m_128350_("hyw_originalHealth", this.hyw$originalHealth);
        compound.m_128379_("hyw_hadPassengerLastTick", this.hyw$hadPassengerLastTick);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void onReadAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        if (compound.m_128441_("hyw_originalMaxHealth")) {
            this.hyw$originalMaxHealth = compound.m_128457_("hyw_originalMaxHealth");
        }
        if (compound.m_128441_("hyw_originalHealth")) {
            this.hyw$originalHealth = compound.m_128457_("hyw_originalHealth");
        }
        if (compound.m_128441_("hyw_hadPassengerLastTick")) {
            this.hyw$hadPassengerLastTick = compound.m_128471_("hyw_hadPassengerLastTick");
        }
    }
}

