/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import ydmsama.hundred_years_war.main.blocks.workstation.BreedingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.BreedingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.FarmingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.FarmingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.LumberWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.LumberWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.MiningWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.MiningWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.network.WorkstationOpenRequest;
import ydmsama.hundred_years_war.main.network.packets.BombardPositionPacket;
import ydmsama.hundred_years_war.main.network.packets.BreedingWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.BuildCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.ClearFollowTargetPacket;
import ydmsama.hundred_years_war.main.network.packets.ClearSelectionPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffAddEntityPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffAttackPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffFollowPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffMovePacket;
import ydmsama.hundred_years_war.main.network.packets.CraftingRecipeUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.CreativeSettingsSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.CreativeSettingsUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.FarmingWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.FishingWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.FollowTargetPacket;
import ydmsama.hundred_years_war.main.network.packets.FreecamTogglePacket;
import ydmsama.hundred_years_war.main.network.packets.LumberWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.MiningWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.MoveAttackCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.MoveCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenCraftingInventoryPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenCraftingRecipePacket;
import ydmsama.hundred_years_war.main.network.packets.OpenManualPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenWorkstationAckPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenWorkstationSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointPacket;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointsPacket;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointsRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentConfigUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentDataRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentDataResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.RelationRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RelationResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.RelationSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.RelationUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.RequestTemplateSizePacket;
import ydmsama.hundred_years_war.main.network.packets.SelectionPacket;
import ydmsama.hundred_years_war.main.network.packets.SiegeModeTogglePacket;
import ydmsama.hundred_years_war.main.network.packets.SquadCreatePacket;
import ydmsama.hundred_years_war.main.network.packets.SquadPacket;
import ydmsama.hundred_years_war.main.network.packets.SquadSelectPacket;
import ydmsama.hundred_years_war.main.network.packets.StructureSizePacket;
import ydmsama.hundred_years_war.main.network.packets.TargetUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamApplicationsRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamApplicationsResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamCreateRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamCreateResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamJoinRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamLeaveRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamListRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamListResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamManageRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.TransportActionPacket;
import ydmsama.hundred_years_war.main.network.packets.TransportDataUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.UnbindTransportOrderPacket;
import ydmsama.hundred_years_war.main.network.packets.UnloadPassengersPacket;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;
import ydmsama.hundred_years_war.main.utils.ServerManager;

public class ServerPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("hundred_years_war", "main"), () -> "1", "1"::equals, "1"::equals);
    private static final Map<UUID, WorkstationOpenRequest> pendingRequests = new ConcurrentHashMap<UUID, WorkstationOpenRequest>();
    private static final ScheduledExecutorService cleanupExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "WorkstationRequestCleanup");
        t.setDaemon(true);
        return t;
    });
    private static int packetId = 0;

    public static void register() {
        INSTANCE.registerMessage(packetId++, SelectionPacket.class, SelectionPacket::encode, SelectionPacket::decode, SelectionPacket::handle);
        INSTANCE.registerMessage(packetId++, CommandPacket.class, CommandPacket::encode, CommandPacket::decode, CommandPacket::handle);
        INSTANCE.registerMessage(packetId++, MoveCommandPacket.class, MoveCommandPacket::encode, MoveCommandPacket::decode, MoveCommandPacket::handle);
        INSTANCE.registerMessage(packetId++, TargetUpdatePacket.class, TargetUpdatePacket::encode, TargetUpdatePacket::decode, TargetUpdatePacket::handle);
        INSTANCE.registerMessage(packetId++, MoveAttackCommandPacket.class, MoveAttackCommandPacket::encode, MoveAttackCommandPacket::decode, MoveAttackCommandPacket::handle);
        INSTANCE.registerMessage(packetId++, BuildCommandPacket.class, BuildCommandPacket::encode, BuildCommandPacket::decode, BuildCommandPacket::handle);
        INSTANCE.registerMessage(packetId++, PatrolPointPacket.class, PatrolPointPacket::encode, PatrolPointPacket::decode, PatrolPointPacket::handle);
        INSTANCE.registerMessage(packetId++, FollowTargetPacket.class, FollowTargetPacket::encode, FollowTargetPacket::decode, FollowTargetPacket::handle);
        INSTANCE.registerMessage(packetId++, PatrolPointsRequestPacket.class, PatrolPointsRequestPacket::encode, PatrolPointsRequestPacket::decode, PatrolPointsRequestPacket::handle);
        INSTANCE.registerMessage(packetId++, PatrolPointsPacket.class, PatrolPointsPacket::encode, PatrolPointsPacket::decode, PatrolPointsPacket::handle);
        INSTANCE.registerMessage(packetId++, SquadPacket.class, SquadPacket::encode, SquadPacket::decode, SquadPacket::handle);
        INSTANCE.registerMessage(packetId++, SquadCreatePacket.class, SquadCreatePacket::encode, SquadCreatePacket::decode, SquadCreatePacket::handle);
        INSTANCE.registerMessage(packetId++, SquadSelectPacket.class, SquadSelectPacket::encode, SquadSelectPacket::decode, SquadSelectPacket::handle);
        INSTANCE.registerMessage(packetId++, StructureSizePacket.class, StructureSizePacket::encode, StructureSizePacket::decode, StructureSizePacket::handle);
        INSTANCE.registerMessage(packetId++, RequestTemplateSizePacket.class, RequestTemplateSizePacket::encode, RequestTemplateSizePacket::decode, RequestTemplateSizePacket::handle);
        INSTANCE.registerMessage(packetId++, CommandStaffAddEntityPacket.class, CommandStaffAddEntityPacket::encode, CommandStaffAddEntityPacket::decode, CommandStaffAddEntityPacket::handle);
        INSTANCE.registerMessage(packetId++, CommandStaffMovePacket.class, CommandStaffMovePacket::encode, CommandStaffMovePacket::decode, CommandStaffMovePacket::handle);
        INSTANCE.registerMessage(packetId++, CommandStaffFollowPacket.class, CommandStaffFollowPacket::encode, CommandStaffFollowPacket::decode, CommandStaffFollowPacket::handle);
        INSTANCE.registerMessage(packetId++, CommandStaffAttackPacket.class, CommandStaffAttackPacket::encode, CommandStaffAttackPacket::decode, CommandStaffAttackPacket::handle);
        INSTANCE.registerMessage(packetId++, TeamInfoResponsePacket.class, TeamInfoResponsePacket::encode, TeamInfoResponsePacket::decode, TeamInfoResponsePacket::handle);
        INSTANCE.registerMessage(packetId++, TeamJoinRequestPacket.class, TeamJoinRequestPacket::encode, TeamJoinRequestPacket::decode, TeamJoinRequestPacket::handle);
        INSTANCE.registerMessage(packetId++, TeamLeaveRequestPacket.class, TeamLeaveRequestPacket::encode, TeamLeaveRequestPacket::decode, TeamLeaveRequestPacket::handle);
        INSTANCE.registerMessage(packetId++, TeamListRequestPacket.class, TeamListRequestPacket::encode, TeamListRequestPacket::decode, TeamListRequestPacket::handle);
        INSTANCE.registerMessage(packetId++, TeamListResponsePacket.class, TeamListResponsePacket::encode, TeamListResponsePacket::decode, TeamListResponsePacket::handle);
        INSTANCE.registerMessage(packetId++, BombardPositionPacket.class, BombardPositionPacket::encode, BombardPositionPacket::decode, BombardPositionPacket::handle);
        INSTANCE.registerMessage(packetId++, RelationRequestPacket.class, RelationRequestPacket::encode, RelationRequestPacket::decode, RelationRequestPacket::handle);
        INSTANCE.registerMessage(packetId++, RelationResponsePacket.class, RelationResponsePacket::encode, RelationResponsePacket::decode, RelationResponsePacket::handle);
        INSTANCE.registerMessage(packetId++, RelationSyncPacket.class, RelationSyncPacket::encode, RelationSyncPacket::decode, RelationSyncPacket::handle);
        INSTANCE.registerMessage(packetId++, RelationUpdatePacket.class, RelationUpdatePacket::encode, RelationUpdatePacket::decode, RelationUpdatePacket::handle);
        INSTANCE.registerMessage(packetId++, TeamApplicationsRequestPacket.class, TeamApplicationsRequestPacket::encode, TeamApplicationsRequestPacket::decode, TeamApplicationsRequestPacket::handle);
        INSTANCE.registerMessage(packetId++, TeamApplicationsResponsePacket.class, TeamApplicationsResponsePacket::encode, TeamApplicationsResponsePacket::decode, TeamApplicationsResponsePacket::handle);
        INSTANCE.registerMessage(packetId++, TeamCreateRequestPacket.class, TeamCreateRequestPacket::encode, TeamCreateRequestPacket::decode, TeamCreateRequestPacket::handle);
        INSTANCE.registerMessage(packetId++, TeamCreateResponsePacket.class, TeamCreateResponsePacket::encode, TeamCreateResponsePacket::decode, TeamCreateResponsePacket::handle);
        INSTANCE.registerMessage(packetId++, TeamInfoRequestPacket.class, TeamInfoRequestPacket::encode, TeamInfoRequestPacket::decode, TeamInfoRequestPacket::handle);
        INSTANCE.registerMessage(packetId++, TeamManageRequestPacket.class, TeamManageRequestPacket::encode, TeamManageRequestPacket::decode, TeamManageRequestPacket::handle);
        INSTANCE.registerMessage(packetId++, TeamMembersRequestPacket.class, TeamMembersRequestPacket::encode, TeamMembersRequestPacket::decode, TeamMembersRequestPacket::handle);
        INSTANCE.registerMessage(packetId++, TeamMembersResponsePacket.class, TeamMembersResponsePacket::encode, TeamMembersResponsePacket::decode, TeamMembersResponsePacket::handle);
        INSTANCE.registerMessage(packetId++, TeamRelationRequestPacket.class, TeamRelationRequestPacket::encode, TeamRelationRequestPacket::decode, TeamRelationRequestPacket::handle);
        INSTANCE.registerMessage(packetId++, TeamRelationResponsePacket.class, TeamRelationResponsePacket::encode, TeamRelationResponsePacket::decode, TeamRelationResponsePacket::handle);
        INSTANCE.registerMessage(packetId++, TeamRelationUpdatePacket.class, TeamRelationUpdatePacket::encode, TeamRelationUpdatePacket::decode, TeamRelationUpdatePacket::handle);
        INSTANCE.registerMessage(packetId++, SiegeModeTogglePacket.class, SiegeModeTogglePacket::encode, SiegeModeTogglePacket::decode, SiegeModeTogglePacket::handle);
        INSTANCE.registerMessage(packetId++, OpenManualPacket.class, OpenManualPacket::encode, OpenManualPacket::decode, OpenManualPacket::handle);
        INSTANCE.registerMessage(packetId++, RecruitmentDataRequestPacket.class, RecruitmentDataRequestPacket::encode, RecruitmentDataRequestPacket::decode, RecruitmentDataRequestPacket::handle);
        INSTANCE.registerMessage(packetId++, RecruitmentDataResponsePacket.class, RecruitmentDataResponsePacket::encode, RecruitmentDataResponsePacket::decode, RecruitmentDataResponsePacket::handle);
        INSTANCE.registerMessage(packetId++, RecruitmentConfigUpdatePacket.class, RecruitmentConfigUpdatePacket::encode, RecruitmentConfigUpdatePacket::decode, RecruitmentConfigUpdatePacket::handle);
        INSTANCE.registerMessage(packetId++, CreativeSettingsUpdatePacket.class, CreativeSettingsUpdatePacket::encode, CreativeSettingsUpdatePacket::decode, CreativeSettingsUpdatePacket::handle);
        INSTANCE.registerMessage(packetId++, CreativeSettingsSyncPacket.class, CreativeSettingsSyncPacket::encode, CreativeSettingsSyncPacket::decode, CreativeSettingsSyncPacket::handle);
        INSTANCE.registerMessage(packetId++, FreecamTogglePacket.class, FreecamTogglePacket::encode, FreecamTogglePacket::decode, FreecamTogglePacket::handle);
        INSTANCE.registerMessage(packetId++, ClearFollowTargetPacket.class, ClearFollowTargetPacket::encode, ClearFollowTargetPacket::decode, ClearFollowTargetPacket::handle);
        INSTANCE.registerMessage(packetId++, ClearSelectionPacket.class, ClearSelectionPacket::encode, ClearSelectionPacket::decode, ClearSelectionPacket::handle);
        INSTANCE.registerMessage(packetId++, UnloadPassengersPacket.class, UnloadPassengersPacket::encode, UnloadPassengersPacket::decode, UnloadPassengersPacket::handle);
        INSTANCE.registerMessage(packetId++, TransportActionPacket.class, TransportActionPacket::encode, TransportActionPacket::decode, TransportActionPacket::handle);
        INSTANCE.registerMessage(packetId++, LumberWorkstationRangePacket.class, LumberWorkstationRangePacket::encode, LumberWorkstationRangePacket::decode, LumberWorkstationRangePacket::handle);
        INSTANCE.registerMessage(packetId++, FarmingWorkstationRangePacket.class, FarmingWorkstationRangePacket::encode, FarmingWorkstationRangePacket::decode, FarmingWorkstationRangePacket::handle);
        INSTANCE.registerMessage(packetId++, MiningWorkstationRangePacket.class, MiningWorkstationRangePacket::encode, MiningWorkstationRangePacket::decode, MiningWorkstationRangePacket::handle);
        INSTANCE.registerMessage(packetId++, BreedingWorkstationRangePacket.class, BreedingWorkstationRangePacket::encode, BreedingWorkstationRangePacket::decode, BreedingWorkstationRangePacket::handle);
        INSTANCE.registerMessage(packetId++, FishingWorkstationRangePacket.class, FishingWorkstationRangePacket::encode, FishingWorkstationRangePacket::decode, FishingWorkstationRangePacket::handle);
        INSTANCE.registerMessage(packetId++, CraftingRecipeUpdatePacket.class, CraftingRecipeUpdatePacket::encode, CraftingRecipeUpdatePacket::decode, CraftingRecipeUpdatePacket::handle);
        INSTANCE.registerMessage(packetId++, TransportDataUpdatePacket.class, TransportDataUpdatePacket::encode, TransportDataUpdatePacket::decode, TransportDataUpdatePacket::handle);
        INSTANCE.registerMessage(packetId++, UnbindTransportOrderPacket.class, UnbindTransportOrderPacket::encode, UnbindTransportOrderPacket::decode, UnbindTransportOrderPacket::handle);
        INSTANCE.registerMessage(packetId++, OpenCraftingInventoryPacket.class, OpenCraftingInventoryPacket::encode, OpenCraftingInventoryPacket::decode, OpenCraftingInventoryPacket::handle);
        INSTANCE.registerMessage(packetId++, OpenCraftingRecipePacket.class, OpenCraftingRecipePacket::encode, OpenCraftingRecipePacket::decode, OpenCraftingRecipePacket::handle);
        INSTANCE.registerMessage(packetId++, OpenWorkstationSyncPacket.class, OpenWorkstationSyncPacket::encode, OpenWorkstationSyncPacket::decode, OpenWorkstationSyncPacket::handle);
        INSTANCE.registerMessage(packetId++, OpenWorkstationAckPacket.class, OpenWorkstationAckPacket::encode, OpenWorkstationAckPacket::decode, OpenWorkstationAckPacket::handle);
    }

    public static <T> void sendToPlayer(T packet, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    public static <T> void sendToServer(T packet) {
        INSTANCE.sendToServer(packet);
    }

    public static void sendCreativeSettingsSync(ServerPlayer player) {
        CreativeModeSettings.Settings settings = CreativeModeSettings.getSettings((Player)player);
        CreativeSettingsSyncPacket packet = new CreativeSettingsSyncPacket(settings.isSummonFriendly(), settings.isControlAllUnits());
        ServerPacketHandler.sendToPlayer(packet, player);
    }

    public static void sendClearFollowTargetToAll(UUID entityUUID) {
        MinecraftServer server = ServerManager.getServer();
        if (server != null) {
            ClearFollowTargetPacket packet = new ClearFollowTargetPacket(entityUUID);
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                ServerPacketHandler.sendToPlayer(packet, player);
            }
        }
    }

    public static void sendClearSelectionToAll(UUID entityUUID) {
        MinecraftServer server = ServerManager.getServer();
        if (server != null) {
            ClearSelectionPacket packet = new ClearSelectionPacket(entityUUID);
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                ServerPacketHandler.sendToPlayer(packet, player);
            }
        }
    }

    public static void sendOpenWorkstationSync(ServerPlayer player, BlockPos pos, OpenWorkstationSyncPacket.WorkstationType type) {
        WorkstationOpenRequest request = new WorkstationOpenRequest(player, pos, type);
        pendingRequests.put(request.getRequestId(), request);
        OpenWorkstationSyncPacket packet = new OpenWorkstationSyncPacket(request.getRequestId(), pos, type);
        ServerPacketHandler.sendToPlayer(packet, player);
        cleanupExecutor.schedule(() -> {
            WorkstationOpenRequest req = pendingRequests.get(request.getRequestId());
            if (req != null && req.isExpired()) {
                pendingRequests.remove(request.getRequestId());
            }
        }, 10L, TimeUnit.SECONDS);
    }

    public static void handleWorkstationAck(OpenWorkstationAckPacket packet) {
        UUID requestId = packet.getRequestId();
        WorkstationOpenRequest request = pendingRequests.remove(requestId);
        if (request == null || request.isExpired()) {
            return;
        }
        ServerPacketHandler.openWorkstationMenu(request.getPlayer(), request.getPos(), request.getType());
    }

    private static void openWorkstationMenu(ServerPlayer player, BlockPos pos, OpenWorkstationSyncPacket.WorkstationType type) {
        Level level = player.m_9236_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            return;
        }
        MenuProvider menuProvider = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case OpenWorkstationSyncPacket.WorkstationType.FARMING -> ServerPacketHandler.createMenuProvider("hundred_years_war.farming_workstation", (syncId, inventory, p) -> new FarmingWorkstationScreenHandler(syncId, inventory, (FarmingWorkstationBlockEntity)blockEntity));
            case OpenWorkstationSyncPacket.WorkstationType.MINING -> ServerPacketHandler.createMenuProvider("hundred_years_war.mining_workstation", (syncId, inventory, p) -> new MiningWorkstationScreenHandler(syncId, inventory, (MiningWorkstationBlockEntity)blockEntity));
            case OpenWorkstationSyncPacket.WorkstationType.TRANSPORT -> ServerPacketHandler.createMenuProvider("hundred_years_war.transport_workstation", (syncId, inventory, p) -> new TransportWorkstationScreenHandler(syncId, inventory, (TransportWorkstationBlockEntity)blockEntity));
            case OpenWorkstationSyncPacket.WorkstationType.FISHING -> ServerPacketHandler.createMenuProvider("hundred_years_war.fishing_workstation", (syncId, inventory, p) -> new FishingWorkstationScreenHandler(syncId, inventory, (FishingWorkstationBlockEntity)blockEntity));
            case OpenWorkstationSyncPacket.WorkstationType.LUMBER -> ServerPacketHandler.createMenuProvider("hundred_years_war.lumber_workstation", (syncId, inventory, p) -> new LumberWorkstationScreenHandler(syncId, inventory, (LumberWorkstationBlockEntity)blockEntity));
            case OpenWorkstationSyncPacket.WorkstationType.CRAFTING -> ServerPacketHandler.createMenuProvider("hundred_years_war.crafting_workstation", (syncId, inventory, p) -> new CraftingWorkstationScreenHandler(syncId, inventory, (CraftingWorkstationBlockEntity)blockEntity));
            case OpenWorkstationSyncPacket.WorkstationType.BREEDING -> ServerPacketHandler.createMenuProvider("hundred_years_war.breeding_workstation", (syncId, inventory, p) -> new BreedingWorkstationScreenHandler(syncId, inventory, (BreedingWorkstationBlockEntity)blockEntity));
        };
        player.m_5893_(menuProvider);
    }

    private static MenuProvider createMenuProvider(final String translationKey, final MenuFactory factory) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)translationKey);
            }

            public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
                return factory.create(syncId, playerInventory, player);
            }
        };
    }

    @FunctionalInterface
    private static interface MenuFactory {
        public AbstractContainerMenu create(int var1, Inventory var2, Player var3);
    }
}

