/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import ydmsama.hundred_years_war.main.network.packets.OpenWorkstationSyncPacket;

public class WorkstationOpenRequest {
    private final UUID requestId = UUID.randomUUID();
    private final ServerPlayer player;
    private final BlockPos pos;
    private final OpenWorkstationSyncPacket.WorkstationType type;
    private final long timestamp;

    public WorkstationOpenRequest(ServerPlayer player, BlockPos pos, OpenWorkstationSyncPacket.WorkstationType type) {
        this.player = player;
        this.pos = pos;
        this.type = type;
        this.timestamp = System.currentTimeMillis();
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public OpenWorkstationSyncPacket.WorkstationType getType() {
        return this.type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.timestamp > 5000L;
    }
}

