/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class BombardPositionPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "bombard_position");
    private final Vec3 position;
    private final boolean cancel;
    private final boolean queueMode;

    public BombardPositionPacket(Vec3 position, boolean cancel, boolean queueMode) {
        this.position = position;
        this.cancel = cancel;
        this.queueMode = queueMode;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public boolean isQueueMode() {
        return this.queueMode;
    }

    public static void encode(BombardPositionPacket packet, FriendlyByteBuf buf) {
        if (packet.position != null) {
            buf.writeDouble(packet.position.f_82479_);
            buf.writeDouble(packet.position.f_82480_);
            buf.writeDouble(packet.position.f_82481_);
        } else {
            buf.writeDouble(0.0);
            buf.writeDouble(0.0);
            buf.writeDouble(0.0);
        }
        buf.writeBoolean(packet.cancel);
        buf.writeBoolean(packet.queueMode);
    }

    public static BombardPositionPacket decode(FriendlyByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        boolean cancel = buf.readBoolean();
        boolean queueMode = buf.readBoolean();
        Vec3 position = cancel ? null : new Vec3(x, y, z);
        return new BombardPositionPacket(position, cancel, queueMode);
    }

    public static void handle(BombardPositionPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                BombardPositionPacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    private static void handlePacket(ServerPlayer player, BombardPositionPacket packet) {
        SelectionSystem.Selection selection = SelectionSystem.getSelection(player);
        if (selection != null) {
            List<UUID> entityUUIDs = selection.getEntityUUIDs();
            for (UUID uuid : entityUUIDs) {
                BaseCombatEntity combatEntity;
                Entity entity = SelectionSystem.getEntityByUUIDWithinRadius(player, uuid, 200);
                if (!(entity instanceof PositionAttackable)) continue;
                PositionAttackable positionAttackable = (PositionAttackable)entity;
                if (!packet.queueMode && entity instanceof BaseCombatEntity) {
                    combatEntity = (BaseCombatEntity)entity;
                    combatEntity.clearCommandedGoals();
                }
                if (entity instanceof BaseCombatEntity) {
                    combatEntity = (BaseCombatEntity)entity;
                    combatEntity.clearPatrolPoints();
                }
                if (packet.isCancel()) {
                    positionAttackable.setPositionTarget(null);
                    continue;
                }
                positionAttackable.setPositionTarget(packet.getPosition());
            }
        }
    }
}

