/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.blocks.workstation.BreedingWorkstationBlockEntity;

public class BreedingWorkstationRangePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "ranch_workstation_range");
    private final BlockPos pos;
    private final int rangeLeft;
    private final int rangeRight;
    private final int rangeUp;
    private final boolean showRange;
    private final int maxAnimals;

    public BreedingWorkstationRangePacket(BlockPos pos, int rangeLeft, int rangeRight, int rangeUp, boolean showRange, int maxAnimals) {
        this.pos = pos;
        this.rangeLeft = rangeLeft;
        this.rangeRight = rangeRight;
        this.rangeUp = rangeUp;
        this.showRange = showRange;
        this.maxAnimals = maxAnimals;
    }

    public static void encode(BreedingWorkstationRangePacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.writeInt(packet.rangeLeft);
        buf.writeInt(packet.rangeRight);
        buf.writeInt(packet.rangeUp);
        buf.writeBoolean(packet.showRange);
        buf.writeInt(packet.maxAnimals);
    }

    public static BreedingWorkstationRangePacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int rangeLeft = buf.readInt();
        int rangeRight = buf.readInt();
        int rangeUp = buf.readInt();
        boolean showRange = buf.readBoolean();
        int maxAnimals = buf.readInt();
        return new BreedingWorkstationRangePacket(pos, rangeLeft, rangeRight, rangeUp, showRange, maxAnimals);
    }

    public static void handle(BreedingWorkstationRangePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                BreedingWorkstationRangePacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, BreedingWorkstationRangePacket packet) {
        player.f_8924_.execute(() -> {
            if (!player.m_36326_()) {
                return;
            }
            double distanceSq = player.m_20275_((double)packet.pos.m_123341_() + 0.5, (double)packet.pos.m_123342_() + 0.5, (double)packet.pos.m_123343_() + 0.5);
            if (distanceSq > 64.0) {
                return;
            }
            BlockEntity blockEntity = player.m_9236_().m_7702_(packet.pos);
            if (blockEntity instanceof BreedingWorkstationBlockEntity) {
                BreedingWorkstationBlockEntity ranchWorkstation = (BreedingWorkstationBlockEntity)blockEntity;
                ranchWorkstation.setWorkRangeLeft(packet.rangeLeft);
                ranchWorkstation.setWorkRangeRight(packet.rangeRight);
                ranchWorkstation.setWorkRangeUp(packet.rangeUp);
                ranchWorkstation.setShowRange(packet.showRange);
                ranchWorkstation.setMaxAnimals(packet.maxAnimals);
            }
        });
    }
}

