/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.structure.ConstructionManager;
import ydmsama.hundred_years_war.main.structure.ConstructionTask;

public class BuildCommandPacket {
    private final BlockPos buildPos;
    private final String templateName;
    private final Rotation rotation;

    public BuildCommandPacket(BlockPos buildPos, String templateName, Rotation rotation) {
        this.buildPos = buildPos;
        this.templateName = templateName;
        this.rotation = rotation;
    }

    public static void encode(BuildCommandPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.buildPos);
        buf.m_130070_(packet.templateName);
        buf.m_130068_((Enum)packet.rotation);
    }

    public static BuildCommandPacket decode(FriendlyByteBuf buf) {
        BlockPos buildPos = buf.m_130135_();
        String templateName = buf.m_130136_(Short.MAX_VALUE);
        Rotation rotation = (Rotation)buf.m_130066_(Rotation.class);
        return new BuildCommandPacket(buildPos, templateName, rotation);
    }

    public static void handle(BuildCommandPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                ResourceLocation structureLocation;
                ServerLevel serverLevel = (ServerLevel)((EntityAccessor)player).getLevel();
                StructureTemplateManager structureTemplateManager = serverLevel.m_215082_();
                Optional structureTemplateOptional = structureTemplateManager.m_230407_(structureLocation = new ResourceLocation("hundred_years_war", packet.templateName));
                if (structureTemplateOptional.isPresent()) {
                    StructureTemplate structureTemplate = (StructureTemplate)structureTemplateOptional.get();
                    BlockPos blockPos = packet.buildPos;
                    StructurePlaceSettings placeSettings = new StructurePlaceSettings().m_74379_(packet.rotation);
                    ConstructionTask task = new ConstructionTask(serverLevel, structureTemplate, placeSettings, blockPos, 1200, packet.templateName, 0, null);
                    ConstructionManager.addTask(task);
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)("Structure not found: " + packet.templateName)), false);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

