/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.HoldGoal;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class CommandPacket {
    private final String command;
    private final boolean queueMode;

    public CommandPacket(String command, boolean queueMode) {
        this.command = command;
        this.queueMode = queueMode;
    }

    public static void encode(CommandPacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.command);
        buf.writeBoolean(packet.queueMode);
    }

    public static CommandPacket decode(FriendlyByteBuf buf) {
        String command = buf.m_130277_();
        boolean queueMode = buf.readBoolean();
        return new CommandPacket(command, queueMode);
    }

    public static void handle(CommandPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            SelectionSystem.Selection selection;
            ServerPlayer player = context.getSender();
            if (player != null && (selection = SelectionSystem.getSelection(player)) != null) {
                if (packet.command.equals("hold")) {
                    for (BaseCombatEntity entity : selection.getEntities()) {
                        if (!packet.queueMode) {
                            entity.clearCommandedGoals();
                            entity.setHomePosition(entity.m_20183_());
                        }
                        entity.clearPatrolPoints();
                        entity.addCustomGoal(1, new HoldGoal(entity));
                    }
                }
                if (packet.command.equals("cancel")) {
                    List<BaseCombatEntity> entities = selection.getEntities();
                    PathingTaskManagerRegistry.getInstance().clearTasksForEntities(entities);
                    for (BaseCombatEntity entity : entities) {
                        entity.clearCommandedGoals();
                        entity.setHomePosition(entity.m_20183_());
                        entity.clearPatrolPoints();
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }
}

