/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationBlockEntity;

public class CraftingRecipeUpdatePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "crafting_recipe_update");
    private final BlockPos pos;
    private final ItemStack[] recipeTemplate;
    private final ItemStack expectedOutput;

    public CraftingRecipeUpdatePacket(BlockPos pos, ItemStack[] recipeTemplate, ItemStack expectedOutput) {
        this.pos = pos;
        this.recipeTemplate = recipeTemplate;
        this.expectedOutput = expectedOutput;
    }

    public static void encode(CraftingRecipeUpdatePacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        for (int i = 0; i < 9; ++i) {
            buf.m_130055_(packet.recipeTemplate[i]);
        }
        buf.m_130055_(packet.expectedOutput);
    }

    public static FriendlyByteBuf encode(BlockPos pos, ItemStack[] recipeTemplate, ItemStack expectedOutput) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        CraftingRecipeUpdatePacket packet = new CraftingRecipeUpdatePacket(pos, recipeTemplate, expectedOutput);
        CraftingRecipeUpdatePacket.encode(packet, buf);
        return buf;
    }

    public static CraftingRecipeUpdatePacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        ItemStack[] recipeTemplate = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            recipeTemplate[i] = buf.m_130267_();
        }
        ItemStack expectedOutput = buf.m_130267_();
        return new CraftingRecipeUpdatePacket(pos, recipeTemplate, expectedOutput);
    }

    public static void handle(CraftingRecipeUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                CraftingRecipeUpdatePacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, CraftingRecipeUpdatePacket packet) {
        BlockEntity blockEntity;
        if (player.m_9236_() != null && (blockEntity = player.m_9236_().m_7702_(packet.pos)) instanceof CraftingWorkstationBlockEntity) {
            CraftingWorkstationBlockEntity workstation = (CraftingWorkstationBlockEntity)blockEntity;
            for (int i = 0; i < 9; ++i) {
                workstation.setRecipeTemplateSlot(i, packet.recipeTemplate[i]);
            }
            workstation.setExpectedOutput(packet.expectedOutput);
            workstation.m_6596_();
        }
    }
}

