/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;

public class CreativeSettingsSyncPacket {
    private final boolean summonFriendly;
    private final boolean controlAllUnits;

    public CreativeSettingsSyncPacket(boolean summonFriendly, boolean controlAllUnits) {
        this.summonFriendly = summonFriendly;
        this.controlAllUnits = controlAllUnits;
    }

    public boolean isSummonFriendly() {
        return this.summonFriendly;
    }

    public boolean isControlAllUnits() {
        return this.controlAllUnits;
    }

    public static void encode(CreativeSettingsSyncPacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.summonFriendly);
        buf.writeBoolean(packet.controlAllUnits);
    }

    public static CreativeSettingsSyncPacket decode(FriendlyByteBuf buf) {
        boolean summonFriendly = buf.readBoolean();
        boolean controlAll = buf.readBoolean();
        return new CreativeSettingsSyncPacket(summonFriendly, controlAll);
    }

    public static void handle(CreativeSettingsSyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreativeSettingsSyncPacket.handlePacket(packet)));
        ctx.get().setPacketHandled(true);
    }

    private static void handlePacket(CreativeSettingsSyncPacket packet) {
        ClientPacketHandler.onCreativeSettingsSync(packet);
    }
}

