/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;

public class CreativeSettingsUpdatePacket {
    private final boolean summonFriendly;
    private final boolean controlAllUnits;

    public CreativeSettingsUpdatePacket(boolean summonFriendly, boolean controlAllUnits) {
        this.summonFriendly = summonFriendly;
        this.controlAllUnits = controlAllUnits;
    }

    public boolean isSummonFriendly() {
        return this.summonFriendly;
    }

    public boolean isControlAllUnits() {
        return this.controlAllUnits;
    }

    public static void encode(CreativeSettingsUpdatePacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.summonFriendly);
        buf.writeBoolean(packet.controlAllUnits);
    }

    public static CreativeSettingsUpdatePacket decode(FriendlyByteBuf buf) {
        boolean summonFriendly = buf.readBoolean();
        boolean controlAll = buf.readBoolean();
        return new CreativeSettingsUpdatePacket(summonFriendly, controlAll);
    }

    public static void handle(CreativeSettingsUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null && player.m_7500_()) {
                CreativeSettingsUpdatePacket.handlePacket(player, packet);
                ServerPacketHandler.sendCreativeSettingsSync(player);
            }
        });
        context.setPacketHandled(true);
    }

    private static void handlePacket(ServerPlayer player, CreativeSettingsUpdatePacket packet) {
        CreativeModeSettings.setSummonFriendly((Player)player, packet.isSummonFriendly());
        CreativeModeSettings.setControlAllUnits((Player)player, packet.isControlAllUnits());
    }
}

