/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationInventoryScreenHandler;

public class OpenCraftingInventoryPacket {
    private final BlockPos pos;

    public OpenCraftingInventoryPacket(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(OpenCraftingInventoryPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
    }

    public static OpenCraftingInventoryPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        return new OpenCraftingInventoryPacket(pos);
    }

    public static void handlePacket(ServerPlayer player, BlockPos pos) {
        Level world = player.m_9236_();
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CraftingWorkstationBlockEntity) {
            final CraftingWorkstationBlockEntity craftingWorkstation = (CraftingWorkstationBlockEntity)blockEntity;
            MenuProvider factory = new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237115_((String)"block.hundred_years_war.crafting_workstation");
                }

                public CraftingWorkstationInventoryScreenHandler createMenu(int syncId, Inventory playerInventory, Player player) {
                    return new CraftingWorkstationInventoryScreenHandler(syncId, playerInventory, craftingWorkstation);
                }
            };
            player.m_5893_(factory);
        }
    }

    public static void handle(OpenCraftingInventoryPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                OpenCraftingInventoryPacket.handlePacket(player, packet.pos);
            }
        });
        context.setPacketHandled(true);
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

