/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;

public class OpenWorkstationSyncPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "open_workstation_sync");
    private final UUID requestId;
    private final BlockPos pos;
    private final WorkstationType type;

    public OpenWorkstationSyncPacket(UUID requestId, BlockPos pos, WorkstationType type) {
        this.requestId = requestId;
        this.pos = pos;
        this.type = type;
    }

    public static void encode(OpenWorkstationSyncPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.requestId);
        buf.m_130064_(packet.pos);
        buf.m_130068_((Enum)packet.type);
    }

    public static OpenWorkstationSyncPacket decode(FriendlyByteBuf buf) {
        UUID requestId = buf.m_130259_();
        BlockPos pos = buf.m_130135_();
        WorkstationType type = (WorkstationType)buf.m_130066_(WorkstationType.class);
        return new OpenWorkstationSyncPacket(requestId, pos, type);
    }

    public static void handle(OpenWorkstationSyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ClientPacketHandler.onOpenWorkstationSync(packet);
            context.setPacketHandled(true);
        });
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public WorkstationType getType() {
        return this.type;
    }

    public static enum WorkstationType {
        FARMING,
        MINING,
        TRANSPORT,
        FISHING,
        LUMBER,
        CRAFTING,
        BREEDING;

    }
}

