/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;

public class PatrolPointsPacket {
    private final UUID entityUUID;
    private final List<BlockPos> patrolPoints;

    public UUID getEntityUUID() {
        return this.entityUUID;
    }

    public List<BlockPos> getPatrolPoints() {
        return this.patrolPoints;
    }

    public PatrolPointsPacket(UUID entityUUID, List<BlockPos> patrolPoints) {
        this.entityUUID = entityUUID;
        this.patrolPoints = patrolPoints;
    }

    public static void encode(PatrolPointsPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.entityUUID);
        buf.writeInt(packet.patrolPoints.size());
        for (BlockPos pos : packet.patrolPoints) {
            buf.m_130064_(pos);
        }
    }

    public static PatrolPointsPacket decode(FriendlyByteBuf buf) {
        UUID entityUUID = buf.m_130259_();
        int size = buf.readInt();
        ArrayList<BlockPos> patrolPoints = new ArrayList<BlockPos>();
        for (int i = 0; i < size; ++i) {
            patrolPoints.add(buf.m_130135_());
        }
        return new PatrolPointsPacket(entityUUID, patrolPoints);
    }

    public static void handle(PatrolPointsPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                Entity entity;
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ != null && (entity = PatrolPointsPacket.getEntityByUUID(packet.entityUUID)) != null) {
                    CopyOnWriteArrayList<BlockPos> patrolPoints = new CopyOnWriteArrayList<BlockPos>(packet.patrolPoints);
                    SelectionHandler.getInstance().getPatrolPointsMap().put(entity, patrolPoints);
                }
            });
        }
        context.setPacketHandled(true);
    }

    public static Entity getEntityByUUID(UUID uuid) {
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        if (clientWorld != null) {
            for (Entity entity : clientWorld.m_104735_()) {
                if (!entity.m_20148_().equals(uuid)) continue;
                return entity;
            }
        }
        return null;
    }
}

